package io.strimzi.api.kafka.model;

import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import io.strimzi.api.kafka.model.status.KafkaUserStatus;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.strimzi.api.kafka.model.status.KafkaUserStatusBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.strimzi.api.kafka.model.status.KafkaUserStatusFluentImpl;
import java.lang.StringBuffer;
import java.lang.Object;

public class KafkaUserFluentImpl<A extends KafkaUserFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements KafkaUserFluent<A> {

    private String apiVersion;
    private ObjectMetaBuilder metadata;
    private KafkaUserSpecBuilder spec;
    private KafkaUserStatusBuilder status;

    public KafkaUserFluentImpl() {
    }

    public KafkaUserFluentImpl(KafkaUser instance) {
        this.withApiVersion(instance.getApiVersion());
        
        this.withMetadata(instance.getMetadata());
        
        this.withSpec(instance.getSpec());
        
        this.withStatus(instance.getStatus());
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion=apiVersion; return (A) this;
    }

    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public A withNewApiVersion(StringBuilder arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(int[] arg1,int arg2,int arg3) {
        return (A)withApiVersion(new String(arg1, arg2, arg3));
    }

    public A withNewApiVersion(char[] arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuffer arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(byte[] arg1,int arg2) {
        return (A)withApiVersion(new String(arg1, arg2));
    }

    public A withNewApiVersion(byte[] arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(char[] arg1,int arg2,int arg3) {
        return (A)withApiVersion(new String(arg1, arg2, arg3));
    }

    public A withNewApiVersion(byte[] arg1,int arg2,int arg3) {
        return (A)withApiVersion(new String(arg1, arg2, arg3));
    }

    public A withNewApiVersion(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withApiVersion(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewApiVersion(String arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ObjectMeta getMetadata() {
        return this.metadata!=null?this.metadata.build():null;
    }

    public ObjectMeta buildMetadata() {
        return this.metadata!=null?this.metadata.build():null;
    }

    public A withMetadata(ObjectMeta metadata) {
        _visitables.get("metadata").remove(this.metadata);
        if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} return (A) this;
    }

    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    public KafkaUserFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    public KafkaUserFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    public KafkaUserFluent.MetadataNested<A> editMetadata() {
        return withNewMetadataLike(getMetadata());
    }

    public KafkaUserFluent.MetadataNested<A> editOrNewMetadata() {
        return withNewMetadataLike(getMetadata() != null ? getMetadata(): new ObjectMetaBuilder().build());
    }

    public KafkaUserFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
    }

    
/**
 * This method has been deprecated, please use method buildSpec instead.
 * @return The buildable object.
 */
@Deprecated public KafkaUserSpec getSpec() {
        return this.spec!=null?this.spec.build():null;
    }

    public KafkaUserSpec buildSpec() {
        return this.spec!=null?this.spec.build():null;
    }

    public A withSpec(KafkaUserSpec spec) {
        _visitables.get("spec").remove(this.spec);
        if (spec!=null){ this.spec= new KafkaUserSpecBuilder(spec); _visitables.get("spec").add(this.spec);} return (A) this;
    }

    public Boolean hasSpec() {
        return this.spec != null;
    }

    public KafkaUserFluent.SpecNested<A> withNewSpec() {
        return new SpecNestedImpl();
    }

    public KafkaUserFluent.SpecNested<A> withNewSpecLike(KafkaUserSpec item) {
        return new SpecNestedImpl(item);
    }

    public KafkaUserFluent.SpecNested<A> editSpec() {
        return withNewSpecLike(getSpec());
    }

    public KafkaUserFluent.SpecNested<A> editOrNewSpec() {
        return withNewSpecLike(getSpec() != null ? getSpec(): new KafkaUserSpecBuilder().build());
    }

    public KafkaUserFluent.SpecNested<A> editOrNewSpecLike(KafkaUserSpec item) {
        return withNewSpecLike(getSpec() != null ? getSpec(): item);
    }

    
/**
 * This method has been deprecated, please use method buildStatus instead.
 * @return The buildable object.
 */
@Deprecated public KafkaUserStatus getStatus() {
        return this.status!=null?this.status.build():null;
    }

    public KafkaUserStatus buildStatus() {
        return this.status!=null?this.status.build():null;
    }

    public A withStatus(KafkaUserStatus status) {
        _visitables.get("status").remove(this.status);
        if (status!=null){ this.status= new KafkaUserStatusBuilder(status); _visitables.get("status").add(this.status);} return (A) this;
    }

    public Boolean hasStatus() {
        return this.status != null;
    }

    public KafkaUserFluent.StatusNested<A> withNewStatus() {
        return new StatusNestedImpl();
    }

    public KafkaUserFluent.StatusNested<A> withNewStatusLike(KafkaUserStatus item) {
        return new StatusNestedImpl(item);
    }

    public KafkaUserFluent.StatusNested<A> editStatus() {
        return withNewStatusLike(getStatus());
    }

    public KafkaUserFluent.StatusNested<A> editOrNewStatus() {
        return withNewStatusLike(getStatus() != null ? getStatus(): new KafkaUserStatusBuilder().build());
    }

    public KafkaUserFluent.StatusNested<A> editOrNewStatusLike(KafkaUserStatus item) {
        return withNewStatusLike(getStatus() != null ? getStatus(): item);
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        KafkaUserFluentImpl that = (KafkaUserFluentImpl) o;
        if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
        if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
        if (spec != null ? !spec.equals(that.spec) :that.spec != null) return false;
        if (status != null ? !status.equals(that.status) :that.status != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(apiVersion,  metadata,  spec,  status,  super.hashCode());
    }

    public class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<KafkaUserFluent.MetadataNested<N>> implements KafkaUserFluent.MetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ObjectMetaBuilder builder;

            MetadataNestedImpl(ObjectMeta item) {
                this.builder = new ObjectMetaBuilder(this, item);
                        
            }

            MetadataNestedImpl() {
                this.builder = new ObjectMetaBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaUserFluentImpl.this.withMetadata(builder.build());
            }

            public N endMetadata() {
                return and();
            }
    }


    public class SpecNestedImpl<N> extends KafkaUserSpecFluentImpl<KafkaUserFluent.SpecNested<N>> implements KafkaUserFluent.SpecNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final KafkaUserSpecBuilder builder;

            SpecNestedImpl(KafkaUserSpec item) {
                this.builder = new KafkaUserSpecBuilder(this, item);
                        
            }

            SpecNestedImpl() {
                this.builder = new KafkaUserSpecBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaUserFluentImpl.this.withSpec(builder.build());
            }

            public N endSpec() {
                return and();
            }
    }


    public class StatusNestedImpl<N> extends KafkaUserStatusFluentImpl<KafkaUserFluent.StatusNested<N>> implements KafkaUserFluent.StatusNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final KafkaUserStatusBuilder builder;

            StatusNestedImpl(KafkaUserStatus item) {
                this.builder = new KafkaUserStatusBuilder(this, item);
                        
            }

            StatusNestedImpl() {
                this.builder = new KafkaUserStatusBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaUserFluentImpl.this.withStatus(builder.build());
            }

            public N endStatus() {
                return and();
            }
    }


}
