package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.strimzi.api.kafka.model.status.KafkaUserStatusBuilder;
import io.strimzi.api.kafka.model.status.KafkaUserStatusFluent;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Deprecated;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import io.strimzi.api.kafka.model.status.KafkaUserStatus;
import java.util.Map;

public interface KafkaUserFluent<A extends KafkaUserFluent<A>> extends Fluent<A> {


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(int[] arg1,int arg2,int arg3);
    public A withNewApiVersion(char[] arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public A withNewApiVersion(byte[] arg1,int arg2);
    public A withNewApiVersion(byte[] arg1);
    public A withNewApiVersion(char[] arg1,int arg2,int arg3);
    public A withNewApiVersion(byte[] arg1,int arg2,int arg3);
    public A withNewApiVersion(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewApiVersion(String arg1);
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ObjectMeta getMetadata();
    public ObjectMeta buildMetadata();
    public A withMetadata(ObjectMeta metadata);
    public Boolean hasMetadata();
    public KafkaUserFluent.MetadataNested<A> withNewMetadata();
    public KafkaUserFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public KafkaUserFluent.MetadataNested<A> editMetadata();
    public KafkaUserFluent.MetadataNested<A> editOrNewMetadata();
    public KafkaUserFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    
/**
 * This method has been deprecated, please use method buildSpec instead.
 * @return The buildable object.
 */
@Deprecated public KafkaUserSpec getSpec();
    public KafkaUserSpec buildSpec();
    public A withSpec(KafkaUserSpec spec);
    public Boolean hasSpec();
    public KafkaUserFluent.SpecNested<A> withNewSpec();
    public KafkaUserFluent.SpecNested<A> withNewSpecLike(KafkaUserSpec item);
    public KafkaUserFluent.SpecNested<A> editSpec();
    public KafkaUserFluent.SpecNested<A> editOrNewSpec();
    public KafkaUserFluent.SpecNested<A> editOrNewSpecLike(KafkaUserSpec item);
    
/**
 * This method has been deprecated, please use method buildStatus instead.
 * @return The buildable object.
 */
@Deprecated public KafkaUserStatus getStatus();
    public KafkaUserStatus buildStatus();
    public A withStatus(KafkaUserStatus status);
    public Boolean hasStatus();
    public KafkaUserFluent.StatusNested<A> withNewStatus();
    public KafkaUserFluent.StatusNested<A> withNewStatusLike(KafkaUserStatus item);
    public KafkaUserFluent.StatusNested<A> editStatus();
    public KafkaUserFluent.StatusNested<A> editOrNewStatus();
    public KafkaUserFluent.StatusNested<A> editOrNewStatusLike(KafkaUserStatus item);
    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectMetaFluent<KafkaUserFluent.MetadataNested<N>> {

            public N and();
            public N endMetadata();    }


    public interface SpecNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,KafkaUserSpecFluent<KafkaUserFluent.SpecNested<N>> {

            public N and();
            public N endSpec();    }


    public interface StatusNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,KafkaUserStatusFluent<KafkaUserFluent.StatusNested<N>> {

            public N and();
            public N endStatus();    }


}
