package io.strimzi.api.kafka.model;

import java.lang.Integer;
import java.lang.StringBuffer;
import java.lang.StringBuilder;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;
import java.util.Map;
import java.util.LinkedHashMap;

public class KafkaTopicSpecFluentImpl<A extends KafkaTopicSpecFluent<A>> extends SpecFluentImpl<A> implements KafkaTopicSpecFluent<A> {

    private String topicName;
    private Integer partitions;
    private Integer replicas;
    private Map<String,Object> config;

    public KafkaTopicSpecFluentImpl() {
    }

    public KafkaTopicSpecFluentImpl(KafkaTopicSpec instance) {
        this.withTopicName(instance.getTopicName());
        
        this.withPartitions(instance.getPartitions());
        
        this.withReplicas(instance.getReplicas());
        
        this.withConfig(instance.getConfig());
    }

    public String getTopicName() {
        return this.topicName;
    }

    public A withTopicName(String topicName) {
        this.topicName=topicName; return (A) this;
    }

    public Boolean hasTopicName() {
        return this.topicName != null;
    }

    public A withNewTopicName(StringBuilder arg1) {
        return (A)withTopicName(new String(arg1));
    }

    public A withNewTopicName(int[] arg1,int arg2,int arg3) {
        return (A)withTopicName(new String(arg1, arg2, arg3));
    }

    public A withNewTopicName(char[] arg1) {
        return (A)withTopicName(new String(arg1));
    }

    public A withNewTopicName(StringBuffer arg1) {
        return (A)withTopicName(new String(arg1));
    }

    public A withNewTopicName(byte[] arg1,int arg2) {
        return (A)withTopicName(new String(arg1, arg2));
    }

    public A withNewTopicName(byte[] arg1) {
        return (A)withTopicName(new String(arg1));
    }

    public A withNewTopicName(char[] arg1,int arg2,int arg3) {
        return (A)withTopicName(new String(arg1, arg2, arg3));
    }

    public A withNewTopicName(byte[] arg1,int arg2,int arg3) {
        return (A)withTopicName(new String(arg1, arg2, arg3));
    }

    public A withNewTopicName(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withTopicName(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewTopicName(String arg1) {
        return (A)withTopicName(new String(arg1));
    }

    public Integer getPartitions() {
        return this.partitions;
    }

    public A withPartitions(Integer partitions) {
        this.partitions=partitions; return (A) this;
    }

    public Boolean hasPartitions() {
        return this.partitions != null;
    }

    public Integer getReplicas() {
        return this.replicas;
    }

    public A withReplicas(Integer replicas) {
        this.replicas=replicas; return (A) this;
    }

    public Boolean hasReplicas() {
        return this.replicas != null;
    }

    public A addToConfig(String key,Object value) {
        if(this.config == null && key != null && value != null) { this.config = new LinkedHashMap<String,Object>(); }
        if(key != null && value != null) {this.config.put(key, value);} return (A)this;
    }

    public A addToConfig(Map<String,Object> map) {
        if(this.config == null && map != null) { this.config = new LinkedHashMap<String,Object>(); }
        if(map != null) { this.config.putAll(map);} return (A)this;
    }

    public A removeFromConfig(String key) {
        if(this.config == null) { return (A) this; }
        if(key != null && this.config != null) {this.config.remove(key);} return (A)this;
    }

    public A removeFromConfig(Map<String,Object> map) {
        if(this.config == null) { return (A) this; }
        if(map != null) { for(Object key : map.keySet()) {if (this.config != null){this.config.remove(key);}}} return (A)this;
    }

    public Map<String,Object> getConfig() {
        return this.config;
    }

    public <K extends Object,V extends Object>A withConfig(Map<String,Object> config) {
        if (config == null) { this.config =  null;} else {this.config = new LinkedHashMap<String,Object>(config);} return (A) this;
    }

    public Boolean hasConfig() {
        return this.config != null;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KafkaTopicSpecFluentImpl that = (KafkaTopicSpecFluentImpl) o;
        if (topicName != null ? !topicName.equals(that.topicName) :that.topicName != null) return false;
        if (partitions != null ? !partitions.equals(that.partitions) :that.partitions != null) return false;
        if (replicas != null ? !replicas.equals(that.replicas) :that.replicas != null) return false;
        if (config != null ? !config.equals(that.config) :that.config != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(topicName,  partitions,  replicas,  config,  super.hashCode());
    }

}
