package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class KafkaTopicBuilder extends KafkaTopicFluentImpl<KafkaTopicBuilder> implements VisitableBuilder<KafkaTopic,KafkaTopicBuilder> {

    KafkaTopicFluent<?> fluent;
    Boolean validationEnabled;

    public KafkaTopicBuilder() {
        this(true);
    }

    public KafkaTopicBuilder(Boolean validationEnabled) {
        this(new KafkaTopic(), validationEnabled);
    }

    public KafkaTopicBuilder(KafkaTopicFluent<?> fluent) {
        this(fluent, true);
    }

    public KafkaTopicBuilder(KafkaTopicFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new KafkaTopic(), validationEnabled);
    }

    public KafkaTopicBuilder(KafkaTopicFluent<?> fluent,KafkaTopic instance) {
        this(fluent, instance, true);
    }

    public KafkaTopicBuilder(KafkaTopicFluent<?> fluent,KafkaTopic instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion());
        
        fluent.withMetadata(instance.getMetadata());
        
        fluent.withSpec(instance.getSpec());
        
        fluent.withStatus(instance.getStatus());
        
        this.validationEnabled = validationEnabled; 
    }

    public KafkaTopicBuilder(KafkaTopic instance) {
        this(instance,true);
    }

    public KafkaTopicBuilder(KafkaTopic instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion());
        
        this.withMetadata(instance.getMetadata());
        
        this.withSpec(instance.getSpec());
        
        this.withStatus(instance.getStatus());
        
        this.validationEnabled = validationEnabled; 
    }

    public KafkaTopic build() {
        KafkaTopic buildable = new KafkaTopic();
        buildable.setApiVersion(fluent.getApiVersion());
        buildable.setMetadata(fluent.getMetadata());
        buildable.setSpec(fluent.getSpec());
        buildable.setStatus(fluent.getStatus());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KafkaTopicBuilder that = (KafkaTopicBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
