package io.strimzi.api.kafka.model;

import java.lang.StringBuilder;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.StringBuffer;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class KafkaRebalanceSpecFluentImpl<A extends KafkaRebalanceSpecFluent<A>> extends SpecFluentImpl<A> implements KafkaRebalanceSpecFluent<A> {

    private java.util.List<String> goals;
    private boolean skipHardGoalCheck;
    private String excludedTopics;
    private int concurrentPartitionMovementsPerBroker;
    private int concurrentIntraBrokerPartitionMovements;
    private int concurrentLeaderMovements;
    private long replicationThrottle;
    private java.util.List<String> replicaMovementStrategies;

    public KafkaRebalanceSpecFluentImpl() {
    }

    public KafkaRebalanceSpecFluentImpl(KafkaRebalanceSpec instance) {
        this.withGoals(instance.getGoals());
        
        this.withSkipHardGoalCheck(instance.isSkipHardGoalCheck());
        
        this.withExcludedTopics(instance.getExcludedTopics());
        
        this.withConcurrentPartitionMovementsPerBroker(instance.getConcurrentPartitionMovementsPerBroker());
        
        this.withConcurrentIntraBrokerPartitionMovements(instance.getConcurrentIntraBrokerPartitionMovements());
        
        this.withConcurrentLeaderMovements(instance.getConcurrentLeaderMovements());
        
        this.withReplicationThrottle(instance.getReplicationThrottle());
        
        this.withReplicaMovementStrategies(instance.getReplicaMovementStrategies());
    }

    public A addToGoals(int index,String item) {
        if (this.goals == null) {this.goals = new ArrayList<String>();}
        this.goals.add(index, item);
        return (A)this;
    }

    public A setToGoals(int index,String item) {
        if (this.goals == null) {this.goals = new ArrayList<String>();}
        this.goals.set(index, item); return (A)this;
    }

    public A addToGoals(String... items) {
        if (this.goals == null) {this.goals = new ArrayList<String>();}
        for (String item : items) {this.goals.add(item);} return (A)this;
    }

    public A addAllToGoals(Collection<String> items) {
        if (this.goals == null) {this.goals = new ArrayList<String>();}
        for (String item : items) {this.goals.add(item);} return (A)this;
    }

    public A removeFromGoals(String... items) {
        for (String item : items) {if (this.goals!= null){ this.goals.remove(item);}} return (A)this;
    }

    public A removeAllFromGoals(Collection<String> items) {
        for (String item : items) {if (this.goals!= null){ this.goals.remove(item);}} return (A)this;
    }

    public java.util.List<String> getGoals() {
        return this.goals;
    }

    public String getGoal(int index) {
        return this.goals.get(index);
    }

    public String getFirstGoal() {
        return this.goals.get(0);
    }

    public String getLastGoal() {
        return this.goals.get(goals.size() - 1);
    }

    public String getMatchingGoal(Predicate<String> predicate) {
        for (String item: goals) { if(predicate.test(item)){ return item;} } return null;
    }

    public Boolean hasMatchingGoal(Predicate<String> predicate) {
        for (String item: goals) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withGoals(java.util.List<String> goals) {
        if (this.goals != null) { _visitables.get("goals").removeAll(this.goals);}
        if (goals != null) {this.goals = new ArrayList<String>(); for (String item : goals){this.addToGoals(item);}} else { this.goals = null;} return (A) this;
    }

    public A withGoals(String... goals) {
        if (this.goals != null) {this.goals.clear();}
        if (goals != null) {for (String item :goals){ this.addToGoals(item);}} return (A) this;
    }

    public Boolean hasGoals() {
        return goals != null && !goals.isEmpty();
    }

    public A addNewGoal(StringBuilder arg1) {
        return (A)addToGoals(new String(arg1));
    }

    public A addNewGoal(int[] arg1,int arg2,int arg3) {
        return (A)addToGoals(new String(arg1, arg2, arg3));
    }

    public A addNewGoal(char[] arg1) {
        return (A)addToGoals(new String(arg1));
    }

    public A addNewGoal(StringBuffer arg1) {
        return (A)addToGoals(new String(arg1));
    }

    public A addNewGoal(byte[] arg1,int arg2) {
        return (A)addToGoals(new String(arg1, arg2));
    }

    public A addNewGoal(byte[] arg1) {
        return (A)addToGoals(new String(arg1));
    }

    public A addNewGoal(char[] arg1,int arg2,int arg3) {
        return (A)addToGoals(new String(arg1, arg2, arg3));
    }

    public A addNewGoal(byte[] arg1,int arg2,int arg3) {
        return (A)addToGoals(new String(arg1, arg2, arg3));
    }

    public A addNewGoal(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)addToGoals(new String(arg1, arg2, arg3, arg4));
    }

    public A addNewGoal(String arg1) {
        return (A)addToGoals(new String(arg1));
    }

    public boolean isSkipHardGoalCheck() {
        return this.skipHardGoalCheck;
    }

    public A withSkipHardGoalCheck(boolean skipHardGoalCheck) {
        this.skipHardGoalCheck=skipHardGoalCheck; return (A) this;
    }

    public Boolean hasSkipHardGoalCheck() {
        return true;
    }

    public String getExcludedTopics() {
        return this.excludedTopics;
    }

    public A withExcludedTopics(String excludedTopics) {
        this.excludedTopics=excludedTopics; return (A) this;
    }

    public Boolean hasExcludedTopics() {
        return this.excludedTopics != null;
    }

    public A withNewExcludedTopics(StringBuilder arg1) {
        return (A)withExcludedTopics(new String(arg1));
    }

    public A withNewExcludedTopics(int[] arg1,int arg2,int arg3) {
        return (A)withExcludedTopics(new String(arg1, arg2, arg3));
    }

    public A withNewExcludedTopics(char[] arg1) {
        return (A)withExcludedTopics(new String(arg1));
    }

    public A withNewExcludedTopics(StringBuffer arg1) {
        return (A)withExcludedTopics(new String(arg1));
    }

    public A withNewExcludedTopics(byte[] arg1,int arg2) {
        return (A)withExcludedTopics(new String(arg1, arg2));
    }

    public A withNewExcludedTopics(byte[] arg1) {
        return (A)withExcludedTopics(new String(arg1));
    }

    public A withNewExcludedTopics(char[] arg1,int arg2,int arg3) {
        return (A)withExcludedTopics(new String(arg1, arg2, arg3));
    }

    public A withNewExcludedTopics(byte[] arg1,int arg2,int arg3) {
        return (A)withExcludedTopics(new String(arg1, arg2, arg3));
    }

    public A withNewExcludedTopics(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withExcludedTopics(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewExcludedTopics(String arg1) {
        return (A)withExcludedTopics(new String(arg1));
    }

    public int getConcurrentPartitionMovementsPerBroker() {
        return this.concurrentPartitionMovementsPerBroker;
    }

    public A withConcurrentPartitionMovementsPerBroker(int concurrentPartitionMovementsPerBroker) {
        this.concurrentPartitionMovementsPerBroker=concurrentPartitionMovementsPerBroker; return (A) this;
    }

    public Boolean hasConcurrentPartitionMovementsPerBroker() {
        return true;
    }

    public int getConcurrentIntraBrokerPartitionMovements() {
        return this.concurrentIntraBrokerPartitionMovements;
    }

    public A withConcurrentIntraBrokerPartitionMovements(int concurrentIntraBrokerPartitionMovements) {
        this.concurrentIntraBrokerPartitionMovements=concurrentIntraBrokerPartitionMovements; return (A) this;
    }

    public Boolean hasConcurrentIntraBrokerPartitionMovements() {
        return true;
    }

    public int getConcurrentLeaderMovements() {
        return this.concurrentLeaderMovements;
    }

    public A withConcurrentLeaderMovements(int concurrentLeaderMovements) {
        this.concurrentLeaderMovements=concurrentLeaderMovements; return (A) this;
    }

    public Boolean hasConcurrentLeaderMovements() {
        return true;
    }

    public long getReplicationThrottle() {
        return this.replicationThrottle;
    }

    public A withReplicationThrottle(long replicationThrottle) {
        this.replicationThrottle=replicationThrottle; return (A) this;
    }

    public Boolean hasReplicationThrottle() {
        return true;
    }

    public A addToReplicaMovementStrategies(int index,String item) {
        if (this.replicaMovementStrategies == null) {this.replicaMovementStrategies = new ArrayList<String>();}
        this.replicaMovementStrategies.add(index, item);
        return (A)this;
    }

    public A setToReplicaMovementStrategies(int index,String item) {
        if (this.replicaMovementStrategies == null) {this.replicaMovementStrategies = new ArrayList<String>();}
        this.replicaMovementStrategies.set(index, item); return (A)this;
    }

    public A addToReplicaMovementStrategies(String... items) {
        if (this.replicaMovementStrategies == null) {this.replicaMovementStrategies = new ArrayList<String>();}
        for (String item : items) {this.replicaMovementStrategies.add(item);} return (A)this;
    }

    public A addAllToReplicaMovementStrategies(Collection<String> items) {
        if (this.replicaMovementStrategies == null) {this.replicaMovementStrategies = new ArrayList<String>();}
        for (String item : items) {this.replicaMovementStrategies.add(item);} return (A)this;
    }

    public A removeFromReplicaMovementStrategies(String... items) {
        for (String item : items) {if (this.replicaMovementStrategies!= null){ this.replicaMovementStrategies.remove(item);}} return (A)this;
    }

    public A removeAllFromReplicaMovementStrategies(Collection<String> items) {
        for (String item : items) {if (this.replicaMovementStrategies!= null){ this.replicaMovementStrategies.remove(item);}} return (A)this;
    }

    public java.util.List<String> getReplicaMovementStrategies() {
        return this.replicaMovementStrategies;
    }

    public String getReplicaMovementStrategy(int index) {
        return this.replicaMovementStrategies.get(index);
    }

    public String getFirstReplicaMovementStrategy() {
        return this.replicaMovementStrategies.get(0);
    }

    public String getLastReplicaMovementStrategy() {
        return this.replicaMovementStrategies.get(replicaMovementStrategies.size() - 1);
    }

    public String getMatchingReplicaMovementStrategy(Predicate<String> predicate) {
        for (String item: replicaMovementStrategies) { if(predicate.test(item)){ return item;} } return null;
    }

    public Boolean hasMatchingReplicaMovementStrategy(Predicate<String> predicate) {
        for (String item: replicaMovementStrategies) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withReplicaMovementStrategies(java.util.List<String> replicaMovementStrategies) {
        if (this.replicaMovementStrategies != null) { _visitables.get("replicaMovementStrategies").removeAll(this.replicaMovementStrategies);}
        if (replicaMovementStrategies != null) {this.replicaMovementStrategies = new ArrayList<String>(); for (String item : replicaMovementStrategies){this.addToReplicaMovementStrategies(item);}} else { this.replicaMovementStrategies = null;} return (A) this;
    }

    public A withReplicaMovementStrategies(String... replicaMovementStrategies) {
        if (this.replicaMovementStrategies != null) {this.replicaMovementStrategies.clear();}
        if (replicaMovementStrategies != null) {for (String item :replicaMovementStrategies){ this.addToReplicaMovementStrategies(item);}} return (A) this;
    }

    public Boolean hasReplicaMovementStrategies() {
        return replicaMovementStrategies != null && !replicaMovementStrategies.isEmpty();
    }

    public A addNewReplicaMovementStrategy(StringBuilder arg1) {
        return (A)addToReplicaMovementStrategies(new String(arg1));
    }

    public A addNewReplicaMovementStrategy(int[] arg1,int arg2,int arg3) {
        return (A)addToReplicaMovementStrategies(new String(arg1, arg2, arg3));
    }

    public A addNewReplicaMovementStrategy(char[] arg1) {
        return (A)addToReplicaMovementStrategies(new String(arg1));
    }

    public A addNewReplicaMovementStrategy(StringBuffer arg1) {
        return (A)addToReplicaMovementStrategies(new String(arg1));
    }

    public A addNewReplicaMovementStrategy(byte[] arg1,int arg2) {
        return (A)addToReplicaMovementStrategies(new String(arg1, arg2));
    }

    public A addNewReplicaMovementStrategy(byte[] arg1) {
        return (A)addToReplicaMovementStrategies(new String(arg1));
    }

    public A addNewReplicaMovementStrategy(char[] arg1,int arg2,int arg3) {
        return (A)addToReplicaMovementStrategies(new String(arg1, arg2, arg3));
    }

    public A addNewReplicaMovementStrategy(byte[] arg1,int arg2,int arg3) {
        return (A)addToReplicaMovementStrategies(new String(arg1, arg2, arg3));
    }

    public A addNewReplicaMovementStrategy(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)addToReplicaMovementStrategies(new String(arg1, arg2, arg3, arg4));
    }

    public A addNewReplicaMovementStrategy(String arg1) {
        return (A)addToReplicaMovementStrategies(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KafkaRebalanceSpecFluentImpl that = (KafkaRebalanceSpecFluentImpl) o;
        if (goals != null ? !goals.equals(that.goals) :that.goals != null) return false;
        if (skipHardGoalCheck != that.skipHardGoalCheck) return false;
        if (excludedTopics != null ? !excludedTopics.equals(that.excludedTopics) :that.excludedTopics != null) return false;
        if (concurrentPartitionMovementsPerBroker != that.concurrentPartitionMovementsPerBroker) return false;
        if (concurrentIntraBrokerPartitionMovements != that.concurrentIntraBrokerPartitionMovements) return false;
        if (concurrentLeaderMovements != that.concurrentLeaderMovements) return false;
        if (replicationThrottle != that.replicationThrottle) return false;
        if (replicaMovementStrategies != null ? !replicaMovementStrategies.equals(that.replicaMovementStrategies) :that.replicaMovementStrategies != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(goals,  skipHardGoalCheck,  excludedTopics,  concurrentPartitionMovementsPerBroker,  concurrentIntraBrokerPartitionMovements,  concurrentLeaderMovements,  replicationThrottle,  replicaMovementStrategies,  super.hashCode());
    }

}
