package io.strimzi.api.kafka.model;

import io.strimzi.api.kafka.model.status.KafkaMirrorMakerStatus;
import java.lang.StringBuilder;
import io.strimzi.api.kafka.model.status.KafkaMirrorMakerStatusBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.Deprecated;
import io.strimzi.api.kafka.model.status.KafkaMirrorMakerStatusFluentImpl;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.StringBuffer;
import java.lang.Object;

public class KafkaMirrorMakerFluentImpl<A extends KafkaMirrorMakerFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements KafkaMirrorMakerFluent<A> {

    private String apiVersion;
    private ObjectMetaBuilder metadata;
    private KafkaMirrorMakerSpecBuilder spec;
    private KafkaMirrorMakerStatusBuilder status;

    public KafkaMirrorMakerFluentImpl() {
    }

    public KafkaMirrorMakerFluentImpl(KafkaMirrorMaker instance) {
        this.withApiVersion(instance.getApiVersion());
        
        this.withMetadata(instance.getMetadata());
        
        this.withSpec(instance.getSpec());
        
        this.withStatus(instance.getStatus());
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion=apiVersion; return (A) this;
    }

    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public A withNewApiVersion(StringBuilder arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(int[] arg1,int arg2,int arg3) {
        return (A)withApiVersion(new String(arg1, arg2, arg3));
    }

    public A withNewApiVersion(char[] arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuffer arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(byte[] arg1,int arg2) {
        return (A)withApiVersion(new String(arg1, arg2));
    }

    public A withNewApiVersion(byte[] arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(char[] arg1,int arg2,int arg3) {
        return (A)withApiVersion(new String(arg1, arg2, arg3));
    }

    public A withNewApiVersion(byte[] arg1,int arg2,int arg3) {
        return (A)withApiVersion(new String(arg1, arg2, arg3));
    }

    public A withNewApiVersion(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withApiVersion(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewApiVersion(String arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ObjectMeta getMetadata() {
        return this.metadata!=null?this.metadata.build():null;
    }

    public ObjectMeta buildMetadata() {
        return this.metadata!=null?this.metadata.build():null;
    }

    public A withMetadata(ObjectMeta metadata) {
        _visitables.get("metadata").remove(this.metadata);
        if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} return (A) this;
    }

    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    public KafkaMirrorMakerFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    public KafkaMirrorMakerFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    public KafkaMirrorMakerFluent.MetadataNested<A> editMetadata() {
        return withNewMetadataLike(getMetadata());
    }

    public KafkaMirrorMakerFluent.MetadataNested<A> editOrNewMetadata() {
        return withNewMetadataLike(getMetadata() != null ? getMetadata(): new ObjectMetaBuilder().build());
    }

    public KafkaMirrorMakerFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
    }

    
/**
 * This method has been deprecated, please use method buildSpec instead.
 * @return The buildable object.
 */
@Deprecated public KafkaMirrorMakerSpec getSpec() {
        return this.spec!=null?this.spec.build():null;
    }

    public KafkaMirrorMakerSpec buildSpec() {
        return this.spec!=null?this.spec.build():null;
    }

    public A withSpec(KafkaMirrorMakerSpec spec) {
        _visitables.get("spec").remove(this.spec);
        if (spec!=null){ this.spec= new KafkaMirrorMakerSpecBuilder(spec); _visitables.get("spec").add(this.spec);} return (A) this;
    }

    public Boolean hasSpec() {
        return this.spec != null;
    }

    public KafkaMirrorMakerFluent.SpecNested<A> withNewSpec() {
        return new SpecNestedImpl();
    }

    public KafkaMirrorMakerFluent.SpecNested<A> withNewSpecLike(KafkaMirrorMakerSpec item) {
        return new SpecNestedImpl(item);
    }

    public KafkaMirrorMakerFluent.SpecNested<A> editSpec() {
        return withNewSpecLike(getSpec());
    }

    public KafkaMirrorMakerFluent.SpecNested<A> editOrNewSpec() {
        return withNewSpecLike(getSpec() != null ? getSpec(): new KafkaMirrorMakerSpecBuilder().build());
    }

    public KafkaMirrorMakerFluent.SpecNested<A> editOrNewSpecLike(KafkaMirrorMakerSpec item) {
        return withNewSpecLike(getSpec() != null ? getSpec(): item);
    }

    
/**
 * This method has been deprecated, please use method buildStatus instead.
 * @return The buildable object.
 */
@Deprecated public KafkaMirrorMakerStatus getStatus() {
        return this.status!=null?this.status.build():null;
    }

    public KafkaMirrorMakerStatus buildStatus() {
        return this.status!=null?this.status.build():null;
    }

    public A withStatus(KafkaMirrorMakerStatus status) {
        _visitables.get("status").remove(this.status);
        if (status!=null){ this.status= new KafkaMirrorMakerStatusBuilder(status); _visitables.get("status").add(this.status);} return (A) this;
    }

    public Boolean hasStatus() {
        return this.status != null;
    }

    public KafkaMirrorMakerFluent.StatusNested<A> withNewStatus() {
        return new StatusNestedImpl();
    }

    public KafkaMirrorMakerFluent.StatusNested<A> withNewStatusLike(KafkaMirrorMakerStatus item) {
        return new StatusNestedImpl(item);
    }

    public KafkaMirrorMakerFluent.StatusNested<A> editStatus() {
        return withNewStatusLike(getStatus());
    }

    public KafkaMirrorMakerFluent.StatusNested<A> editOrNewStatus() {
        return withNewStatusLike(getStatus() != null ? getStatus(): new KafkaMirrorMakerStatusBuilder().build());
    }

    public KafkaMirrorMakerFluent.StatusNested<A> editOrNewStatusLike(KafkaMirrorMakerStatus item) {
        return withNewStatusLike(getStatus() != null ? getStatus(): item);
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        KafkaMirrorMakerFluentImpl that = (KafkaMirrorMakerFluentImpl) o;
        if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
        if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
        if (spec != null ? !spec.equals(that.spec) :that.spec != null) return false;
        if (status != null ? !status.equals(that.status) :that.status != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(apiVersion,  metadata,  spec,  status,  super.hashCode());
    }

    public class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<KafkaMirrorMakerFluent.MetadataNested<N>> implements KafkaMirrorMakerFluent.MetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ObjectMetaBuilder builder;

            MetadataNestedImpl(ObjectMeta item) {
                this.builder = new ObjectMetaBuilder(this, item);
                        
            }

            MetadataNestedImpl() {
                this.builder = new ObjectMetaBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaMirrorMakerFluentImpl.this.withMetadata(builder.build());
            }

            public N endMetadata() {
                return and();
            }
    }


    public class SpecNestedImpl<N> extends KafkaMirrorMakerSpecFluentImpl<KafkaMirrorMakerFluent.SpecNested<N>> implements KafkaMirrorMakerFluent.SpecNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final KafkaMirrorMakerSpecBuilder builder;

            SpecNestedImpl(KafkaMirrorMakerSpec item) {
                this.builder = new KafkaMirrorMakerSpecBuilder(this, item);
                        
            }

            SpecNestedImpl() {
                this.builder = new KafkaMirrorMakerSpecBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaMirrorMakerFluentImpl.this.withSpec(builder.build());
            }

            public N endSpec() {
                return and();
            }
    }


    public class StatusNestedImpl<N> extends KafkaMirrorMakerStatusFluentImpl<KafkaMirrorMakerFluent.StatusNested<N>> implements KafkaMirrorMakerFluent.StatusNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final KafkaMirrorMakerStatusBuilder builder;

            StatusNestedImpl(KafkaMirrorMakerStatus item) {
                this.builder = new KafkaMirrorMakerStatusBuilder(this, item);
                        
            }

            StatusNestedImpl() {
                this.builder = new KafkaMirrorMakerStatusBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaMirrorMakerFluentImpl.this.withStatus(builder.build());
            }

            public N endStatus() {
                return and();
            }
    }


}
