package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class KafkaMirrorMakerConsumerSpecBuilder extends KafkaMirrorMakerConsumerSpecFluentImpl<KafkaMirrorMakerConsumerSpecBuilder> implements VisitableBuilder<KafkaMirrorMakerConsumerSpec,KafkaMirrorMakerConsumerSpecBuilder> {

    KafkaMirrorMakerConsumerSpecFluent<?> fluent;
    Boolean validationEnabled;

    public KafkaMirrorMakerConsumerSpecBuilder() {
        this(true);
    }

    public KafkaMirrorMakerConsumerSpecBuilder(Boolean validationEnabled) {
        this(new KafkaMirrorMakerConsumerSpec(), validationEnabled);
    }

    public KafkaMirrorMakerConsumerSpecBuilder(KafkaMirrorMakerConsumerSpecFluent<?> fluent) {
        this(fluent, true);
    }

    public KafkaMirrorMakerConsumerSpecBuilder(KafkaMirrorMakerConsumerSpecFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new KafkaMirrorMakerConsumerSpec(), validationEnabled);
    }

    public KafkaMirrorMakerConsumerSpecBuilder(KafkaMirrorMakerConsumerSpecFluent<?> fluent,KafkaMirrorMakerConsumerSpec instance) {
        this(fluent, instance, true);
    }

    public KafkaMirrorMakerConsumerSpecBuilder(KafkaMirrorMakerConsumerSpecFluent<?> fluent,KafkaMirrorMakerConsumerSpec instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withNumStreams(instance.getNumStreams());
        
        fluent.withGroupId(instance.getGroupId());
        
        fluent.withOffsetCommitInterval(instance.getOffsetCommitInterval());
        
        fluent.withBootstrapServers(instance.getBootstrapServers());
        
        fluent.withConfig(instance.getConfig());
        
        fluent.withTls(instance.getTls());
        
        fluent.withAuthentication(instance.getAuthentication());
        
        this.validationEnabled = validationEnabled; 
    }

    public KafkaMirrorMakerConsumerSpecBuilder(KafkaMirrorMakerConsumerSpec instance) {
        this(instance,true);
    }

    public KafkaMirrorMakerConsumerSpecBuilder(KafkaMirrorMakerConsumerSpec instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withNumStreams(instance.getNumStreams());
        
        this.withGroupId(instance.getGroupId());
        
        this.withOffsetCommitInterval(instance.getOffsetCommitInterval());
        
        this.withBootstrapServers(instance.getBootstrapServers());
        
        this.withConfig(instance.getConfig());
        
        this.withTls(instance.getTls());
        
        this.withAuthentication(instance.getAuthentication());
        
        this.validationEnabled = validationEnabled; 
    }

    public KafkaMirrorMakerConsumerSpec build() {
        KafkaMirrorMakerConsumerSpec buildable = new KafkaMirrorMakerConsumerSpec();
        buildable.setBootstrapServers(fluent.getBootstrapServers());
        buildable.setConfig(fluent.getConfig());
        buildable.setTls(fluent.getTls());
        buildable.setAuthentication(fluent.getAuthentication());
        buildable.setNumStreams(fluent.getNumStreams());
        buildable.setGroupId(fluent.getGroupId());
        buildable.setOffsetCommitInterval(fluent.getOffsetCommitInterval());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KafkaMirrorMakerConsumerSpecBuilder that = (KafkaMirrorMakerConsumerSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
