package io.strimzi.api.kafka.model;

import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuthBuilder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha512FluentImpl;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha512Builder;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuth;
import java.lang.Deprecated;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationTlsFluentImpl;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationPlainBuilder;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationTlsBuilder;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationPlain;
import java.lang.Boolean;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationPlainFluentImpl;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha512;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationTls;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuthFluentImpl;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthentication;
import java.lang.StringBuffer;
import java.lang.Object;
import java.util.Map;

public class KafkaMirrorMakerClientSpecFluentImpl<A extends KafkaMirrorMakerClientSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements KafkaMirrorMakerClientSpecFluent<A> {

    private String bootstrapServers;
    private Map<String,Object> config;
    private KafkaMirrorMakerTlsBuilder tls;
    private VisitableBuilder<? extends KafkaClientAuthentication,?> authentication;

    public KafkaMirrorMakerClientSpecFluentImpl() {
    }

    public KafkaMirrorMakerClientSpecFluentImpl(KafkaMirrorMakerClientSpec instance) {
        this.withBootstrapServers(instance.getBootstrapServers());
        
        this.withConfig(instance.getConfig());
        
        this.withTls(instance.getTls());
        
        this.withAuthentication(instance.getAuthentication());
    }

    public String getBootstrapServers() {
        return this.bootstrapServers;
    }

    public A withBootstrapServers(String bootstrapServers) {
        this.bootstrapServers=bootstrapServers; return (A) this;
    }

    public Boolean hasBootstrapServers() {
        return this.bootstrapServers != null;
    }

    public A withNewBootstrapServers(StringBuilder arg1) {
        return (A)withBootstrapServers(new String(arg1));
    }

    public A withNewBootstrapServers(int[] arg1,int arg2,int arg3) {
        return (A)withBootstrapServers(new String(arg1, arg2, arg3));
    }

    public A withNewBootstrapServers(char[] arg1) {
        return (A)withBootstrapServers(new String(arg1));
    }

    public A withNewBootstrapServers(StringBuffer arg1) {
        return (A)withBootstrapServers(new String(arg1));
    }

    public A withNewBootstrapServers(byte[] arg1,int arg2) {
        return (A)withBootstrapServers(new String(arg1, arg2));
    }

    public A withNewBootstrapServers(byte[] arg1) {
        return (A)withBootstrapServers(new String(arg1));
    }

    public A withNewBootstrapServers(char[] arg1,int arg2,int arg3) {
        return (A)withBootstrapServers(new String(arg1, arg2, arg3));
    }

    public A withNewBootstrapServers(byte[] arg1,int arg2,int arg3) {
        return (A)withBootstrapServers(new String(arg1, arg2, arg3));
    }

    public A withNewBootstrapServers(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withBootstrapServers(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewBootstrapServers(String arg1) {
        return (A)withBootstrapServers(new String(arg1));
    }

    public A addToConfig(String key,Object value) {
        if(this.config == null && key != null && value != null) { this.config = new LinkedHashMap<String,Object>(); }
        if(key != null && value != null) {this.config.put(key, value);} return (A)this;
    }

    public A addToConfig(Map<String,Object> map) {
        if(this.config == null && map != null) { this.config = new LinkedHashMap<String,Object>(); }
        if(map != null) { this.config.putAll(map);} return (A)this;
    }

    public A removeFromConfig(String key) {
        if(this.config == null) { return (A) this; }
        if(key != null && this.config != null) {this.config.remove(key);} return (A)this;
    }

    public A removeFromConfig(Map<String,Object> map) {
        if(this.config == null) { return (A) this; }
        if(map != null) { for(Object key : map.keySet()) {if (this.config != null){this.config.remove(key);}}} return (A)this;
    }

    public Map<String,Object> getConfig() {
        return this.config;
    }

    public <K extends Object,V extends Object>A withConfig(Map<String,Object> config) {
        if (config == null) { this.config =  null;} else {this.config = new LinkedHashMap<String,Object>(config);} return (A) this;
    }

    public Boolean hasConfig() {
        return this.config != null;
    }

    
/**
 * This method has been deprecated, please use method buildTls instead.
 * @return The buildable object.
 */
@Deprecated public KafkaMirrorMakerTls getTls() {
        return this.tls!=null?this.tls.build():null;
    }

    public KafkaMirrorMakerTls buildTls() {
        return this.tls!=null?this.tls.build():null;
    }

    public A withTls(KafkaMirrorMakerTls tls) {
        _visitables.get("tls").remove(this.tls);
        if (tls!=null){ this.tls= new KafkaMirrorMakerTlsBuilder(tls); _visitables.get("tls").add(this.tls);} return (A) this;
    }

    public Boolean hasTls() {
        return this.tls != null;
    }

    public KafkaMirrorMakerClientSpecFluent.TlsNested<A> withNewTls() {
        return new TlsNestedImpl();
    }

    public KafkaMirrorMakerClientSpecFluent.TlsNested<A> withNewTlsLike(KafkaMirrorMakerTls item) {
        return new TlsNestedImpl(item);
    }

    public KafkaMirrorMakerClientSpecFluent.TlsNested<A> editTls() {
        return withNewTlsLike(getTls());
    }

    public KafkaMirrorMakerClientSpecFluent.TlsNested<A> editOrNewTls() {
        return withNewTlsLike(getTls() != null ? getTls(): new KafkaMirrorMakerTlsBuilder().build());
    }

    public KafkaMirrorMakerClientSpecFluent.TlsNested<A> editOrNewTlsLike(KafkaMirrorMakerTls item) {
        return withNewTlsLike(getTls() != null ? getTls(): item);
    }

    
/**
 * This method has been deprecated, please use method buildAuthentication instead.
 * @return The buildable object.
 */
@Deprecated public KafkaClientAuthentication getAuthentication() {
        return this.authentication!=null?this.authentication.build():null;
    }

    public KafkaClientAuthentication buildAuthentication() {
        return this.authentication!=null?this.authentication.build():null;
    }

    public A withAuthentication(KafkaClientAuthentication authentication) {
        if (authentication instanceof KafkaClientAuthenticationScramSha512){ this.authentication= new KafkaClientAuthenticationScramSha512Builder((KafkaClientAuthenticationScramSha512)authentication); _visitables.get("authentication").add(this.authentication);}
        if (authentication instanceof KafkaClientAuthenticationPlain){ this.authentication= new KafkaClientAuthenticationPlainBuilder((KafkaClientAuthenticationPlain)authentication); _visitables.get("authentication").add(this.authentication);}
        if (authentication instanceof KafkaClientAuthenticationOAuth){ this.authentication= new KafkaClientAuthenticationOAuthBuilder((KafkaClientAuthenticationOAuth)authentication); _visitables.get("authentication").add(this.authentication);}
        if (authentication instanceof KafkaClientAuthenticationTls){ this.authentication= new KafkaClientAuthenticationTlsBuilder((KafkaClientAuthenticationTls)authentication); _visitables.get("authentication").add(this.authentication);}
        return (A) this;
    }

    public Boolean hasAuthentication() {
        return this.authentication != null;
    }

    public A withKafkaClientAuthenticationScramSha512(KafkaClientAuthenticationScramSha512 kafkaClientAuthenticationScramSha512) {
        _visitables.get("authentication").remove(this.authentication);
        if (kafkaClientAuthenticationScramSha512!=null){ this.authentication= new KafkaClientAuthenticationScramSha512Builder(kafkaClientAuthenticationScramSha512); _visitables.get("authentication").add(this.authentication);} return (A) this;
    }

    public KafkaMirrorMakerClientSpecFluent.KafkaClientAuthenticationScramSha512Nested<A> withNewKafkaClientAuthenticationScramSha512() {
        return new KafkaClientAuthenticationScramSha512NestedImpl();
    }

    public KafkaMirrorMakerClientSpecFluent.KafkaClientAuthenticationScramSha512Nested<A> withNewKafkaClientAuthenticationScramSha512Like(KafkaClientAuthenticationScramSha512 item) {
        return new KafkaClientAuthenticationScramSha512NestedImpl(item);
    }

    public A withKafkaClientAuthenticationPlain(KafkaClientAuthenticationPlain kafkaClientAuthenticationPlain) {
        _visitables.get("authentication").remove(this.authentication);
        if (kafkaClientAuthenticationPlain!=null){ this.authentication= new KafkaClientAuthenticationPlainBuilder(kafkaClientAuthenticationPlain); _visitables.get("authentication").add(this.authentication);} return (A) this;
    }

    public KafkaMirrorMakerClientSpecFluent.KafkaClientAuthenticationPlainNested<A> withNewKafkaClientAuthenticationPlain() {
        return new KafkaClientAuthenticationPlainNestedImpl();
    }

    public KafkaMirrorMakerClientSpecFluent.KafkaClientAuthenticationPlainNested<A> withNewKafkaClientAuthenticationPlainLike(KafkaClientAuthenticationPlain item) {
        return new KafkaClientAuthenticationPlainNestedImpl(item);
    }

    public A withKafkaClientAuthenticationOAuth(KafkaClientAuthenticationOAuth kafkaClientAuthenticationOAuth) {
        _visitables.get("authentication").remove(this.authentication);
        if (kafkaClientAuthenticationOAuth!=null){ this.authentication= new KafkaClientAuthenticationOAuthBuilder(kafkaClientAuthenticationOAuth); _visitables.get("authentication").add(this.authentication);} return (A) this;
    }

    public KafkaMirrorMakerClientSpecFluent.KafkaClientAuthenticationOAuthNested<A> withNewKafkaClientAuthenticationOAuth() {
        return new KafkaClientAuthenticationOAuthNestedImpl();
    }

    public KafkaMirrorMakerClientSpecFluent.KafkaClientAuthenticationOAuthNested<A> withNewKafkaClientAuthenticationOAuthLike(KafkaClientAuthenticationOAuth item) {
        return new KafkaClientAuthenticationOAuthNestedImpl(item);
    }

    public A withKafkaClientAuthenticationTls(KafkaClientAuthenticationTls kafkaClientAuthenticationTls) {
        _visitables.get("authentication").remove(this.authentication);
        if (kafkaClientAuthenticationTls!=null){ this.authentication= new KafkaClientAuthenticationTlsBuilder(kafkaClientAuthenticationTls); _visitables.get("authentication").add(this.authentication);} return (A) this;
    }

    public KafkaMirrorMakerClientSpecFluent.KafkaClientAuthenticationTlsNested<A> withNewKafkaClientAuthenticationTls() {
        return new KafkaClientAuthenticationTlsNestedImpl();
    }

    public KafkaMirrorMakerClientSpecFluent.KafkaClientAuthenticationTlsNested<A> withNewKafkaClientAuthenticationTlsLike(KafkaClientAuthenticationTls item) {
        return new KafkaClientAuthenticationTlsNestedImpl(item);
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        KafkaMirrorMakerClientSpecFluentImpl that = (KafkaMirrorMakerClientSpecFluentImpl) o;
        if (bootstrapServers != null ? !bootstrapServers.equals(that.bootstrapServers) :that.bootstrapServers != null) return false;
        if (config != null ? !config.equals(that.config) :that.config != null) return false;
        if (tls != null ? !tls.equals(that.tls) :that.tls != null) return false;
        if (authentication != null ? !authentication.equals(that.authentication) :that.authentication != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(bootstrapServers,  config,  tls,  authentication,  super.hashCode());
    }

    public class TlsNestedImpl<N> extends KafkaMirrorMakerTlsFluentImpl<KafkaMirrorMakerClientSpecFluent.TlsNested<N>> implements KafkaMirrorMakerClientSpecFluent.TlsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final KafkaMirrorMakerTlsBuilder builder;

            TlsNestedImpl(KafkaMirrorMakerTls item) {
                this.builder = new KafkaMirrorMakerTlsBuilder(this, item);
                        
            }

            TlsNestedImpl() {
                this.builder = new KafkaMirrorMakerTlsBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaMirrorMakerClientSpecFluentImpl.this.withTls(builder.build());
            }

            public N endTls() {
                return and();
            }
    }


    public class KafkaClientAuthenticationScramSha512NestedImpl<N> extends KafkaClientAuthenticationScramSha512FluentImpl<KafkaMirrorMakerClientSpecFluent.KafkaClientAuthenticationScramSha512Nested<N>> implements KafkaMirrorMakerClientSpecFluent.KafkaClientAuthenticationScramSha512Nested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final KafkaClientAuthenticationScramSha512Builder builder;

            KafkaClientAuthenticationScramSha512NestedImpl(KafkaClientAuthenticationScramSha512 item) {
                this.builder = new KafkaClientAuthenticationScramSha512Builder(this, item);
                        
            }

            KafkaClientAuthenticationScramSha512NestedImpl() {
                this.builder = new KafkaClientAuthenticationScramSha512Builder(this);
                        
            }

            public N and() {
                return (N) KafkaMirrorMakerClientSpecFluentImpl.this.withAuthentication(builder.build());
            }

            public N endKafkaClientAuthenticationScramSha512() {
                return and();
            }
    }


    public class KafkaClientAuthenticationPlainNestedImpl<N> extends KafkaClientAuthenticationPlainFluentImpl<KafkaMirrorMakerClientSpecFluent.KafkaClientAuthenticationPlainNested<N>> implements KafkaMirrorMakerClientSpecFluent.KafkaClientAuthenticationPlainNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final KafkaClientAuthenticationPlainBuilder builder;

            KafkaClientAuthenticationPlainNestedImpl(KafkaClientAuthenticationPlain item) {
                this.builder = new KafkaClientAuthenticationPlainBuilder(this, item);
                        
            }

            KafkaClientAuthenticationPlainNestedImpl() {
                this.builder = new KafkaClientAuthenticationPlainBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaMirrorMakerClientSpecFluentImpl.this.withAuthentication(builder.build());
            }

            public N endKafkaClientAuthenticationPlain() {
                return and();
            }
    }


    public class KafkaClientAuthenticationOAuthNestedImpl<N> extends KafkaClientAuthenticationOAuthFluentImpl<KafkaMirrorMakerClientSpecFluent.KafkaClientAuthenticationOAuthNested<N>> implements KafkaMirrorMakerClientSpecFluent.KafkaClientAuthenticationOAuthNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final KafkaClientAuthenticationOAuthBuilder builder;

            KafkaClientAuthenticationOAuthNestedImpl(KafkaClientAuthenticationOAuth item) {
                this.builder = new KafkaClientAuthenticationOAuthBuilder(this, item);
                        
            }

            KafkaClientAuthenticationOAuthNestedImpl() {
                this.builder = new KafkaClientAuthenticationOAuthBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaMirrorMakerClientSpecFluentImpl.this.withAuthentication(builder.build());
            }

            public N endKafkaClientAuthenticationOAuth() {
                return and();
            }
    }


    public class KafkaClientAuthenticationTlsNestedImpl<N> extends KafkaClientAuthenticationTlsFluentImpl<KafkaMirrorMakerClientSpecFluent.KafkaClientAuthenticationTlsNested<N>> implements KafkaMirrorMakerClientSpecFluent.KafkaClientAuthenticationTlsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final KafkaClientAuthenticationTlsBuilder builder;

            KafkaClientAuthenticationTlsNestedImpl(KafkaClientAuthenticationTls item) {
                this.builder = new KafkaClientAuthenticationTlsBuilder(this, item);
                        
            }

            KafkaClientAuthenticationTlsNestedImpl() {
                this.builder = new KafkaClientAuthenticationTlsBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaMirrorMakerClientSpecFluentImpl.this.withAuthentication(builder.build());
            }

            public N endKafkaClientAuthenticationTls() {
                return and();
            }
    }


}
