package io.strimzi.api.kafka.model;

import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuthBuilder;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha512Builder;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuth;
import java.lang.Deprecated;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationPlainBuilder;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationTlsBuilder;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuthFluent;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationPlain;
import java.lang.Boolean;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha512;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationTls;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha512Fluent;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthentication;
import java.lang.StringBuffer;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationPlainFluent;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationTlsFluent;
import java.lang.Object;
import java.util.Map;

public interface KafkaMirrorMakerClientSpecFluent<A extends KafkaMirrorMakerClientSpecFluent<A>> extends Fluent<A> {


    public String getBootstrapServers();
    public A withBootstrapServers(String bootstrapServers);
    public Boolean hasBootstrapServers();
    public A withNewBootstrapServers(StringBuilder arg1);
    public A withNewBootstrapServers(int[] arg1,int arg2,int arg3);
    public A withNewBootstrapServers(char[] arg1);
    public A withNewBootstrapServers(StringBuffer arg1);
    public A withNewBootstrapServers(byte[] arg1,int arg2);
    public A withNewBootstrapServers(byte[] arg1);
    public A withNewBootstrapServers(char[] arg1,int arg2,int arg3);
    public A withNewBootstrapServers(byte[] arg1,int arg2,int arg3);
    public A withNewBootstrapServers(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewBootstrapServers(String arg1);
    public A addToConfig(String key,Object value);
    public A addToConfig(Map<String,Object> map);
    public A removeFromConfig(String key);
    public A removeFromConfig(Map<String,Object> map);
    public Map<String,Object> getConfig();
    public <K extends Object,V extends Object>A withConfig(Map<String,Object> config);
    public Boolean hasConfig();
    
/**
 * This method has been deprecated, please use method buildTls instead.
 * @return The buildable object.
 */
@Deprecated public KafkaMirrorMakerTls getTls();
    public KafkaMirrorMakerTls buildTls();
    public A withTls(KafkaMirrorMakerTls tls);
    public Boolean hasTls();
    public KafkaMirrorMakerClientSpecFluent.TlsNested<A> withNewTls();
    public KafkaMirrorMakerClientSpecFluent.TlsNested<A> withNewTlsLike(KafkaMirrorMakerTls item);
    public KafkaMirrorMakerClientSpecFluent.TlsNested<A> editTls();
    public KafkaMirrorMakerClientSpecFluent.TlsNested<A> editOrNewTls();
    public KafkaMirrorMakerClientSpecFluent.TlsNested<A> editOrNewTlsLike(KafkaMirrorMakerTls item);
    
/**
 * This method has been deprecated, please use method buildAuthentication instead.
 * @return The buildable object.
 */
@Deprecated public KafkaClientAuthentication getAuthentication();
    public KafkaClientAuthentication buildAuthentication();
    public A withAuthentication(KafkaClientAuthentication authentication);
    public Boolean hasAuthentication();
    public A withKafkaClientAuthenticationScramSha512(KafkaClientAuthenticationScramSha512 kafkaClientAuthenticationScramSha512);
    public KafkaMirrorMakerClientSpecFluent.KafkaClientAuthenticationScramSha512Nested<A> withNewKafkaClientAuthenticationScramSha512();
    public KafkaMirrorMakerClientSpecFluent.KafkaClientAuthenticationScramSha512Nested<A> withNewKafkaClientAuthenticationScramSha512Like(KafkaClientAuthenticationScramSha512 item);
    public A withKafkaClientAuthenticationPlain(KafkaClientAuthenticationPlain kafkaClientAuthenticationPlain);
    public KafkaMirrorMakerClientSpecFluent.KafkaClientAuthenticationPlainNested<A> withNewKafkaClientAuthenticationPlain();
    public KafkaMirrorMakerClientSpecFluent.KafkaClientAuthenticationPlainNested<A> withNewKafkaClientAuthenticationPlainLike(KafkaClientAuthenticationPlain item);
    public A withKafkaClientAuthenticationOAuth(KafkaClientAuthenticationOAuth kafkaClientAuthenticationOAuth);
    public KafkaMirrorMakerClientSpecFluent.KafkaClientAuthenticationOAuthNested<A> withNewKafkaClientAuthenticationOAuth();
    public KafkaMirrorMakerClientSpecFluent.KafkaClientAuthenticationOAuthNested<A> withNewKafkaClientAuthenticationOAuthLike(KafkaClientAuthenticationOAuth item);
    public A withKafkaClientAuthenticationTls(KafkaClientAuthenticationTls kafkaClientAuthenticationTls);
    public KafkaMirrorMakerClientSpecFluent.KafkaClientAuthenticationTlsNested<A> withNewKafkaClientAuthenticationTls();
    public KafkaMirrorMakerClientSpecFluent.KafkaClientAuthenticationTlsNested<A> withNewKafkaClientAuthenticationTlsLike(KafkaClientAuthenticationTls item);
    public interface TlsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,KafkaMirrorMakerTlsFluent<KafkaMirrorMakerClientSpecFluent.TlsNested<N>> {

            public N and();
            public N endTls();    }


    public interface KafkaClientAuthenticationScramSha512Nested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,KafkaClientAuthenticationScramSha512Fluent<KafkaMirrorMakerClientSpecFluent.KafkaClientAuthenticationScramSha512Nested<N>> {

            public N and();
            public N endKafkaClientAuthenticationScramSha512();    }


    public interface KafkaClientAuthenticationPlainNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,KafkaClientAuthenticationPlainFluent<KafkaMirrorMakerClientSpecFluent.KafkaClientAuthenticationPlainNested<N>> {

            public N and();
            public N endKafkaClientAuthenticationPlain();    }


    public interface KafkaClientAuthenticationOAuthNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,KafkaClientAuthenticationOAuthFluent<KafkaMirrorMakerClientSpecFluent.KafkaClientAuthenticationOAuthNested<N>> {

            public N and();
            public N endKafkaClientAuthenticationOAuth();    }


    public interface KafkaClientAuthenticationTlsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,KafkaClientAuthenticationTlsFluent<KafkaMirrorMakerClientSpecFluent.KafkaClientAuthenticationTlsNested<N>> {

            public N and();
            public N endKafkaClientAuthenticationTls();    }


}
