package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class KafkaMirrorMakerBuilder extends KafkaMirrorMakerFluentImpl<KafkaMirrorMakerBuilder> implements VisitableBuilder<KafkaMirrorMaker,KafkaMirrorMakerBuilder> {

    KafkaMirrorMakerFluent<?> fluent;
    Boolean validationEnabled;

    public KafkaMirrorMakerBuilder() {
        this(true);
    }

    public KafkaMirrorMakerBuilder(Boolean validationEnabled) {
        this(new KafkaMirrorMaker(), validationEnabled);
    }

    public KafkaMirrorMakerBuilder(KafkaMirrorMakerFluent<?> fluent) {
        this(fluent, true);
    }

    public KafkaMirrorMakerBuilder(KafkaMirrorMakerFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new KafkaMirrorMaker(), validationEnabled);
    }

    public KafkaMirrorMakerBuilder(KafkaMirrorMakerFluent<?> fluent,KafkaMirrorMaker instance) {
        this(fluent, instance, true);
    }

    public KafkaMirrorMakerBuilder(KafkaMirrorMakerFluent<?> fluent,KafkaMirrorMaker instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion());
        
        fluent.withMetadata(instance.getMetadata());
        
        fluent.withSpec(instance.getSpec());
        
        fluent.withStatus(instance.getStatus());
        
        this.validationEnabled = validationEnabled; 
    }

    public KafkaMirrorMakerBuilder(KafkaMirrorMaker instance) {
        this(instance,true);
    }

    public KafkaMirrorMakerBuilder(KafkaMirrorMaker instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion());
        
        this.withMetadata(instance.getMetadata());
        
        this.withSpec(instance.getSpec());
        
        this.withStatus(instance.getStatus());
        
        this.validationEnabled = validationEnabled; 
    }

    public KafkaMirrorMaker build() {
        KafkaMirrorMaker buildable = new KafkaMirrorMaker();
        buildable.setApiVersion(fluent.getApiVersion());
        buildable.setMetadata(fluent.getMetadata());
        buildable.setSpec(fluent.getSpec());
        buildable.setStatus(fluent.getStatus());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KafkaMirrorMakerBuilder that = (KafkaMirrorMakerBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
