package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface KafkaMirrorMaker2TlsFluent<A extends KafkaMirrorMaker2TlsFluent<A>> extends Fluent<A> {


    public A addToTrustedCertificates(int index,CertSecretSource item);
    public A setToTrustedCertificates(int index,CertSecretSource item);
    public A addToTrustedCertificates(CertSecretSource... items);
    public A addAllToTrustedCertificates(Collection<CertSecretSource> items);
    public A removeFromTrustedCertificates(CertSecretSource... items);
    public A removeAllFromTrustedCertificates(Collection<CertSecretSource> items);
    public A removeMatchingFromTrustedCertificates(Predicate<CertSecretSourceBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildTrustedCertificates instead.
 * @return The buildable object.
 */
@Deprecated public java.util.List<CertSecretSource> getTrustedCertificates();
    public java.util.List<CertSecretSource> buildTrustedCertificates();
    public CertSecretSource buildTrustedCertificate(int index);
    public CertSecretSource buildFirstTrustedCertificate();
    public CertSecretSource buildLastTrustedCertificate();
    public CertSecretSource buildMatchingTrustedCertificate(Predicate<CertSecretSourceBuilder> predicate);
    public Boolean hasMatchingTrustedCertificate(Predicate<CertSecretSourceBuilder> predicate);
    public A withTrustedCertificates(java.util.List<CertSecretSource> trustedCertificates);
    public A withTrustedCertificates(CertSecretSource... trustedCertificates);
    public Boolean hasTrustedCertificates();
    public KafkaMirrorMaker2TlsFluent.TrustedCertificatesNested<A> addNewTrustedCertificate();
    public KafkaMirrorMaker2TlsFluent.TrustedCertificatesNested<A> addNewTrustedCertificateLike(CertSecretSource item);
    public KafkaMirrorMaker2TlsFluent.TrustedCertificatesNested<A> setNewTrustedCertificateLike(int index,CertSecretSource item);
    public KafkaMirrorMaker2TlsFluent.TrustedCertificatesNested<A> editTrustedCertificate(int index);
    public KafkaMirrorMaker2TlsFluent.TrustedCertificatesNested<A> editFirstTrustedCertificate();
    public KafkaMirrorMaker2TlsFluent.TrustedCertificatesNested<A> editLastTrustedCertificate();
    public KafkaMirrorMaker2TlsFluent.TrustedCertificatesNested<A> editMatchingTrustedCertificate(Predicate<CertSecretSourceBuilder> predicate);
    public interface TrustedCertificatesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,CertSecretSourceFluent<KafkaMirrorMaker2TlsFluent.TrustedCertificatesNested<N>> {

            public N and();
            public N endTrustedCertificate();    }


}
