package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.StringBuffer;
import java.util.Collection;
import java.lang.Object;

public class KafkaMirrorMaker2SpecFluentImpl<A extends KafkaMirrorMaker2SpecFluent<A>> extends AbstractKafkaConnectSpecFluentImpl<A> implements KafkaMirrorMaker2SpecFluent<A> {

    private java.util.List<KafkaMirrorMaker2ClusterSpecBuilder> clusters;
    private String connectCluster;
    private java.util.List<KafkaMirrorMaker2MirrorSpecBuilder> mirrors;

    public KafkaMirrorMaker2SpecFluentImpl() {
    }

    public KafkaMirrorMaker2SpecFluentImpl(KafkaMirrorMaker2Spec instance) {
        this.withClusters(instance.getClusters());
        
        this.withConnectCluster(instance.getConnectCluster());
        
        this.withMirrors(instance.getMirrors());
        
        this.withLogging(instance.getLogging());
        
        this.withReplicas(instance.getReplicas());
        
        this.withVersion(instance.getVersion());
        
        this.withImage(instance.getImage());
        
        this.withResources(instance.getResources());
        
        this.withLivenessProbe(instance.getLivenessProbe());
        
        this.withReadinessProbe(instance.getReadinessProbe());
        
        this.withJmxOptions(instance.getJmxOptions());
        
        this.withJvmOptions(instance.getJvmOptions());
        
        this.withMetricsConfig(instance.getMetricsConfig());
        
        this.withMetrics(instance.getMetrics());
        
        this.withTracing(instance.getTracing());
        
        this.withAffinity(instance.getAffinity());
        
        this.withTolerations(instance.getTolerations());
        
        this.withTemplate(instance.getTemplate());
        
        this.withExternalConfiguration(instance.getExternalConfiguration());
    }

    public A addToClusters(int index,KafkaMirrorMaker2ClusterSpec item) {
        if (this.clusters == null) {this.clusters = new ArrayList<KafkaMirrorMaker2ClusterSpecBuilder>();}
        KafkaMirrorMaker2ClusterSpecBuilder builder = new KafkaMirrorMaker2ClusterSpecBuilder(item);_visitables.get("clusters").add(index >= 0 ? index : _visitables.get("clusters").size(), builder);this.clusters.add(index >= 0 ? index : clusters.size(), builder); return (A)this;
    }

    public A setToClusters(int index,KafkaMirrorMaker2ClusterSpec item) {
        if (this.clusters == null) {this.clusters = new ArrayList<KafkaMirrorMaker2ClusterSpecBuilder>();}
        KafkaMirrorMaker2ClusterSpecBuilder builder = new KafkaMirrorMaker2ClusterSpecBuilder(item);
        if (index < 0 || index >= _visitables.get("clusters").size()) { _visitables.get("clusters").add(builder); } else { _visitables.get("clusters").set(index, builder);}
        if (index < 0 || index >= clusters.size()) { clusters.add(builder); } else { clusters.set(index, builder);}
         return (A)this;
    }

    public A addToClusters(KafkaMirrorMaker2ClusterSpec... items) {
        if (this.clusters == null) {this.clusters = new ArrayList<KafkaMirrorMaker2ClusterSpecBuilder>();}
        for (KafkaMirrorMaker2ClusterSpec item : items) {KafkaMirrorMaker2ClusterSpecBuilder builder = new KafkaMirrorMaker2ClusterSpecBuilder(item);_visitables.get("clusters").add(builder);this.clusters.add(builder);} return (A)this;
    }

    public A addAllToClusters(Collection<KafkaMirrorMaker2ClusterSpec> items) {
        if (this.clusters == null) {this.clusters = new ArrayList<KafkaMirrorMaker2ClusterSpecBuilder>();}
        for (KafkaMirrorMaker2ClusterSpec item : items) {KafkaMirrorMaker2ClusterSpecBuilder builder = new KafkaMirrorMaker2ClusterSpecBuilder(item);_visitables.get("clusters").add(builder);this.clusters.add(builder);} return (A)this;
    }

    public A removeFromClusters(KafkaMirrorMaker2ClusterSpec... items) {
        for (KafkaMirrorMaker2ClusterSpec item : items) {KafkaMirrorMaker2ClusterSpecBuilder builder = new KafkaMirrorMaker2ClusterSpecBuilder(item);_visitables.get("clusters").remove(builder);if (this.clusters != null) {this.clusters.remove(builder);}} return (A)this;
    }

    public A removeAllFromClusters(Collection<KafkaMirrorMaker2ClusterSpec> items) {
        for (KafkaMirrorMaker2ClusterSpec item : items) {KafkaMirrorMaker2ClusterSpecBuilder builder = new KafkaMirrorMaker2ClusterSpecBuilder(item);_visitables.get("clusters").remove(builder);if (this.clusters != null) {this.clusters.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromClusters(Predicate<KafkaMirrorMaker2ClusterSpecBuilder> predicate) {
        if (clusters == null) return (A) this;
        final Iterator<KafkaMirrorMaker2ClusterSpecBuilder> each = clusters.iterator();
        final List visitables = _visitables.get("clusters");
        while (each.hasNext()) {
          KafkaMirrorMaker2ClusterSpecBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildClusters instead.
 * @return The buildable object.
 */
@Deprecated public java.util.List<KafkaMirrorMaker2ClusterSpec> getClusters() {
        return build(clusters);
    }

    public java.util.List<KafkaMirrorMaker2ClusterSpec> buildClusters() {
        return build(clusters);
    }

    public KafkaMirrorMaker2ClusterSpec buildCluster(int index) {
        return this.clusters.get(index).build();
    }

    public KafkaMirrorMaker2ClusterSpec buildFirstCluster() {
        return this.clusters.get(0).build();
    }

    public KafkaMirrorMaker2ClusterSpec buildLastCluster() {
        return this.clusters.get(clusters.size() - 1).build();
    }

    public KafkaMirrorMaker2ClusterSpec buildMatchingCluster(Predicate<KafkaMirrorMaker2ClusterSpecBuilder> predicate) {
        for (KafkaMirrorMaker2ClusterSpecBuilder item: clusters) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingCluster(Predicate<KafkaMirrorMaker2ClusterSpecBuilder> predicate) {
        for (KafkaMirrorMaker2ClusterSpecBuilder item: clusters) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withClusters(java.util.List<KafkaMirrorMaker2ClusterSpec> clusters) {
        if (this.clusters != null) { _visitables.get("clusters").removeAll(this.clusters);}
        if (clusters != null) {this.clusters = new ArrayList<KafkaMirrorMaker2ClusterSpecBuilder>(); for (KafkaMirrorMaker2ClusterSpec item : clusters){this.addToClusters(item);}} else { this.clusters = null;} return (A) this;
    }

    public A withClusters(KafkaMirrorMaker2ClusterSpec... clusters) {
        if (this.clusters != null) {this.clusters.clear();}
        if (clusters != null) {for (KafkaMirrorMaker2ClusterSpec item :clusters){ this.addToClusters(item);}} return (A) this;
    }

    public Boolean hasClusters() {
        return clusters != null && !clusters.isEmpty();
    }

    public KafkaMirrorMaker2SpecFluent.ClustersNested<A> addNewCluster() {
        return new ClustersNestedImpl();
    }

    public KafkaMirrorMaker2SpecFluent.ClustersNested<A> addNewClusterLike(KafkaMirrorMaker2ClusterSpec item) {
        return new ClustersNestedImpl(-1, item);
    }

    public KafkaMirrorMaker2SpecFluent.ClustersNested<A> setNewClusterLike(int index,KafkaMirrorMaker2ClusterSpec item) {
        return new ClustersNestedImpl(index, item);
    }

    public KafkaMirrorMaker2SpecFluent.ClustersNested<A> editCluster(int index) {
        if (clusters.size() <= index) throw new RuntimeException("Can't edit clusters. Index exceeds size.");
        return setNewClusterLike(index, buildCluster(index));
    }

    public KafkaMirrorMaker2SpecFluent.ClustersNested<A> editFirstCluster() {
        if (clusters.size() == 0) throw new RuntimeException("Can't edit first clusters. The list is empty.");
        return setNewClusterLike(0, buildCluster(0));
    }

    public KafkaMirrorMaker2SpecFluent.ClustersNested<A> editLastCluster() {
        int index = clusters.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last clusters. The list is empty.");
        return setNewClusterLike(index, buildCluster(index));
    }

    public KafkaMirrorMaker2SpecFluent.ClustersNested<A> editMatchingCluster(Predicate<KafkaMirrorMaker2ClusterSpecBuilder> predicate) {
        int index = -1;
        for (int i=0;i<clusters.size();i++) { 
        if (predicate.test(clusters.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching clusters. No match found.");
        return setNewClusterLike(index, buildCluster(index));
    }

    public String getConnectCluster() {
        return this.connectCluster;
    }

    public A withConnectCluster(String connectCluster) {
        this.connectCluster=connectCluster; return (A) this;
    }

    public Boolean hasConnectCluster() {
        return this.connectCluster != null;
    }

    public A withNewConnectCluster(StringBuilder arg1) {
        return (A)withConnectCluster(new String(arg1));
    }

    public A withNewConnectCluster(int[] arg1,int arg2,int arg3) {
        return (A)withConnectCluster(new String(arg1, arg2, arg3));
    }

    public A withNewConnectCluster(char[] arg1) {
        return (A)withConnectCluster(new String(arg1));
    }

    public A withNewConnectCluster(StringBuffer arg1) {
        return (A)withConnectCluster(new String(arg1));
    }

    public A withNewConnectCluster(byte[] arg1,int arg2) {
        return (A)withConnectCluster(new String(arg1, arg2));
    }

    public A withNewConnectCluster(byte[] arg1) {
        return (A)withConnectCluster(new String(arg1));
    }

    public A withNewConnectCluster(char[] arg1,int arg2,int arg3) {
        return (A)withConnectCluster(new String(arg1, arg2, arg3));
    }

    public A withNewConnectCluster(byte[] arg1,int arg2,int arg3) {
        return (A)withConnectCluster(new String(arg1, arg2, arg3));
    }

    public A withNewConnectCluster(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withConnectCluster(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewConnectCluster(String arg1) {
        return (A)withConnectCluster(new String(arg1));
    }

    public A addToMirrors(int index,KafkaMirrorMaker2MirrorSpec item) {
        if (this.mirrors == null) {this.mirrors = new ArrayList<KafkaMirrorMaker2MirrorSpecBuilder>();}
        KafkaMirrorMaker2MirrorSpecBuilder builder = new KafkaMirrorMaker2MirrorSpecBuilder(item);_visitables.get("mirrors").add(index >= 0 ? index : _visitables.get("mirrors").size(), builder);this.mirrors.add(index >= 0 ? index : mirrors.size(), builder); return (A)this;
    }

    public A setToMirrors(int index,KafkaMirrorMaker2MirrorSpec item) {
        if (this.mirrors == null) {this.mirrors = new ArrayList<KafkaMirrorMaker2MirrorSpecBuilder>();}
        KafkaMirrorMaker2MirrorSpecBuilder builder = new KafkaMirrorMaker2MirrorSpecBuilder(item);
        if (index < 0 || index >= _visitables.get("mirrors").size()) { _visitables.get("mirrors").add(builder); } else { _visitables.get("mirrors").set(index, builder);}
        if (index < 0 || index >= mirrors.size()) { mirrors.add(builder); } else { mirrors.set(index, builder);}
         return (A)this;
    }

    public A addToMirrors(KafkaMirrorMaker2MirrorSpec... items) {
        if (this.mirrors == null) {this.mirrors = new ArrayList<KafkaMirrorMaker2MirrorSpecBuilder>();}
        for (KafkaMirrorMaker2MirrorSpec item : items) {KafkaMirrorMaker2MirrorSpecBuilder builder = new KafkaMirrorMaker2MirrorSpecBuilder(item);_visitables.get("mirrors").add(builder);this.mirrors.add(builder);} return (A)this;
    }

    public A addAllToMirrors(Collection<KafkaMirrorMaker2MirrorSpec> items) {
        if (this.mirrors == null) {this.mirrors = new ArrayList<KafkaMirrorMaker2MirrorSpecBuilder>();}
        for (KafkaMirrorMaker2MirrorSpec item : items) {KafkaMirrorMaker2MirrorSpecBuilder builder = new KafkaMirrorMaker2MirrorSpecBuilder(item);_visitables.get("mirrors").add(builder);this.mirrors.add(builder);} return (A)this;
    }

    public A removeFromMirrors(KafkaMirrorMaker2MirrorSpec... items) {
        for (KafkaMirrorMaker2MirrorSpec item : items) {KafkaMirrorMaker2MirrorSpecBuilder builder = new KafkaMirrorMaker2MirrorSpecBuilder(item);_visitables.get("mirrors").remove(builder);if (this.mirrors != null) {this.mirrors.remove(builder);}} return (A)this;
    }

    public A removeAllFromMirrors(Collection<KafkaMirrorMaker2MirrorSpec> items) {
        for (KafkaMirrorMaker2MirrorSpec item : items) {KafkaMirrorMaker2MirrorSpecBuilder builder = new KafkaMirrorMaker2MirrorSpecBuilder(item);_visitables.get("mirrors").remove(builder);if (this.mirrors != null) {this.mirrors.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromMirrors(Predicate<KafkaMirrorMaker2MirrorSpecBuilder> predicate) {
        if (mirrors == null) return (A) this;
        final Iterator<KafkaMirrorMaker2MirrorSpecBuilder> each = mirrors.iterator();
        final List visitables = _visitables.get("mirrors");
        while (each.hasNext()) {
          KafkaMirrorMaker2MirrorSpecBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildMirrors instead.
 * @return The buildable object.
 */
@Deprecated public java.util.List<KafkaMirrorMaker2MirrorSpec> getMirrors() {
        return build(mirrors);
    }

    public java.util.List<KafkaMirrorMaker2MirrorSpec> buildMirrors() {
        return build(mirrors);
    }

    public KafkaMirrorMaker2MirrorSpec buildMirror(int index) {
        return this.mirrors.get(index).build();
    }

    public KafkaMirrorMaker2MirrorSpec buildFirstMirror() {
        return this.mirrors.get(0).build();
    }

    public KafkaMirrorMaker2MirrorSpec buildLastMirror() {
        return this.mirrors.get(mirrors.size() - 1).build();
    }

    public KafkaMirrorMaker2MirrorSpec buildMatchingMirror(Predicate<KafkaMirrorMaker2MirrorSpecBuilder> predicate) {
        for (KafkaMirrorMaker2MirrorSpecBuilder item: mirrors) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingMirror(Predicate<KafkaMirrorMaker2MirrorSpecBuilder> predicate) {
        for (KafkaMirrorMaker2MirrorSpecBuilder item: mirrors) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withMirrors(java.util.List<KafkaMirrorMaker2MirrorSpec> mirrors) {
        if (this.mirrors != null) { _visitables.get("mirrors").removeAll(this.mirrors);}
        if (mirrors != null) {this.mirrors = new ArrayList<KafkaMirrorMaker2MirrorSpecBuilder>(); for (KafkaMirrorMaker2MirrorSpec item : mirrors){this.addToMirrors(item);}} else { this.mirrors = null;} return (A) this;
    }

    public A withMirrors(KafkaMirrorMaker2MirrorSpec... mirrors) {
        if (this.mirrors != null) {this.mirrors.clear();}
        if (mirrors != null) {for (KafkaMirrorMaker2MirrorSpec item :mirrors){ this.addToMirrors(item);}} return (A) this;
    }

    public Boolean hasMirrors() {
        return mirrors != null && !mirrors.isEmpty();
    }

    public KafkaMirrorMaker2SpecFluent.MirrorsNested<A> addNewMirror() {
        return new MirrorsNestedImpl();
    }

    public KafkaMirrorMaker2SpecFluent.MirrorsNested<A> addNewMirrorLike(KafkaMirrorMaker2MirrorSpec item) {
        return new MirrorsNestedImpl(-1, item);
    }

    public KafkaMirrorMaker2SpecFluent.MirrorsNested<A> setNewMirrorLike(int index,KafkaMirrorMaker2MirrorSpec item) {
        return new MirrorsNestedImpl(index, item);
    }

    public KafkaMirrorMaker2SpecFluent.MirrorsNested<A> editMirror(int index) {
        if (mirrors.size() <= index) throw new RuntimeException("Can't edit mirrors. Index exceeds size.");
        return setNewMirrorLike(index, buildMirror(index));
    }

    public KafkaMirrorMaker2SpecFluent.MirrorsNested<A> editFirstMirror() {
        if (mirrors.size() == 0) throw new RuntimeException("Can't edit first mirrors. The list is empty.");
        return setNewMirrorLike(0, buildMirror(0));
    }

    public KafkaMirrorMaker2SpecFluent.MirrorsNested<A> editLastMirror() {
        int index = mirrors.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last mirrors. The list is empty.");
        return setNewMirrorLike(index, buildMirror(index));
    }

    public KafkaMirrorMaker2SpecFluent.MirrorsNested<A> editMatchingMirror(Predicate<KafkaMirrorMaker2MirrorSpecBuilder> predicate) {
        int index = -1;
        for (int i=0;i<mirrors.size();i++) { 
        if (predicate.test(mirrors.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching mirrors. No match found.");
        return setNewMirrorLike(index, buildMirror(index));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KafkaMirrorMaker2SpecFluentImpl that = (KafkaMirrorMaker2SpecFluentImpl) o;
        if (clusters != null ? !clusters.equals(that.clusters) :that.clusters != null) return false;
        if (connectCluster != null ? !connectCluster.equals(that.connectCluster) :that.connectCluster != null) return false;
        if (mirrors != null ? !mirrors.equals(that.mirrors) :that.mirrors != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(clusters,  connectCluster,  mirrors,  super.hashCode());
    }

    public class ClustersNestedImpl<N> extends KafkaMirrorMaker2ClusterSpecFluentImpl<KafkaMirrorMaker2SpecFluent.ClustersNested<N>> implements KafkaMirrorMaker2SpecFluent.ClustersNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final KafkaMirrorMaker2ClusterSpecBuilder builder;
        private final int index;

            ClustersNestedImpl(int index,KafkaMirrorMaker2ClusterSpec item) {
                this.index = index;
                this.builder = new KafkaMirrorMaker2ClusterSpecBuilder(this, item);
                        
            }

            ClustersNestedImpl() {
                this.index = -1;
                this.builder = new KafkaMirrorMaker2ClusterSpecBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaMirrorMaker2SpecFluentImpl.this.setToClusters(index,builder.build());
            }

            public N endCluster() {
                return and();
            }
    }


    public class MirrorsNestedImpl<N> extends KafkaMirrorMaker2MirrorSpecFluentImpl<KafkaMirrorMaker2SpecFluent.MirrorsNested<N>> implements KafkaMirrorMaker2SpecFluent.MirrorsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final KafkaMirrorMaker2MirrorSpecBuilder builder;
        private final int index;

            MirrorsNestedImpl(int index,KafkaMirrorMaker2MirrorSpec item) {
                this.index = index;
                this.builder = new KafkaMirrorMaker2MirrorSpecBuilder(this, item);
                        
            }

            MirrorsNestedImpl() {
                this.index = -1;
                this.builder = new KafkaMirrorMaker2MirrorSpecBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaMirrorMaker2SpecFluentImpl.this.setToMirrors(index,builder.build());
            }

            public N endMirror() {
                return and();
            }
    }


}
