package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.Collection;
import java.util.List;
import java.lang.Boolean;

public interface KafkaMirrorMaker2SpecFluent<A extends KafkaMirrorMaker2SpecFluent<A>> extends AbstractKafkaConnectSpecFluent<A> {


    public A addToClusters(int index,KafkaMirrorMaker2ClusterSpec item);
    public A setToClusters(int index,KafkaMirrorMaker2ClusterSpec item);
    public A addToClusters(KafkaMirrorMaker2ClusterSpec... items);
    public A addAllToClusters(Collection<KafkaMirrorMaker2ClusterSpec> items);
    public A removeFromClusters(KafkaMirrorMaker2ClusterSpec... items);
    public A removeAllFromClusters(Collection<KafkaMirrorMaker2ClusterSpec> items);
    public A removeMatchingFromClusters(Predicate<KafkaMirrorMaker2ClusterSpecBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildClusters instead.
 * @return The buildable object.
 */
@Deprecated public java.util.List<KafkaMirrorMaker2ClusterSpec> getClusters();
    public java.util.List<KafkaMirrorMaker2ClusterSpec> buildClusters();
    public KafkaMirrorMaker2ClusterSpec buildCluster(int index);
    public KafkaMirrorMaker2ClusterSpec buildFirstCluster();
    public KafkaMirrorMaker2ClusterSpec buildLastCluster();
    public KafkaMirrorMaker2ClusterSpec buildMatchingCluster(Predicate<KafkaMirrorMaker2ClusterSpecBuilder> predicate);
    public Boolean hasMatchingCluster(Predicate<KafkaMirrorMaker2ClusterSpecBuilder> predicate);
    public A withClusters(java.util.List<KafkaMirrorMaker2ClusterSpec> clusters);
    public A withClusters(KafkaMirrorMaker2ClusterSpec... clusters);
    public Boolean hasClusters();
    public KafkaMirrorMaker2SpecFluent.ClustersNested<A> addNewCluster();
    public KafkaMirrorMaker2SpecFluent.ClustersNested<A> addNewClusterLike(KafkaMirrorMaker2ClusterSpec item);
    public KafkaMirrorMaker2SpecFluent.ClustersNested<A> setNewClusterLike(int index,KafkaMirrorMaker2ClusterSpec item);
    public KafkaMirrorMaker2SpecFluent.ClustersNested<A> editCluster(int index);
    public KafkaMirrorMaker2SpecFluent.ClustersNested<A> editFirstCluster();
    public KafkaMirrorMaker2SpecFluent.ClustersNested<A> editLastCluster();
    public KafkaMirrorMaker2SpecFluent.ClustersNested<A> editMatchingCluster(Predicate<KafkaMirrorMaker2ClusterSpecBuilder> predicate);
    public String getConnectCluster();
    public A withConnectCluster(String connectCluster);
    public Boolean hasConnectCluster();
    public A withNewConnectCluster(StringBuilder arg1);
    public A withNewConnectCluster(int[] arg1,int arg2,int arg3);
    public A withNewConnectCluster(char[] arg1);
    public A withNewConnectCluster(StringBuffer arg1);
    public A withNewConnectCluster(byte[] arg1,int arg2);
    public A withNewConnectCluster(byte[] arg1);
    public A withNewConnectCluster(char[] arg1,int arg2,int arg3);
    public A withNewConnectCluster(byte[] arg1,int arg2,int arg3);
    public A withNewConnectCluster(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewConnectCluster(String arg1);
    public A addToMirrors(int index,KafkaMirrorMaker2MirrorSpec item);
    public A setToMirrors(int index,KafkaMirrorMaker2MirrorSpec item);
    public A addToMirrors(KafkaMirrorMaker2MirrorSpec... items);
    public A addAllToMirrors(Collection<KafkaMirrorMaker2MirrorSpec> items);
    public A removeFromMirrors(KafkaMirrorMaker2MirrorSpec... items);
    public A removeAllFromMirrors(Collection<KafkaMirrorMaker2MirrorSpec> items);
    public A removeMatchingFromMirrors(Predicate<KafkaMirrorMaker2MirrorSpecBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildMirrors instead.
 * @return The buildable object.
 */
@Deprecated public java.util.List<KafkaMirrorMaker2MirrorSpec> getMirrors();
    public java.util.List<KafkaMirrorMaker2MirrorSpec> buildMirrors();
    public KafkaMirrorMaker2MirrorSpec buildMirror(int index);
    public KafkaMirrorMaker2MirrorSpec buildFirstMirror();
    public KafkaMirrorMaker2MirrorSpec buildLastMirror();
    public KafkaMirrorMaker2MirrorSpec buildMatchingMirror(Predicate<KafkaMirrorMaker2MirrorSpecBuilder> predicate);
    public Boolean hasMatchingMirror(Predicate<KafkaMirrorMaker2MirrorSpecBuilder> predicate);
    public A withMirrors(java.util.List<KafkaMirrorMaker2MirrorSpec> mirrors);
    public A withMirrors(KafkaMirrorMaker2MirrorSpec... mirrors);
    public Boolean hasMirrors();
    public KafkaMirrorMaker2SpecFluent.MirrorsNested<A> addNewMirror();
    public KafkaMirrorMaker2SpecFluent.MirrorsNested<A> addNewMirrorLike(KafkaMirrorMaker2MirrorSpec item);
    public KafkaMirrorMaker2SpecFluent.MirrorsNested<A> setNewMirrorLike(int index,KafkaMirrorMaker2MirrorSpec item);
    public KafkaMirrorMaker2SpecFluent.MirrorsNested<A> editMirror(int index);
    public KafkaMirrorMaker2SpecFluent.MirrorsNested<A> editFirstMirror();
    public KafkaMirrorMaker2SpecFluent.MirrorsNested<A> editLastMirror();
    public KafkaMirrorMaker2SpecFluent.MirrorsNested<A> editMatchingMirror(Predicate<KafkaMirrorMaker2MirrorSpecBuilder> predicate);
    public interface ClustersNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,KafkaMirrorMaker2ClusterSpecFluent<KafkaMirrorMaker2SpecFluent.ClustersNested<N>> {

            public N and();
            public N endCluster();    }


    public interface MirrorsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,KafkaMirrorMaker2MirrorSpecFluent<KafkaMirrorMaker2SpecFluent.MirrorsNested<N>> {

            public N and();
            public N endMirror();    }


}
