package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class KafkaMirrorMaker2SpecBuilder extends KafkaMirrorMaker2SpecFluentImpl<KafkaMirrorMaker2SpecBuilder> implements VisitableBuilder<KafkaMirrorMaker2Spec,KafkaMirrorMaker2SpecBuilder> {

    KafkaMirrorMaker2SpecFluent<?> fluent;
    Boolean validationEnabled;

    public KafkaMirrorMaker2SpecBuilder() {
        this(true);
    }

    public KafkaMirrorMaker2SpecBuilder(Boolean validationEnabled) {
        this(new KafkaMirrorMaker2Spec(), validationEnabled);
    }

    public KafkaMirrorMaker2SpecBuilder(KafkaMirrorMaker2SpecFluent<?> fluent) {
        this(fluent, true);
    }

    public KafkaMirrorMaker2SpecBuilder(KafkaMirrorMaker2SpecFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new KafkaMirrorMaker2Spec(), validationEnabled);
    }

    public KafkaMirrorMaker2SpecBuilder(KafkaMirrorMaker2SpecFluent<?> fluent,KafkaMirrorMaker2Spec instance) {
        this(fluent, instance, true);
    }

    public KafkaMirrorMaker2SpecBuilder(KafkaMirrorMaker2SpecFluent<?> fluent,KafkaMirrorMaker2Spec instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withClusters(instance.getClusters());
        
        fluent.withConnectCluster(instance.getConnectCluster());
        
        fluent.withMirrors(instance.getMirrors());
        
        fluent.withLogging(instance.getLogging());
        
        fluent.withReplicas(instance.getReplicas());
        
        fluent.withVersion(instance.getVersion());
        
        fluent.withImage(instance.getImage());
        
        fluent.withResources(instance.getResources());
        
        fluent.withLivenessProbe(instance.getLivenessProbe());
        
        fluent.withReadinessProbe(instance.getReadinessProbe());
        
        fluent.withJmxOptions(instance.getJmxOptions());
        
        fluent.withJvmOptions(instance.getJvmOptions());
        
        fluent.withMetricsConfig(instance.getMetricsConfig());
        
        fluent.withMetrics(instance.getMetrics());
        
        fluent.withTracing(instance.getTracing());
        
        fluent.withAffinity(instance.getAffinity());
        
        fluent.withTolerations(instance.getTolerations());
        
        fluent.withTemplate(instance.getTemplate());
        
        fluent.withExternalConfiguration(instance.getExternalConfiguration());
        
        this.validationEnabled = validationEnabled; 
    }

    public KafkaMirrorMaker2SpecBuilder(KafkaMirrorMaker2Spec instance) {
        this(instance,true);
    }

    public KafkaMirrorMaker2SpecBuilder(KafkaMirrorMaker2Spec instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withClusters(instance.getClusters());
        
        this.withConnectCluster(instance.getConnectCluster());
        
        this.withMirrors(instance.getMirrors());
        
        this.withLogging(instance.getLogging());
        
        this.withReplicas(instance.getReplicas());
        
        this.withVersion(instance.getVersion());
        
        this.withImage(instance.getImage());
        
        this.withResources(instance.getResources());
        
        this.withLivenessProbe(instance.getLivenessProbe());
        
        this.withReadinessProbe(instance.getReadinessProbe());
        
        this.withJmxOptions(instance.getJmxOptions());
        
        this.withJvmOptions(instance.getJvmOptions());
        
        this.withMetricsConfig(instance.getMetricsConfig());
        
        this.withMetrics(instance.getMetrics());
        
        this.withTracing(instance.getTracing());
        
        this.withAffinity(instance.getAffinity());
        
        this.withTolerations(instance.getTolerations());
        
        this.withTemplate(instance.getTemplate());
        
        this.withExternalConfiguration(instance.getExternalConfiguration());
        
        this.validationEnabled = validationEnabled; 
    }

    public KafkaMirrorMaker2Spec build() {
        KafkaMirrorMaker2Spec buildable = new KafkaMirrorMaker2Spec();
        buildable.setLogging(fluent.getLogging());
        buildable.setReplicas(fluent.getReplicas());
        buildable.setVersion(fluent.getVersion());
        buildable.setImage(fluent.getImage());
        buildable.setResources(fluent.getResources());
        buildable.setLivenessProbe(fluent.getLivenessProbe());
        buildable.setReadinessProbe(fluent.getReadinessProbe());
        buildable.setJmxOptions(fluent.getJmxOptions());
        buildable.setJvmOptions(fluent.getJvmOptions());
        buildable.setMetricsConfig(fluent.getMetricsConfig());
        buildable.setMetrics(fluent.getMetrics());
        buildable.setTracing(fluent.getTracing());
        buildable.setAffinity(fluent.getAffinity());
        buildable.setTolerations(fluent.getTolerations());
        buildable.setTemplate(fluent.getTemplate());
        buildable.setExternalConfiguration(fluent.getExternalConfiguration());
        buildable.setClusters(fluent.getClusters());
        buildable.setConnectCluster(fluent.getConnectCluster());
        buildable.setMirrors(fluent.getMirrors());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KafkaMirrorMaker2SpecBuilder that = (KafkaMirrorMaker2SpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
