package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class KafkaMirrorMaker2ConnectorSpecBuilder extends KafkaMirrorMaker2ConnectorSpecFluentImpl<KafkaMirrorMaker2ConnectorSpecBuilder> implements VisitableBuilder<KafkaMirrorMaker2ConnectorSpec,KafkaMirrorMaker2ConnectorSpecBuilder> {

    KafkaMirrorMaker2ConnectorSpecFluent<?> fluent;
    Boolean validationEnabled;

    public KafkaMirrorMaker2ConnectorSpecBuilder() {
        this(true);
    }

    public KafkaMirrorMaker2ConnectorSpecBuilder(Boolean validationEnabled) {
        this(new KafkaMirrorMaker2ConnectorSpec(), validationEnabled);
    }

    public KafkaMirrorMaker2ConnectorSpecBuilder(KafkaMirrorMaker2ConnectorSpecFluent<?> fluent) {
        this(fluent, true);
    }

    public KafkaMirrorMaker2ConnectorSpecBuilder(KafkaMirrorMaker2ConnectorSpecFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new KafkaMirrorMaker2ConnectorSpec(), validationEnabled);
    }

    public KafkaMirrorMaker2ConnectorSpecBuilder(KafkaMirrorMaker2ConnectorSpecFluent<?> fluent,KafkaMirrorMaker2ConnectorSpec instance) {
        this(fluent, instance, true);
    }

    public KafkaMirrorMaker2ConnectorSpecBuilder(KafkaMirrorMaker2ConnectorSpecFluent<?> fluent,KafkaMirrorMaker2ConnectorSpec instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withTasksMax(instance.getTasksMax());
        
        fluent.withPause(instance.getPause());
        
        fluent.withConfig(instance.getConfig());
        
        this.validationEnabled = validationEnabled; 
    }

    public KafkaMirrorMaker2ConnectorSpecBuilder(KafkaMirrorMaker2ConnectorSpec instance) {
        this(instance,true);
    }

    public KafkaMirrorMaker2ConnectorSpecBuilder(KafkaMirrorMaker2ConnectorSpec instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withTasksMax(instance.getTasksMax());
        
        this.withPause(instance.getPause());
        
        this.withConfig(instance.getConfig());
        
        this.validationEnabled = validationEnabled; 
    }

    public KafkaMirrorMaker2ConnectorSpec build() {
        KafkaMirrorMaker2ConnectorSpec buildable = new KafkaMirrorMaker2ConnectorSpec();
        buildable.setTasksMax(fluent.getTasksMax());
        buildable.setPause(fluent.getPause());
        buildable.setConfig(fluent.getConfig());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KafkaMirrorMaker2ConnectorSpecBuilder that = (KafkaMirrorMaker2ConnectorSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
