package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class KafkaMirrorMaker2Builder extends KafkaMirrorMaker2FluentImpl<KafkaMirrorMaker2Builder> implements VisitableBuilder<KafkaMirrorMaker2,KafkaMirrorMaker2Builder> {

    KafkaMirrorMaker2Fluent<?> fluent;
    Boolean validationEnabled;

    public KafkaMirrorMaker2Builder() {
        this(true);
    }

    public KafkaMirrorMaker2Builder(Boolean validationEnabled) {
        this(new KafkaMirrorMaker2(), validationEnabled);
    }

    public KafkaMirrorMaker2Builder(KafkaMirrorMaker2Fluent<?> fluent) {
        this(fluent, true);
    }

    public KafkaMirrorMaker2Builder(KafkaMirrorMaker2Fluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new KafkaMirrorMaker2(), validationEnabled);
    }

    public KafkaMirrorMaker2Builder(KafkaMirrorMaker2Fluent<?> fluent,KafkaMirrorMaker2 instance) {
        this(fluent, instance, true);
    }

    public KafkaMirrorMaker2Builder(KafkaMirrorMaker2Fluent<?> fluent,KafkaMirrorMaker2 instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion());
        
        fluent.withSpec(instance.getSpec());
        
        fluent.withMetadata(instance.getMetadata());
        
        fluent.withStatus(instance.getStatus());
        
        this.validationEnabled = validationEnabled; 
    }

    public KafkaMirrorMaker2Builder(KafkaMirrorMaker2 instance) {
        this(instance,true);
    }

    public KafkaMirrorMaker2Builder(KafkaMirrorMaker2 instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion());
        
        this.withSpec(instance.getSpec());
        
        this.withMetadata(instance.getMetadata());
        
        this.withStatus(instance.getStatus());
        
        this.validationEnabled = validationEnabled; 
    }

    public KafkaMirrorMaker2 build() {
        KafkaMirrorMaker2 buildable = new KafkaMirrorMaker2();
        buildable.setApiVersion(fluent.getApiVersion());
        buildable.setSpec(fluent.getSpec());
        buildable.setMetadata(fluent.getMetadata());
        buildable.setStatus(fluent.getStatus());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KafkaMirrorMaker2Builder that = (KafkaMirrorMaker2Builder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
