package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class KafkaJmxOptionsBuilder extends KafkaJmxOptionsFluentImpl<KafkaJmxOptionsBuilder> implements VisitableBuilder<KafkaJmxOptions,KafkaJmxOptionsBuilder> {

    KafkaJmxOptionsFluent<?> fluent;
    Boolean validationEnabled;

    public KafkaJmxOptionsBuilder() {
        this(true);
    }

    public KafkaJmxOptionsBuilder(Boolean validationEnabled) {
        this(new KafkaJmxOptions(), validationEnabled);
    }

    public KafkaJmxOptionsBuilder(KafkaJmxOptionsFluent<?> fluent) {
        this(fluent, true);
    }

    public KafkaJmxOptionsBuilder(KafkaJmxOptionsFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new KafkaJmxOptions(), validationEnabled);
    }

    public KafkaJmxOptionsBuilder(KafkaJmxOptionsFluent<?> fluent,KafkaJmxOptions instance) {
        this(fluent, instance, true);
    }

    public KafkaJmxOptionsBuilder(KafkaJmxOptionsFluent<?> fluent,KafkaJmxOptions instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withAuthentication(instance.getAuthentication());
        
        this.validationEnabled = validationEnabled; 
    }

    public KafkaJmxOptionsBuilder(KafkaJmxOptions instance) {
        this(instance,true);
    }

    public KafkaJmxOptionsBuilder(KafkaJmxOptions instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withAuthentication(instance.getAuthentication());
        
        this.validationEnabled = validationEnabled; 
    }

    public KafkaJmxOptions build() {
        KafkaJmxOptions buildable = new KafkaJmxOptions();
        buildable.setAuthentication(fluent.getAuthentication());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KafkaJmxOptionsBuilder that = (KafkaJmxOptionsBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
