package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class KafkaBridgeProducerSpecBuilder extends KafkaBridgeProducerSpecFluentImpl<KafkaBridgeProducerSpecBuilder> implements VisitableBuilder<KafkaBridgeProducerSpec,KafkaBridgeProducerSpecBuilder> {

    KafkaBridgeProducerSpecFluent<?> fluent;
    Boolean validationEnabled;

    public KafkaBridgeProducerSpecBuilder() {
        this(true);
    }

    public KafkaBridgeProducerSpecBuilder(Boolean validationEnabled) {
        this(new KafkaBridgeProducerSpec(), validationEnabled);
    }

    public KafkaBridgeProducerSpecBuilder(KafkaBridgeProducerSpecFluent<?> fluent) {
        this(fluent, true);
    }

    public KafkaBridgeProducerSpecBuilder(KafkaBridgeProducerSpecFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new KafkaBridgeProducerSpec(), validationEnabled);
    }

    public KafkaBridgeProducerSpecBuilder(KafkaBridgeProducerSpecFluent<?> fluent,KafkaBridgeProducerSpec instance) {
        this(fluent, instance, true);
    }

    public KafkaBridgeProducerSpecBuilder(KafkaBridgeProducerSpecFluent<?> fluent,KafkaBridgeProducerSpec instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withConfig(instance.getConfig());
        
        this.validationEnabled = validationEnabled; 
    }

    public KafkaBridgeProducerSpecBuilder(KafkaBridgeProducerSpec instance) {
        this(instance,true);
    }

    public KafkaBridgeProducerSpecBuilder(KafkaBridgeProducerSpec instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withConfig(instance.getConfig());
        
        this.validationEnabled = validationEnabled; 
    }

    public KafkaBridgeProducerSpec build() {
        KafkaBridgeProducerSpec buildable = new KafkaBridgeProducerSpec();
        buildable.setConfig(fluent.getConfig());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KafkaBridgeProducerSpecBuilder that = (KafkaBridgeProducerSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
