package io.strimzi.api.kafka.model;

import java.lang.StringBuffer;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.util.ArrayList;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.String;
import java.lang.Boolean;
import java.util.Map;
import java.util.function.Predicate;

public interface KafkaBridgeHttpCorsFluent<A extends KafkaBridgeHttpCorsFluent<A>> extends Fluent<A> {


    public A addToAllowedOrigins(int index,String item);
    public A setToAllowedOrigins(int index,String item);
    public A addToAllowedOrigins(String... items);
    public A addAllToAllowedOrigins(Collection<String> items);
    public A removeFromAllowedOrigins(String... items);
    public A removeAllFromAllowedOrigins(Collection<String> items);
    public java.util.List<String> getAllowedOrigins();
    public String getAllowedOrigin(int index);
    public String getFirstAllowedOrigin();
    public String getLastAllowedOrigin();
    public String getMatchingAllowedOrigin(Predicate<String> predicate);
    public Boolean hasMatchingAllowedOrigin(Predicate<String> predicate);
    public A withAllowedOrigins(java.util.List<String> allowedOrigins);
    public A withAllowedOrigins(String... allowedOrigins);
    public Boolean hasAllowedOrigins();
    public A addNewAllowedOrigin(StringBuilder arg1);
    public A addNewAllowedOrigin(int[] arg1,int arg2,int arg3);
    public A addNewAllowedOrigin(char[] arg1);
    public A addNewAllowedOrigin(StringBuffer arg1);
    public A addNewAllowedOrigin(byte[] arg1,int arg2);
    public A addNewAllowedOrigin(byte[] arg1);
    public A addNewAllowedOrigin(char[] arg1,int arg2,int arg3);
    public A addNewAllowedOrigin(byte[] arg1,int arg2,int arg3);
    public A addNewAllowedOrigin(byte[] arg1,int arg2,int arg3,int arg4);
    public A addNewAllowedOrigin(String arg1);
    public A addToAllowedMethods(int index,String item);
    public A setToAllowedMethods(int index,String item);
    public A addToAllowedMethods(String... items);
    public A addAllToAllowedMethods(Collection<String> items);
    public A removeFromAllowedMethods(String... items);
    public A removeAllFromAllowedMethods(Collection<String> items);
    public java.util.List<String> getAllowedMethods();
    public String getAllowedMethod(int index);
    public String getFirstAllowedMethod();
    public String getLastAllowedMethod();
    public String getMatchingAllowedMethod(Predicate<String> predicate);
    public Boolean hasMatchingAllowedMethod(Predicate<String> predicate);
    public A withAllowedMethods(java.util.List<String> allowedMethods);
    public A withAllowedMethods(String... allowedMethods);
    public Boolean hasAllowedMethods();
    public A addNewAllowedMethod(StringBuilder arg1);
    public A addNewAllowedMethod(int[] arg1,int arg2,int arg3);
    public A addNewAllowedMethod(char[] arg1);
    public A addNewAllowedMethod(StringBuffer arg1);
    public A addNewAllowedMethod(byte[] arg1,int arg2);
    public A addNewAllowedMethod(byte[] arg1);
    public A addNewAllowedMethod(char[] arg1,int arg2,int arg3);
    public A addNewAllowedMethod(byte[] arg1,int arg2,int arg3);
    public A addNewAllowedMethod(byte[] arg1,int arg2,int arg3,int arg4);
    public A addNewAllowedMethod(String arg1);
}
