package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class KafkaBridgeHttpConfigFluentImpl<A extends KafkaBridgeHttpConfigFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements KafkaBridgeHttpConfigFluent<A> {

    private int port;
    private KafkaBridgeHttpCorsBuilder cors;

    public KafkaBridgeHttpConfigFluentImpl() {
    }

    public KafkaBridgeHttpConfigFluentImpl(KafkaBridgeHttpConfig instance) {
        this.withPort(instance.getPort()); 
        this.withCors(instance.getCors());
    }

    public int getPort() {
        return this.port;
    }

    public A withPort(int port) {
        this.port=port; return (A) this;
    }

    public Boolean hasPort() {
        return true;
    }

    
/**
 * This method has been deprecated, please use method buildCors instead.
 * @return The buildable object.
 */
@Deprecated public KafkaBridgeHttpCors getCors() {
        return this.cors!=null?this.cors.build():null;
    }

    public KafkaBridgeHttpCors buildCors() {
        return this.cors!=null?this.cors.build():null;
    }

    public A withCors(KafkaBridgeHttpCors cors) {
        _visitables.get("cors").remove(this.cors);
        if (cors!=null){ this.cors= new KafkaBridgeHttpCorsBuilder(cors); _visitables.get("cors").add(this.cors);} return (A) this;
    }

    public Boolean hasCors() {
        return this.cors != null;
    }

    public KafkaBridgeHttpConfigFluent.CorsNested<A> withNewCors() {
        return new CorsNestedImpl();
    }

    public KafkaBridgeHttpConfigFluent.CorsNested<A> withNewCorsLike(KafkaBridgeHttpCors item) {
        return new CorsNestedImpl(item);
    }

    public KafkaBridgeHttpConfigFluent.CorsNested<A> editCors() {
        return withNewCorsLike(getCors());
    }

    public KafkaBridgeHttpConfigFluent.CorsNested<A> editOrNewCors() {
        return withNewCorsLike(getCors() != null ? getCors(): new KafkaBridgeHttpCorsBuilder().build());
    }

    public KafkaBridgeHttpConfigFluent.CorsNested<A> editOrNewCorsLike(KafkaBridgeHttpCors item) {
        return withNewCorsLike(getCors() != null ? getCors(): item);
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        KafkaBridgeHttpConfigFluentImpl that = (KafkaBridgeHttpConfigFluentImpl) o;
        if (port != that.port) return false;
        if (cors != null ? !cors.equals(that.cors) :that.cors != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(port,  cors,  super.hashCode());
    }

    public class CorsNestedImpl<N> extends KafkaBridgeHttpCorsFluentImpl<KafkaBridgeHttpConfigFluent.CorsNested<N>> implements KafkaBridgeHttpConfigFluent.CorsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final KafkaBridgeHttpCorsBuilder builder;

            CorsNestedImpl(KafkaBridgeHttpCors item) {
                this.builder = new KafkaBridgeHttpCorsBuilder(this, item);
                        
            }

            CorsNestedImpl() {
                this.builder = new KafkaBridgeHttpCorsBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaBridgeHttpConfigFluentImpl.this.withCors(builder.build());
            }

            public N endCors() {
                return and();
            }
    }


}
