package io.strimzi.api.kafka.model;

import java.lang.StringBuffer;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.lang.String;
import java.lang.Boolean;
import java.util.function.Predicate;

public interface KafkaAuthorizationOpaFluent<A extends KafkaAuthorizationOpaFluent<A>> extends Fluent<A> {


    public A addToSuperUsers(int index,String item);
    public A setToSuperUsers(int index,String item);
    public A addToSuperUsers(String... items);
    public A addAllToSuperUsers(Collection<String> items);
    public A removeFromSuperUsers(String... items);
    public A removeAllFromSuperUsers(Collection<String> items);
    public java.util.List<String> getSuperUsers();
    public String getSuperUser(int index);
    public String getFirstSuperUser();
    public String getLastSuperUser();
    public String getMatchingSuperUser(Predicate<String> predicate);
    public Boolean hasMatchingSuperUser(Predicate<String> predicate);
    public A withSuperUsers(java.util.List<String> superUsers);
    public A withSuperUsers(String... superUsers);
    public Boolean hasSuperUsers();
    public A addNewSuperUser(StringBuilder arg1);
    public A addNewSuperUser(int[] arg1,int arg2,int arg3);
    public A addNewSuperUser(char[] arg1);
    public A addNewSuperUser(StringBuffer arg1);
    public A addNewSuperUser(byte[] arg1,int arg2);
    public A addNewSuperUser(byte[] arg1);
    public A addNewSuperUser(char[] arg1,int arg2,int arg3);
    public A addNewSuperUser(byte[] arg1,int arg2,int arg3);
    public A addNewSuperUser(byte[] arg1,int arg2,int arg3,int arg4);
    public A addNewSuperUser(String arg1);
    public String getUrl();
    public A withUrl(String url);
    public Boolean hasUrl();
    public A withNewUrl(StringBuilder arg1);
    public A withNewUrl(int[] arg1,int arg2,int arg3);
    public A withNewUrl(char[] arg1);
    public A withNewUrl(StringBuffer arg1);
    public A withNewUrl(byte[] arg1,int arg2);
    public A withNewUrl(byte[] arg1);
    public A withNewUrl(char[] arg1,int arg2,int arg3);
    public A withNewUrl(byte[] arg1,int arg2,int arg3);
    public A withNewUrl(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewUrl(String arg1);
    public boolean isAllowOnError();
    public A withAllowOnError(boolean allowOnError);
    public Boolean hasAllowOnError();
    public int getInitialCacheCapacity();
    public A withInitialCacheCapacity(int initialCacheCapacity);
    public Boolean hasInitialCacheCapacity();
    public int getMaximumCacheSize();
    public A withMaximumCacheSize(int maximumCacheSize);
    public Boolean hasMaximumCacheSize();
    public long getExpireAfterMs();
    public A withExpireAfterMs(long expireAfterMs);
    public Boolean hasExpireAfterMs();
}
