package io.strimzi.api.kafka.model;

import java.lang.StringBuilder;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class KafkaAuthorizationCustomFluentImpl<A extends KafkaAuthorizationCustomFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements KafkaAuthorizationCustomFluent<A> {

    private String authorizerClass;
    private java.util.List<String> superUsers;

    public KafkaAuthorizationCustomFluentImpl() {
    }

    public KafkaAuthorizationCustomFluentImpl(KafkaAuthorizationCustom instance) {
        this.withAuthorizerClass(instance.getAuthorizerClass());
        
        this.withSuperUsers(instance.getSuperUsers());
    }

    public String getAuthorizerClass() {
        return this.authorizerClass;
    }

    public A withAuthorizerClass(String authorizerClass) {
        this.authorizerClass=authorizerClass; return (A) this;
    }

    public Boolean hasAuthorizerClass() {
        return this.authorizerClass != null;
    }

    public A withNewAuthorizerClass(StringBuilder arg1) {
        return (A)withAuthorizerClass(new String(arg1));
    }

    public A withNewAuthorizerClass(int[] arg1,int arg2,int arg3) {
        return (A)withAuthorizerClass(new String(arg1, arg2, arg3));
    }

    public A withNewAuthorizerClass(char[] arg1) {
        return (A)withAuthorizerClass(new String(arg1));
    }

    public A withNewAuthorizerClass(StringBuffer arg1) {
        return (A)withAuthorizerClass(new String(arg1));
    }

    public A withNewAuthorizerClass(byte[] arg1,int arg2) {
        return (A)withAuthorizerClass(new String(arg1, arg2));
    }

    public A withNewAuthorizerClass(byte[] arg1) {
        return (A)withAuthorizerClass(new String(arg1));
    }

    public A withNewAuthorizerClass(char[] arg1,int arg2,int arg3) {
        return (A)withAuthorizerClass(new String(arg1, arg2, arg3));
    }

    public A withNewAuthorizerClass(byte[] arg1,int arg2,int arg3) {
        return (A)withAuthorizerClass(new String(arg1, arg2, arg3));
    }

    public A withNewAuthorizerClass(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withAuthorizerClass(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewAuthorizerClass(String arg1) {
        return (A)withAuthorizerClass(new String(arg1));
    }

    public A addToSuperUsers(int index,String item) {
        if (this.superUsers == null) {this.superUsers = new ArrayList<String>();}
        this.superUsers.add(index, item);
        return (A)this;
    }

    public A setToSuperUsers(int index,String item) {
        if (this.superUsers == null) {this.superUsers = new ArrayList<String>();}
        this.superUsers.set(index, item); return (A)this;
    }

    public A addToSuperUsers(String... items) {
        if (this.superUsers == null) {this.superUsers = new ArrayList<String>();}
        for (String item : items) {this.superUsers.add(item);} return (A)this;
    }

    public A addAllToSuperUsers(Collection<String> items) {
        if (this.superUsers == null) {this.superUsers = new ArrayList<String>();}
        for (String item : items) {this.superUsers.add(item);} return (A)this;
    }

    public A removeFromSuperUsers(String... items) {
        for (String item : items) {if (this.superUsers!= null){ this.superUsers.remove(item);}} return (A)this;
    }

    public A removeAllFromSuperUsers(Collection<String> items) {
        for (String item : items) {if (this.superUsers!= null){ this.superUsers.remove(item);}} return (A)this;
    }

    public java.util.List<String> getSuperUsers() {
        return this.superUsers;
    }

    public String getSuperUser(int index) {
        return this.superUsers.get(index);
    }

    public String getFirstSuperUser() {
        return this.superUsers.get(0);
    }

    public String getLastSuperUser() {
        return this.superUsers.get(superUsers.size() - 1);
    }

    public String getMatchingSuperUser(Predicate<String> predicate) {
        for (String item: superUsers) { if(predicate.test(item)){ return item;} } return null;
    }

    public Boolean hasMatchingSuperUser(Predicate<String> predicate) {
        for (String item: superUsers) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withSuperUsers(java.util.List<String> superUsers) {
        if (this.superUsers != null) { _visitables.get("superUsers").removeAll(this.superUsers);}
        if (superUsers != null) {this.superUsers = new ArrayList<String>(); for (String item : superUsers){this.addToSuperUsers(item);}} else { this.superUsers = null;} return (A) this;
    }

    public A withSuperUsers(String... superUsers) {
        if (this.superUsers != null) {this.superUsers.clear();}
        if (superUsers != null) {for (String item :superUsers){ this.addToSuperUsers(item);}} return (A) this;
    }

    public Boolean hasSuperUsers() {
        return superUsers != null && !superUsers.isEmpty();
    }

    public A addNewSuperUser(StringBuilder arg1) {
        return (A)addToSuperUsers(new String(arg1));
    }

    public A addNewSuperUser(int[] arg1,int arg2,int arg3) {
        return (A)addToSuperUsers(new String(arg1, arg2, arg3));
    }

    public A addNewSuperUser(char[] arg1) {
        return (A)addToSuperUsers(new String(arg1));
    }

    public A addNewSuperUser(StringBuffer arg1) {
        return (A)addToSuperUsers(new String(arg1));
    }

    public A addNewSuperUser(byte[] arg1,int arg2) {
        return (A)addToSuperUsers(new String(arg1, arg2));
    }

    public A addNewSuperUser(byte[] arg1) {
        return (A)addToSuperUsers(new String(arg1));
    }

    public A addNewSuperUser(char[] arg1,int arg2,int arg3) {
        return (A)addToSuperUsers(new String(arg1, arg2, arg3));
    }

    public A addNewSuperUser(byte[] arg1,int arg2,int arg3) {
        return (A)addToSuperUsers(new String(arg1, arg2, arg3));
    }

    public A addNewSuperUser(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)addToSuperUsers(new String(arg1, arg2, arg3, arg4));
    }

    public A addNewSuperUser(String arg1) {
        return (A)addToSuperUsers(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        KafkaAuthorizationCustomFluentImpl that = (KafkaAuthorizationCustomFluentImpl) o;
        if (authorizerClass != null ? !authorizerClass.equals(that.authorizerClass) :that.authorizerClass != null) return false;
        if (superUsers != null ? !superUsers.equals(that.superUsers) :that.superUsers != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(authorizerClass,  superUsers,  super.hashCode());
    }

}
