package io.strimzi.api.kafka.model;

import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class ExternalLoggingFluentImpl<A extends ExternalLoggingFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements ExternalLoggingFluent<A> {

    private String name;
    private ExternalConfigurationReferenceBuilder valueFrom;

    public ExternalLoggingFluentImpl() {
    }

    public ExternalLoggingFluentImpl(ExternalLogging instance) {
        this.withName(instance.getName());
        
        this.withValueFrom(instance.getValueFrom());
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name=name; return (A) this;
    }

    public Boolean hasName() {
        return this.name != null;
    }

    public A withNewName(StringBuilder arg1) {
        return (A)withName(new String(arg1));
    }

    public A withNewName(int[] arg1,int arg2,int arg3) {
        return (A)withName(new String(arg1, arg2, arg3));
    }

    public A withNewName(char[] arg1) {
        return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuffer arg1) {
        return (A)withName(new String(arg1));
    }

    public A withNewName(byte[] arg1,int arg2) {
        return (A)withName(new String(arg1, arg2));
    }

    public A withNewName(byte[] arg1) {
        return (A)withName(new String(arg1));
    }

    public A withNewName(char[] arg1,int arg2,int arg3) {
        return (A)withName(new String(arg1, arg2, arg3));
    }

    public A withNewName(byte[] arg1,int arg2,int arg3) {
        return (A)withName(new String(arg1, arg2, arg3));
    }

    public A withNewName(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withName(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewName(String arg1) {
        return (A)withName(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildValueFrom instead.
 * @return The buildable object.
 */
@Deprecated public ExternalConfigurationReference getValueFrom() {
        return this.valueFrom!=null?this.valueFrom.build():null;
    }

    public ExternalConfigurationReference buildValueFrom() {
        return this.valueFrom!=null?this.valueFrom.build():null;
    }

    public A withValueFrom(ExternalConfigurationReference valueFrom) {
        _visitables.get("valueFrom").remove(this.valueFrom);
        if (valueFrom!=null){ this.valueFrom= new ExternalConfigurationReferenceBuilder(valueFrom); _visitables.get("valueFrom").add(this.valueFrom);} return (A) this;
    }

    public Boolean hasValueFrom() {
        return this.valueFrom != null;
    }

    public ExternalLoggingFluent.ValueFromNested<A> withNewValueFrom() {
        return new ValueFromNestedImpl();
    }

    public ExternalLoggingFluent.ValueFromNested<A> withNewValueFromLike(ExternalConfigurationReference item) {
        return new ValueFromNestedImpl(item);
    }

    public ExternalLoggingFluent.ValueFromNested<A> editValueFrom() {
        return withNewValueFromLike(getValueFrom());
    }

    public ExternalLoggingFluent.ValueFromNested<A> editOrNewValueFrom() {
        return withNewValueFromLike(getValueFrom() != null ? getValueFrom(): new ExternalConfigurationReferenceBuilder().build());
    }

    public ExternalLoggingFluent.ValueFromNested<A> editOrNewValueFromLike(ExternalConfigurationReference item) {
        return withNewValueFromLike(getValueFrom() != null ? getValueFrom(): item);
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ExternalLoggingFluentImpl that = (ExternalLoggingFluentImpl) o;
        if (name != null ? !name.equals(that.name) :that.name != null) return false;
        if (valueFrom != null ? !valueFrom.equals(that.valueFrom) :that.valueFrom != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(name,  valueFrom,  super.hashCode());
    }

    public class ValueFromNestedImpl<N> extends ExternalConfigurationReferenceFluentImpl<ExternalLoggingFluent.ValueFromNested<N>> implements ExternalLoggingFluent.ValueFromNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ExternalConfigurationReferenceBuilder builder;

            ValueFromNestedImpl(ExternalConfigurationReference item) {
                this.builder = new ExternalConfigurationReferenceBuilder(this, item);
                        
            }

            ValueFromNestedImpl() {
                this.builder = new ExternalConfigurationReferenceBuilder(this);
                        
            }

            public N and() {
                return (N) ExternalLoggingFluentImpl.this.withValueFrom(builder.build());
            }

            public N endValueFrom() {
                return and();
            }
    }


}
