package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class EntityTopicOperatorSpecBuilder extends EntityTopicOperatorSpecFluentImpl<EntityTopicOperatorSpecBuilder> implements VisitableBuilder<EntityTopicOperatorSpec,EntityTopicOperatorSpecBuilder> {

    EntityTopicOperatorSpecFluent<?> fluent;
    Boolean validationEnabled;

    public EntityTopicOperatorSpecBuilder() {
        this(true);
    }

    public EntityTopicOperatorSpecBuilder(Boolean validationEnabled) {
        this(new EntityTopicOperatorSpec(), validationEnabled);
    }

    public EntityTopicOperatorSpecBuilder(EntityTopicOperatorSpecFluent<?> fluent) {
        this(fluent, true);
    }

    public EntityTopicOperatorSpecBuilder(EntityTopicOperatorSpecFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new EntityTopicOperatorSpec(), validationEnabled);
    }

    public EntityTopicOperatorSpecBuilder(EntityTopicOperatorSpecFluent<?> fluent,EntityTopicOperatorSpec instance) {
        this(fluent, instance, true);
    }

    public EntityTopicOperatorSpecBuilder(EntityTopicOperatorSpecFluent<?> fluent,EntityTopicOperatorSpec instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withWatchedNamespace(instance.getWatchedNamespace());
        
        fluent.withImage(instance.getImage());
        
        fluent.withReconciliationIntervalSeconds(instance.getReconciliationIntervalSeconds());
        
        fluent.withZookeeperSessionTimeoutSeconds(instance.getZookeeperSessionTimeoutSeconds());
        
        fluent.withTopicMetadataMaxAttempts(instance.getTopicMetadataMaxAttempts());
        
        fluent.withStartupProbe(instance.getStartupProbe());
        
        fluent.withLivenessProbe(instance.getLivenessProbe());
        
        fluent.withReadinessProbe(instance.getReadinessProbe());
        
        fluent.withResources(instance.getResources());
        
        fluent.withLogging(instance.getLogging());
        
        fluent.withJvmOptions(instance.getJvmOptions());
        
        this.validationEnabled = validationEnabled; 
    }

    public EntityTopicOperatorSpecBuilder(EntityTopicOperatorSpec instance) {
        this(instance,true);
    }

    public EntityTopicOperatorSpecBuilder(EntityTopicOperatorSpec instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withWatchedNamespace(instance.getWatchedNamespace());
        
        this.withImage(instance.getImage());
        
        this.withReconciliationIntervalSeconds(instance.getReconciliationIntervalSeconds());
        
        this.withZookeeperSessionTimeoutSeconds(instance.getZookeeperSessionTimeoutSeconds());
        
        this.withTopicMetadataMaxAttempts(instance.getTopicMetadataMaxAttempts());
        
        this.withStartupProbe(instance.getStartupProbe());
        
        this.withLivenessProbe(instance.getLivenessProbe());
        
        this.withReadinessProbe(instance.getReadinessProbe());
        
        this.withResources(instance.getResources());
        
        this.withLogging(instance.getLogging());
        
        this.withJvmOptions(instance.getJvmOptions());
        
        this.validationEnabled = validationEnabled; 
    }

    public EntityTopicOperatorSpec build() {
        EntityTopicOperatorSpec buildable = new EntityTopicOperatorSpec();
        buildable.setWatchedNamespace(fluent.getWatchedNamespace());
        buildable.setImage(fluent.getImage());
        buildable.setReconciliationIntervalSeconds(fluent.getReconciliationIntervalSeconds());
        buildable.setZookeeperSessionTimeoutSeconds(fluent.getZookeeperSessionTimeoutSeconds());
        buildable.setTopicMetadataMaxAttempts(fluent.getTopicMetadataMaxAttempts());
        buildable.setStartupProbe(fluent.getStartupProbe());
        buildable.setLivenessProbe(fluent.getLivenessProbe());
        buildable.setReadinessProbe(fluent.getReadinessProbe());
        buildable.setResources(fluent.getResources());
        buildable.setLogging(fluent.getLogging());
        buildable.setJvmOptions(fluent.getJvmOptions());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        EntityTopicOperatorSpecBuilder that = (EntityTopicOperatorSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
