package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class EntityOperatorSpecBuilder extends EntityOperatorSpecFluentImpl<EntityOperatorSpecBuilder> implements VisitableBuilder<EntityOperatorSpec,EntityOperatorSpecBuilder> {

    EntityOperatorSpecFluent<?> fluent;
    Boolean validationEnabled;

    public EntityOperatorSpecBuilder() {
        this(true);
    }

    public EntityOperatorSpecBuilder(Boolean validationEnabled) {
        this(new EntityOperatorSpec(), validationEnabled);
    }

    public EntityOperatorSpecBuilder(EntityOperatorSpecFluent<?> fluent) {
        this(fluent, true);
    }

    public EntityOperatorSpecBuilder(EntityOperatorSpecFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new EntityOperatorSpec(), validationEnabled);
    }

    public EntityOperatorSpecBuilder(EntityOperatorSpecFluent<?> fluent,EntityOperatorSpec instance) {
        this(fluent, instance, true);
    }

    public EntityOperatorSpecBuilder(EntityOperatorSpecFluent<?> fluent,EntityOperatorSpec instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withTopicOperator(instance.getTopicOperator());
        
        fluent.withUserOperator(instance.getUserOperator());
        
        fluent.withAffinity(instance.getAffinity());
        
        fluent.withTolerations(instance.getTolerations());
        
        fluent.withTlsSidecar(instance.getTlsSidecar());
        
        fluent.withTemplate(instance.getTemplate());
        
        this.validationEnabled = validationEnabled; 
    }

    public EntityOperatorSpecBuilder(EntityOperatorSpec instance) {
        this(instance,true);
    }

    public EntityOperatorSpecBuilder(EntityOperatorSpec instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withTopicOperator(instance.getTopicOperator());
        
        this.withUserOperator(instance.getUserOperator());
        
        this.withAffinity(instance.getAffinity());
        
        this.withTolerations(instance.getTolerations());
        
        this.withTlsSidecar(instance.getTlsSidecar());
        
        this.withTemplate(instance.getTemplate());
        
        this.validationEnabled = validationEnabled; 
    }

    public EntityOperatorSpec build() {
        EntityOperatorSpec buildable = new EntityOperatorSpec();
        buildable.setTopicOperator(fluent.getTopicOperator());
        buildable.setUserOperator(fluent.getUserOperator());
        buildable.setAffinity(fluent.getAffinity());
        buildable.setTolerations(fluent.getTolerations());
        buildable.setTlsSidecar(fluent.getTlsSidecar());
        buildable.setTemplate(fluent.getTemplate());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        EntityOperatorSpecBuilder that = (EntityOperatorSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
