package io.strimzi.api.kafka.model;

import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import java.util.LinkedHashMap;
import io.strimzi.api.kafka.model.balancing.BrokerCapacityFluent;
import java.lang.Deprecated;
import java.lang.Boolean;
import io.strimzi.api.kafka.model.balancing.BrokerCapacityBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.strimzi.api.kafka.model.template.CruiseControlTemplateBuilder;
import io.strimzi.api.kafka.model.template.CruiseControlTemplate;
import java.lang.StringBuffer;
import io.strimzi.api.kafka.model.balancing.BrokerCapacity;
import java.lang.Object;
import io.strimzi.api.kafka.model.template.CruiseControlTemplateFluent;
import java.util.Map;

public interface CruiseControlSpecFluent<A extends CruiseControlSpecFluent<A>> extends Fluent<A> {


    public String getImage();
    public A withImage(String image);
    public Boolean hasImage();
    public A withNewImage(StringBuilder arg1);
    public A withNewImage(int[] arg1,int arg2,int arg3);
    public A withNewImage(char[] arg1);
    public A withNewImage(StringBuffer arg1);
    public A withNewImage(byte[] arg1,int arg2);
    public A withNewImage(byte[] arg1);
    public A withNewImage(char[] arg1,int arg2,int arg3);
    public A withNewImage(byte[] arg1,int arg2,int arg3);
    public A withNewImage(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewImage(String arg1);
    
/**
 * This method has been deprecated, please use method buildTlsSidecar instead.
 * @return The buildable object.
 */
@Deprecated public TlsSidecar getTlsSidecar();
    public TlsSidecar buildTlsSidecar();
    public A withTlsSidecar(TlsSidecar tlsSidecar);
    public Boolean hasTlsSidecar();
    public CruiseControlSpecFluent.TlsSidecarNested<A> withNewTlsSidecar();
    public CruiseControlSpecFluent.TlsSidecarNested<A> withNewTlsSidecarLike(TlsSidecar item);
    public CruiseControlSpecFluent.TlsSidecarNested<A> editTlsSidecar();
    public CruiseControlSpecFluent.TlsSidecarNested<A> editOrNewTlsSidecar();
    public CruiseControlSpecFluent.TlsSidecarNested<A> editOrNewTlsSidecarLike(TlsSidecar item);
    public ResourceRequirements getResources();
    public A withResources(ResourceRequirements resources);
    public Boolean hasResources();
    
/**
 * This method has been deprecated, please use method buildLivenessProbe instead.
 * @return The buildable object.
 */
@Deprecated public Probe getLivenessProbe();
    public Probe buildLivenessProbe();
    public A withLivenessProbe(Probe livenessProbe);
    public Boolean hasLivenessProbe();
    public A withNewLivenessProbe(int initialDelaySeconds,int timeoutSeconds);
    public CruiseControlSpecFluent.LivenessProbeNested<A> withNewLivenessProbe();
    public CruiseControlSpecFluent.LivenessProbeNested<A> withNewLivenessProbeLike(Probe item);
    public CruiseControlSpecFluent.LivenessProbeNested<A> editLivenessProbe();
    public CruiseControlSpecFluent.LivenessProbeNested<A> editOrNewLivenessProbe();
    public CruiseControlSpecFluent.LivenessProbeNested<A> editOrNewLivenessProbeLike(Probe item);
    
/**
 * This method has been deprecated, please use method buildReadinessProbe instead.
 * @return The buildable object.
 */
@Deprecated public Probe getReadinessProbe();
    public Probe buildReadinessProbe();
    public A withReadinessProbe(Probe readinessProbe);
    public Boolean hasReadinessProbe();
    public A withNewReadinessProbe(int initialDelaySeconds,int timeoutSeconds);
    public CruiseControlSpecFluent.ReadinessProbeNested<A> withNewReadinessProbe();
    public CruiseControlSpecFluent.ReadinessProbeNested<A> withNewReadinessProbeLike(Probe item);
    public CruiseControlSpecFluent.ReadinessProbeNested<A> editReadinessProbe();
    public CruiseControlSpecFluent.ReadinessProbeNested<A> editOrNewReadinessProbe();
    public CruiseControlSpecFluent.ReadinessProbeNested<A> editOrNewReadinessProbeLike(Probe item);
    
/**
 * This method has been deprecated, please use method buildJvmOptions instead.
 * @return The buildable object.
 */
@Deprecated public JvmOptions getJvmOptions();
    public JvmOptions buildJvmOptions();
    public A withJvmOptions(JvmOptions jvmOptions);
    public Boolean hasJvmOptions();
    public CruiseControlSpecFluent.JvmOptionsNested<A> withNewJvmOptions();
    public CruiseControlSpecFluent.JvmOptionsNested<A> withNewJvmOptionsLike(JvmOptions item);
    public CruiseControlSpecFluent.JvmOptionsNested<A> editJvmOptions();
    public CruiseControlSpecFluent.JvmOptionsNested<A> editOrNewJvmOptions();
    public CruiseControlSpecFluent.JvmOptionsNested<A> editOrNewJvmOptionsLike(JvmOptions item);
    
/**
 * This method has been deprecated, please use method buildLogging instead.
 * @return The buildable object.
 */
@Deprecated public Logging getLogging();
    public Logging buildLogging();
    public A withLogging(Logging logging);
    public Boolean hasLogging();
    public A withExternalLogging(ExternalLogging externalLogging);
    public CruiseControlSpecFluent.ExternalLoggingNested<A> withNewExternalLogging();
    public CruiseControlSpecFluent.ExternalLoggingNested<A> withNewExternalLoggingLike(ExternalLogging item);
    public A withInlineLogging(InlineLogging inlineLogging);
    public CruiseControlSpecFluent.InlineLoggingNested<A> withNewInlineLogging();
    public CruiseControlSpecFluent.InlineLoggingNested<A> withNewInlineLoggingLike(InlineLogging item);
    
/**
 * This method has been deprecated, please use method buildTemplate instead.
 * @return The buildable object.
 */
@Deprecated public CruiseControlTemplate getTemplate();
    public CruiseControlTemplate buildTemplate();
    public A withTemplate(CruiseControlTemplate template);
    public Boolean hasTemplate();
    public CruiseControlSpecFluent.TemplateNested<A> withNewTemplate();
    public CruiseControlSpecFluent.TemplateNested<A> withNewTemplateLike(CruiseControlTemplate item);
    public CruiseControlSpecFluent.TemplateNested<A> editTemplate();
    public CruiseControlSpecFluent.TemplateNested<A> editOrNewTemplate();
    public CruiseControlSpecFluent.TemplateNested<A> editOrNewTemplateLike(CruiseControlTemplate item);
    
/**
 * This method has been deprecated, please use method buildBrokerCapacity instead.
 * @return The buildable object.
 */
@Deprecated public BrokerCapacity getBrokerCapacity();
    public BrokerCapacity buildBrokerCapacity();
    public A withBrokerCapacity(BrokerCapacity brokerCapacity);
    public Boolean hasBrokerCapacity();
    public CruiseControlSpecFluent.BrokerCapacityNested<A> withNewBrokerCapacity();
    public CruiseControlSpecFluent.BrokerCapacityNested<A> withNewBrokerCapacityLike(BrokerCapacity item);
    public CruiseControlSpecFluent.BrokerCapacityNested<A> editBrokerCapacity();
    public CruiseControlSpecFluent.BrokerCapacityNested<A> editOrNewBrokerCapacity();
    public CruiseControlSpecFluent.BrokerCapacityNested<A> editOrNewBrokerCapacityLike(BrokerCapacity item);
    public A addToConfig(String key,Object value);
    public A addToConfig(Map<String,Object> map);
    public A removeFromConfig(String key);
    public A removeFromConfig(Map<String,Object> map);
    public Map<String,Object> getConfig();
    public <K extends Object,V extends Object>A withConfig(Map<String,Object> config);
    public Boolean hasConfig();
    public A addToMetrics(String key,Object value);
    public A addToMetrics(Map<String,Object> map);
    public A removeFromMetrics(String key);
    public A removeFromMetrics(Map<String,Object> map);
    public Map<String,Object> getMetrics();
    public <K extends Object,V extends Object>A withMetrics(Map<String,Object> metrics);
    public Boolean hasMetrics();
    
/**
 * This method has been deprecated, please use method buildMetricsConfig instead.
 * @return The buildable object.
 */
@Deprecated public MetricsConfig getMetricsConfig();
    public MetricsConfig buildMetricsConfig();
    public A withMetricsConfig(MetricsConfig metricsConfig);
    public Boolean hasMetricsConfig();
    public A withJmxPrometheusExporterMetricsConfig(JmxPrometheusExporterMetrics jmxPrometheusExporterMetricsConfig);
    public CruiseControlSpecFluent.JmxPrometheusExporterMetricsConfigNested<A> withNewJmxPrometheusExporterMetricsConfig();
    public CruiseControlSpecFluent.JmxPrometheusExporterMetricsConfigNested<A> withNewJmxPrometheusExporterMetricsConfigLike(JmxPrometheusExporterMetrics item);
    public interface TlsSidecarNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,TlsSidecarFluent<CruiseControlSpecFluent.TlsSidecarNested<N>> {

            public N and();
            public N endTlsSidecar();    }


    public interface LivenessProbeNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ProbeFluent<CruiseControlSpecFluent.LivenessProbeNested<N>> {

            public N and();
            public N endLivenessProbe();    }


    public interface ReadinessProbeNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ProbeFluent<CruiseControlSpecFluent.ReadinessProbeNested<N>> {

            public N and();
            public N endReadinessProbe();    }


    public interface JvmOptionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,JvmOptionsFluent<CruiseControlSpecFluent.JvmOptionsNested<N>> {

            public N and();
            public N endJvmOptions();    }


    public interface ExternalLoggingNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ExternalLoggingFluent<CruiseControlSpecFluent.ExternalLoggingNested<N>> {

            public N and();
            public N endExternalLogging();    }


    public interface InlineLoggingNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,InlineLoggingFluent<CruiseControlSpecFluent.InlineLoggingNested<N>> {

            public N and();
            public N endInlineLogging();    }


    public interface TemplateNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,CruiseControlTemplateFluent<CruiseControlSpecFluent.TemplateNested<N>> {

            public N and();
            public N endTemplate();    }


    public interface BrokerCapacityNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,BrokerCapacityFluent<CruiseControlSpecFluent.BrokerCapacityNested<N>> {

            public N and();
            public N endBrokerCapacity();    }


    public interface JmxPrometheusExporterMetricsConfigNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,JmxPrometheusExporterMetricsFluent<CruiseControlSpecFluent.JmxPrometheusExporterMetricsConfigNested<N>> {

            public N and();
            public N endJmxPrometheusExporterMetricsConfig();    }


}
