package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class CertSecretSourceBuilder extends CertSecretSourceFluentImpl<CertSecretSourceBuilder> implements VisitableBuilder<CertSecretSource,CertSecretSourceBuilder> {

    CertSecretSourceFluent<?> fluent;
    Boolean validationEnabled;

    public CertSecretSourceBuilder() {
        this(true);
    }

    public CertSecretSourceBuilder(Boolean validationEnabled) {
        this(new CertSecretSource(), validationEnabled);
    }

    public CertSecretSourceBuilder(CertSecretSourceFluent<?> fluent) {
        this(fluent, true);
    }

    public CertSecretSourceBuilder(CertSecretSourceFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new CertSecretSource(), validationEnabled);
    }

    public CertSecretSourceBuilder(CertSecretSourceFluent<?> fluent,CertSecretSource instance) {
        this(fluent, instance, true);
    }

    public CertSecretSourceBuilder(CertSecretSourceFluent<?> fluent,CertSecretSource instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withSecretName(instance.getSecretName());
        
        fluent.withCertificate(instance.getCertificate());
        
        this.validationEnabled = validationEnabled; 
    }

    public CertSecretSourceBuilder(CertSecretSource instance) {
        this(instance,true);
    }

    public CertSecretSourceBuilder(CertSecretSource instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withSecretName(instance.getSecretName());
        
        this.withCertificate(instance.getCertificate());
        
        this.validationEnabled = validationEnabled; 
    }

    public CertSecretSource build() {
        CertSecretSource buildable = new CertSecretSource();
        buildable.setSecretName(fluent.getSecretName());
        buildable.setCertificate(fluent.getCertificate());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        CertSecretSourceBuilder that = (CertSecretSourceBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
