package io.strimzi.api.kafka.model;

import java.lang.StringBuffer;
import java.lang.StringBuilder;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class CertAndKeySecretSourceFluentImpl<A extends CertAndKeySecretSourceFluent<A>> extends CertSecretSourceFluentImpl<A> implements CertAndKeySecretSourceFluent<A> {

    private String key;

    public CertAndKeySecretSourceFluentImpl() {
    }

    public CertAndKeySecretSourceFluentImpl(CertAndKeySecretSource instance) {
        this.withKey(instance.getKey());
        
        this.withSecretName(instance.getSecretName());
        
        this.withCertificate(instance.getCertificate());
    }

    public String getKey() {
        return this.key;
    }

    public A withKey(String key) {
        this.key=key; return (A) this;
    }

    public Boolean hasKey() {
        return this.key != null;
    }

    public A withNewKey(StringBuilder arg1) {
        return (A)withKey(new String(arg1));
    }

    public A withNewKey(int[] arg1,int arg2,int arg3) {
        return (A)withKey(new String(arg1, arg2, arg3));
    }

    public A withNewKey(char[] arg1) {
        return (A)withKey(new String(arg1));
    }

    public A withNewKey(StringBuffer arg1) {
        return (A)withKey(new String(arg1));
    }

    public A withNewKey(byte[] arg1,int arg2) {
        return (A)withKey(new String(arg1, arg2));
    }

    public A withNewKey(byte[] arg1) {
        return (A)withKey(new String(arg1));
    }

    public A withNewKey(char[] arg1,int arg2,int arg3) {
        return (A)withKey(new String(arg1, arg2, arg3));
    }

    public A withNewKey(byte[] arg1,int arg2,int arg3) {
        return (A)withKey(new String(arg1, arg2, arg3));
    }

    public A withNewKey(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withKey(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewKey(String arg1) {
        return (A)withKey(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        CertAndKeySecretSourceFluentImpl that = (CertAndKeySecretSourceFluentImpl) o;
        if (key != null ? !key.equals(that.key) :that.key != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(key,  super.hashCode());
    }

}
