package io.strimzi.api.kafka.model;

import java.lang.StringBuffer;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class AclRuleTransactionalIdResourceFluentImpl<A extends AclRuleTransactionalIdResourceFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements AclRuleTransactionalIdResourceFluent<A> {

    private AclResourcePatternType patternType;
    private String name;

    public AclRuleTransactionalIdResourceFluentImpl() {
    }

    public AclRuleTransactionalIdResourceFluentImpl(AclRuleTransactionalIdResource instance) {
        this.withPatternType(instance.getPatternType());
        
        this.withName(instance.getName());
    }

    public AclResourcePatternType getPatternType() {
        return this.patternType;
    }

    public A withPatternType(AclResourcePatternType patternType) {
        this.patternType=patternType; return (A) this;
    }

    public Boolean hasPatternType() {
        return this.patternType != null;
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name=name; return (A) this;
    }

    public Boolean hasName() {
        return this.name != null;
    }

    public A withNewName(StringBuilder arg1) {
        return (A)withName(new String(arg1));
    }

    public A withNewName(int[] arg1,int arg2,int arg3) {
        return (A)withName(new String(arg1, arg2, arg3));
    }

    public A withNewName(char[] arg1) {
        return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuffer arg1) {
        return (A)withName(new String(arg1));
    }

    public A withNewName(byte[] arg1,int arg2) {
        return (A)withName(new String(arg1, arg2));
    }

    public A withNewName(byte[] arg1) {
        return (A)withName(new String(arg1));
    }

    public A withNewName(char[] arg1,int arg2,int arg3) {
        return (A)withName(new String(arg1, arg2, arg3));
    }

    public A withNewName(byte[] arg1,int arg2,int arg3) {
        return (A)withName(new String(arg1, arg2, arg3));
    }

    public A withNewName(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withName(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewName(String arg1) {
        return (A)withName(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        AclRuleTransactionalIdResourceFluentImpl that = (AclRuleTransactionalIdResourceFluentImpl) o;
        if (patternType != null ? !patternType.equals(that.patternType) :that.patternType != null) return false;
        if (name != null ? !name.equals(that.name) :that.name != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(patternType,  name,  super.hashCode());
    }

}
