package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class AclRuleGroupResourceBuilder extends AclRuleGroupResourceFluentImpl<AclRuleGroupResourceBuilder> implements VisitableBuilder<AclRuleGroupResource,AclRuleGroupResourceBuilder> {

    AclRuleGroupResourceFluent<?> fluent;
    Boolean validationEnabled;

    public AclRuleGroupResourceBuilder() {
        this(true);
    }

    public AclRuleGroupResourceBuilder(Boolean validationEnabled) {
        this(new AclRuleGroupResource(), validationEnabled);
    }

    public AclRuleGroupResourceBuilder(AclRuleGroupResourceFluent<?> fluent) {
        this(fluent, true);
    }

    public AclRuleGroupResourceBuilder(AclRuleGroupResourceFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new AclRuleGroupResource(), validationEnabled);
    }

    public AclRuleGroupResourceBuilder(AclRuleGroupResourceFluent<?> fluent,AclRuleGroupResource instance) {
        this(fluent, instance, true);
    }

    public AclRuleGroupResourceBuilder(AclRuleGroupResourceFluent<?> fluent,AclRuleGroupResource instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withName(instance.getName());
        
        fluent.withPatternType(instance.getPatternType());
        
        this.validationEnabled = validationEnabled; 
    }

    public AclRuleGroupResourceBuilder(AclRuleGroupResource instance) {
        this(instance,true);
    }

    public AclRuleGroupResourceBuilder(AclRuleGroupResource instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withName(instance.getName());
        
        this.withPatternType(instance.getPatternType());
        
        this.validationEnabled = validationEnabled; 
    }

    public AclRuleGroupResource build() {
        AclRuleGroupResource buildable = new AclRuleGroupResource();
        buildable.setName(fluent.getName());
        buildable.setPatternType(fluent.getPatternType());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        AclRuleGroupResourceBuilder that = (AclRuleGroupResourceBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
