package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class AclRuleClusterResourceBuilder extends AclRuleClusterResourceFluentImpl<AclRuleClusterResourceBuilder> implements VisitableBuilder<AclRuleClusterResource,AclRuleClusterResourceBuilder> {

    AclRuleClusterResourceFluent<?> fluent;
    Boolean validationEnabled;

    public AclRuleClusterResourceBuilder() {
        this(true);
    }

    public AclRuleClusterResourceBuilder(Boolean validationEnabled) {
        this(new AclRuleClusterResource(), validationEnabled);
    }

    public AclRuleClusterResourceBuilder(AclRuleClusterResourceFluent<?> fluent) {
        this(fluent, true);
    }

    public AclRuleClusterResourceBuilder(AclRuleClusterResourceFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new AclRuleClusterResource(), validationEnabled);
    }

    public AclRuleClusterResourceBuilder(AclRuleClusterResourceFluent<?> fluent,AclRuleClusterResource instance) {
        this(fluent, instance, true);
    }

    public AclRuleClusterResourceBuilder(AclRuleClusterResourceFluent<?> fluent,AclRuleClusterResource instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        this.validationEnabled = validationEnabled; 
    }

    public AclRuleClusterResourceBuilder(AclRuleClusterResource instance) {
        this(instance,true);
    }

    public AclRuleClusterResourceBuilder(AclRuleClusterResource instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.validationEnabled = validationEnabled; 
    }

    public AclRuleClusterResource build() {
        AclRuleClusterResource buildable = new AclRuleClusterResource();
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        AclRuleClusterResourceBuilder that = (AclRuleClusterResourceBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
