/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.template;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.Affinity;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.PodSecurityContext;
import io.fabric8.kubernetes.api.model.Toleration;
import io.strimzi.api.kafka.model.UnknownPropertyPreserving;
import io.strimzi.api.kafka.model.template.MetadataTemplate;
import io.strimzi.crdgenerator.annotations.Description;
import io.strimzi.crdgenerator.annotations.KubeLink;
import io.strimzi.crdgenerator.annotations.Minimum;
import io.vertx.core.cli.annotations.DefaultValue;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"metadata", "imagePullSecrets", "securityContext", "terminationGracePeriodSeconds"})
public class PodTemplate
implements Serializable,
UnknownPropertyPreserving {
    private static final long serialVersionUID = 1L;
    private MetadataTemplate metadata;
    private List<LocalObjectReference> imagePullSecrets;
    private PodSecurityContext securityContext;
    private int terminationGracePeriodSeconds = 30;
    private Affinity affinity;
    private List<Toleration> tolerations;
    private String priorityClassName;
    private String schedulerName;
    private Map<String, Object> additionalProperties = new HashMap<String, Object>(0);

    @Description(value="Metadata applied to the resource.")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public MetadataTemplate getMetadata() {
        return this.metadata;
    }

    public void setMetadata(MetadataTemplate metadata) {
        this.metadata = metadata;
    }

    @Description(value="Configures pod-level security attributes and common container settings.")
    @KubeLink(group="core", version="v1", kind="podsecuritycontext")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public PodSecurityContext getSecurityContext() {
        return this.securityContext;
    }

    public void setSecurityContext(PodSecurityContext securityContext) {
        this.securityContext = securityContext;
    }

    @Description(value="List of references to secrets in the same namespace to use for pulling any of the images used by this Pod.")
    @KubeLink(group="core", version="v1", kind="localobjectreference")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public List<LocalObjectReference> getImagePullSecrets() {
        return this.imagePullSecrets;
    }

    public void setImagePullSecrets(List<LocalObjectReference> imagePullSecrets) {
        this.imagePullSecrets = imagePullSecrets;
    }

    @Description(value="The grace period is the duration in seconds after the processes running in the pod are sent a termination signal and the time when the processes are forcibly halted with a kill signal. Set this value longer than the expected cleanup time for your process.Value must be non-negative integer. The value zero indicates delete immediately. Defaults to 30 seconds.")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @DefaultValue(value="30")
    @Minimum(value=0)
    public int getTerminationGracePeriodSeconds() {
        return this.terminationGracePeriodSeconds;
    }

    public void setTerminationGracePeriodSeconds(int terminationGracePeriodSeconds) {
        this.terminationGracePeriodSeconds = terminationGracePeriodSeconds;
    }

    @Description(value="The pod's affinity rules.")
    @KubeLink(group="core", version="v1", kind="affinity")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Affinity getAffinity() {
        return this.affinity;
    }

    public void setAffinity(Affinity affinity) {
        this.affinity = affinity;
    }

    @Description(value="The pod's tolerations.")
    @KubeLink(group="core", version="v1", kind="toleration")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public List<Toleration> getTolerations() {
        return this.tolerations;
    }

    public void setTolerations(List<Toleration> tolerations) {
        this.tolerations = tolerations;
    }

    @Description(value="The name of the Priority Class to which these pods will be assigned.")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public String getPriorityClassName() {
        return this.priorityClassName;
    }

    public void setPriorityClassName(String priorityClassName) {
        this.priorityClassName = priorityClassName;
    }

    @Description(value="The name of the scheduler used to dispatch this `Pod`. If not specified, the default scheduler will be used.")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public String getSchedulerName() {
        return this.schedulerName;
    }

    public void setSchedulerName(String schedulerName) {
        this.schedulerName = schedulerName;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PodTemplate)) {
            return false;
        }
        PodTemplate other = (PodTemplate)o;
        if (!other.canEqual(this)) {
            return false;
        }
        MetadataTemplate this$metadata = this.getMetadata();
        MetadataTemplate other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        List<LocalObjectReference> this$imagePullSecrets = this.getImagePullSecrets();
        List<LocalObjectReference> other$imagePullSecrets = other.getImagePullSecrets();
        if (this$imagePullSecrets == null ? other$imagePullSecrets != null : !((Object)this$imagePullSecrets).equals(other$imagePullSecrets)) {
            return false;
        }
        PodSecurityContext this$securityContext = this.getSecurityContext();
        PodSecurityContext other$securityContext = other.getSecurityContext();
        if (this$securityContext == null ? other$securityContext != null : !this$securityContext.equals(other$securityContext)) {
            return false;
        }
        if (this.getTerminationGracePeriodSeconds() != other.getTerminationGracePeriodSeconds()) {
            return false;
        }
        Affinity this$affinity = this.getAffinity();
        Affinity other$affinity = other.getAffinity();
        if (this$affinity == null ? other$affinity != null : !this$affinity.equals(other$affinity)) {
            return false;
        }
        List<Toleration> this$tolerations = this.getTolerations();
        List<Toleration> other$tolerations = other.getTolerations();
        if (this$tolerations == null ? other$tolerations != null : !((Object)this$tolerations).equals(other$tolerations)) {
            return false;
        }
        String this$priorityClassName = this.getPriorityClassName();
        String other$priorityClassName = other.getPriorityClassName();
        if (this$priorityClassName == null ? other$priorityClassName != null : !this$priorityClassName.equals(other$priorityClassName)) {
            return false;
        }
        String this$schedulerName = this.getSchedulerName();
        String other$schedulerName = other.getSchedulerName();
        if (this$schedulerName == null ? other$schedulerName != null : !this$schedulerName.equals(other$schedulerName)) {
            return false;
        }
        Map<String, Object> this$additionalProperties = this.getAdditionalProperties();
        Map<String, Object> other$additionalProperties = other.getAdditionalProperties();
        return !(this$additionalProperties == null ? other$additionalProperties != null : !((Object)this$additionalProperties).equals(other$additionalProperties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PodTemplate;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MetadataTemplate $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        List<LocalObjectReference> $imagePullSecrets = this.getImagePullSecrets();
        result = result * 59 + ($imagePullSecrets == null ? 43 : ((Object)$imagePullSecrets).hashCode());
        PodSecurityContext $securityContext = this.getSecurityContext();
        result = result * 59 + ($securityContext == null ? 43 : $securityContext.hashCode());
        result = result * 59 + this.getTerminationGracePeriodSeconds();
        Affinity $affinity = this.getAffinity();
        result = result * 59 + ($affinity == null ? 43 : $affinity.hashCode());
        List<Toleration> $tolerations = this.getTolerations();
        result = result * 59 + ($tolerations == null ? 43 : ((Object)$tolerations).hashCode());
        String $priorityClassName = this.getPriorityClassName();
        result = result * 59 + ($priorityClassName == null ? 43 : $priorityClassName.hashCode());
        String $schedulerName = this.getSchedulerName();
        result = result * 59 + ($schedulerName == null ? 43 : $schedulerName.hashCode());
        Map<String, Object> $additionalProperties = this.getAdditionalProperties();
        result = result * 59 + ($additionalProperties == null ? 43 : ((Object)$additionalProperties).hashCode());
        return result;
    }
}

