/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.storage;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.strimzi.api.kafka.model.storage.PersistentClaimStorage;
import io.strimzi.api.kafka.model.storage.PersistentClaimStorageFluent;
import io.strimzi.api.kafka.model.storage.PersistentClaimStorageOverride;
import io.strimzi.api.kafka.model.storage.PersistentClaimStorageOverrideBuilder;
import io.strimzi.api.kafka.model.storage.PersistentClaimStorageOverrideFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class PersistentClaimStorageFluentImpl<A extends PersistentClaimStorageFluent<A>>
extends BaseFluent<A>
implements PersistentClaimStorageFluent<A> {
    private String size;
    private String storageClass;
    private Map<String, String> selector;
    private boolean deleteClaim;
    private List<PersistentClaimStorageOverrideBuilder> overrides;
    private Integer id;

    public PersistentClaimStorageFluentImpl() {
    }

    public PersistentClaimStorageFluentImpl(PersistentClaimStorage instance) {
        this.withSize(instance.getSize());
        this.withStorageClass(instance.getStorageClass());
        this.withSelector(instance.getSelector());
        this.withDeleteClaim(instance.isDeleteClaim());
        this.withOverrides(instance.getOverrides());
        this.withId(instance.getId());
    }

    @Override
    public String getSize() {
        return this.size;
    }

    @Override
    public A withSize(String size) {
        this.size = size;
        return (A)this;
    }

    @Override
    public Boolean hasSize() {
        return this.size != null;
    }

    @Override
    public A withNewSize(String arg1) {
        return this.withSize(new String(arg1));
    }

    @Override
    public A withNewSize(StringBuilder arg1) {
        return this.withSize(new String(arg1));
    }

    @Override
    public A withNewSize(StringBuffer arg1) {
        return this.withSize(new String(arg1));
    }

    @Override
    public String getStorageClass() {
        return this.storageClass;
    }

    @Override
    public A withStorageClass(String storageClass) {
        this.storageClass = storageClass;
        return (A)this;
    }

    @Override
    public Boolean hasStorageClass() {
        return this.storageClass != null;
    }

    @Override
    public A withNewStorageClass(String arg1) {
        return this.withStorageClass(new String(arg1));
    }

    @Override
    public A withNewStorageClass(StringBuilder arg1) {
        return this.withStorageClass(new String(arg1));
    }

    @Override
    public A withNewStorageClass(StringBuffer arg1) {
        return this.withStorageClass(new String(arg1));
    }

    @Override
    public A addToSelector(String key, String value) {
        if (this.selector == null && key != null && value != null) {
            this.selector = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.selector.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToSelector(Map<String, String> map) {
        if (this.selector == null && map != null) {
            this.selector = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.selector.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromSelector(String key) {
        if (this.selector == null) {
            return (A)this;
        }
        if (key != null && this.selector != null) {
            this.selector.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromSelector(Map<String, String> map) {
        if (this.selector == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.selector == null) continue;
                this.selector.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, String> getSelector() {
        return this.selector;
    }

    @Override
    public A withSelector(Map<String, String> selector) {
        this.selector = selector == null ? null : new LinkedHashMap<String, String>(selector);
        return (A)this;
    }

    @Override
    public Boolean hasSelector() {
        return this.selector != null;
    }

    @Override
    public boolean isDeleteClaim() {
        return this.deleteClaim;
    }

    @Override
    public A withDeleteClaim(boolean deleteClaim) {
        this.deleteClaim = deleteClaim;
        return (A)this;
    }

    @Override
    public Boolean hasDeleteClaim() {
        return true;
    }

    @Override
    public A addToOverrides(int index, PersistentClaimStorageOverride item) {
        if (this.overrides == null) {
            this.overrides = new ArrayList<PersistentClaimStorageOverrideBuilder>();
        }
        PersistentClaimStorageOverrideBuilder builder = new PersistentClaimStorageOverrideBuilder(item);
        this._visitables.get((Object)"overrides").add(index >= 0 ? index : this._visitables.get((Object)"overrides").size(), builder);
        this.overrides.add(index >= 0 ? index : this.overrides.size(), builder);
        return (A)this;
    }

    @Override
    public A setToOverrides(int index, PersistentClaimStorageOverride item) {
        if (this.overrides == null) {
            this.overrides = new ArrayList<PersistentClaimStorageOverrideBuilder>();
        }
        PersistentClaimStorageOverrideBuilder builder = new PersistentClaimStorageOverrideBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"overrides").size()) {
            this._visitables.get((Object)"overrides").add(builder);
        } else {
            this._visitables.get((Object)"overrides").set(index, builder);
        }
        if (index < 0 || index >= this.overrides.size()) {
            this.overrides.add(builder);
        } else {
            this.overrides.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToOverrides(PersistentClaimStorageOverride ... items) {
        if (this.overrides == null) {
            this.overrides = new ArrayList<PersistentClaimStorageOverrideBuilder>();
        }
        for (PersistentClaimStorageOverride item : items) {
            PersistentClaimStorageOverrideBuilder builder = new PersistentClaimStorageOverrideBuilder(item);
            this._visitables.get((Object)"overrides").add(builder);
            this.overrides.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToOverrides(Collection<PersistentClaimStorageOverride> items) {
        if (this.overrides == null) {
            this.overrides = new ArrayList<PersistentClaimStorageOverrideBuilder>();
        }
        for (PersistentClaimStorageOverride item : items) {
            PersistentClaimStorageOverrideBuilder builder = new PersistentClaimStorageOverrideBuilder(item);
            this._visitables.get((Object)"overrides").add(builder);
            this.overrides.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromOverrides(PersistentClaimStorageOverride ... items) {
        for (PersistentClaimStorageOverride item : items) {
            PersistentClaimStorageOverrideBuilder builder = new PersistentClaimStorageOverrideBuilder(item);
            this._visitables.get((Object)"overrides").remove(builder);
            if (this.overrides == null) continue;
            this.overrides.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromOverrides(Collection<PersistentClaimStorageOverride> items) {
        for (PersistentClaimStorageOverride item : items) {
            PersistentClaimStorageOverrideBuilder builder = new PersistentClaimStorageOverrideBuilder(item);
            this._visitables.get((Object)"overrides").remove(builder);
            if (this.overrides == null) continue;
            this.overrides.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromOverrides(Predicate<PersistentClaimStorageOverrideBuilder> predicate) {
        if (this.overrides == null) {
            return (A)this;
        }
        Iterator<PersistentClaimStorageOverrideBuilder> each = this.overrides.iterator();
        List visitables = this._visitables.get((Object)"overrides");
        while (each.hasNext()) {
            PersistentClaimStorageOverrideBuilder builder = each.next();
            if (!predicate.apply((Object)builder).booleanValue()) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<PersistentClaimStorageOverride> getOverrides() {
        return PersistentClaimStorageFluentImpl.build(this.overrides);
    }

    @Override
    public List<PersistentClaimStorageOverride> buildOverrides() {
        return PersistentClaimStorageFluentImpl.build(this.overrides);
    }

    @Override
    public PersistentClaimStorageOverride buildOverride(int index) {
        return this.overrides.get(index).build();
    }

    @Override
    public PersistentClaimStorageOverride buildFirstOverride() {
        return this.overrides.get(0).build();
    }

    @Override
    public PersistentClaimStorageOverride buildLastOverride() {
        return this.overrides.get(this.overrides.size() - 1).build();
    }

    @Override
    public PersistentClaimStorageOverride buildMatchingOverride(Predicate<PersistentClaimStorageOverrideBuilder> predicate) {
        for (PersistentClaimStorageOverrideBuilder item : this.overrides) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingOverride(Predicate<PersistentClaimStorageOverrideBuilder> predicate) {
        for (PersistentClaimStorageOverrideBuilder item : this.overrides) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withOverrides(List<PersistentClaimStorageOverride> overrides) {
        if (this.overrides != null) {
            this._visitables.get((Object)"overrides").removeAll(this.overrides);
        }
        if (overrides != null) {
            this.overrides = new ArrayList<PersistentClaimStorageOverrideBuilder>();
            for (PersistentClaimStorageOverride item : overrides) {
                this.addToOverrides(item);
            }
        } else {
            this.overrides = null;
        }
        return (A)this;
    }

    @Override
    public A withOverrides(PersistentClaimStorageOverride ... overrides) {
        if (this.overrides != null) {
            this.overrides.clear();
        }
        if (overrides != null) {
            for (PersistentClaimStorageOverride item : overrides) {
                this.addToOverrides(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasOverrides() {
        return this.overrides != null && !this.overrides.isEmpty();
    }

    @Override
    public PersistentClaimStorageFluent.OverridesNested<A> addNewOverride() {
        return new OverridesNestedImpl();
    }

    @Override
    public PersistentClaimStorageFluent.OverridesNested<A> addNewOverrideLike(PersistentClaimStorageOverride item) {
        return new OverridesNestedImpl(-1, item);
    }

    @Override
    public PersistentClaimStorageFluent.OverridesNested<A> setNewOverrideLike(int index, PersistentClaimStorageOverride item) {
        return new OverridesNestedImpl(index, item);
    }

    @Override
    public PersistentClaimStorageFluent.OverridesNested<A> editOverride(int index) {
        if (this.overrides.size() <= index) {
            throw new RuntimeException("Can't edit overrides. Index exceeds size.");
        }
        return this.setNewOverrideLike(index, this.buildOverride(index));
    }

    @Override
    public PersistentClaimStorageFluent.OverridesNested<A> editFirstOverride() {
        if (this.overrides.size() == 0) {
            throw new RuntimeException("Can't edit first overrides. The list is empty.");
        }
        return this.setNewOverrideLike(0, this.buildOverride(0));
    }

    @Override
    public PersistentClaimStorageFluent.OverridesNested<A> editLastOverride() {
        int index = this.overrides.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last overrides. The list is empty.");
        }
        return this.setNewOverrideLike(index, this.buildOverride(index));
    }

    @Override
    public PersistentClaimStorageFluent.OverridesNested<A> editMatchingOverride(Predicate<PersistentClaimStorageOverrideBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.overrides.size(); ++i) {
            if (!predicate.apply((Object)this.overrides.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching overrides. No match found.");
        }
        return this.setNewOverrideLike(index, this.buildOverride(index));
    }

    @Override
    public Integer getId() {
        return this.id;
    }

    @Override
    public A withId(Integer id) {
        this.id = id;
        return (A)this;
    }

    @Override
    public Boolean hasId() {
        return this.id != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PersistentClaimStorageFluentImpl that = (PersistentClaimStorageFluentImpl)o;
        if (this.size != null ? !this.size.equals(that.size) : that.size != null) {
            return false;
        }
        if (this.storageClass != null ? !this.storageClass.equals(that.storageClass) : that.storageClass != null) {
            return false;
        }
        if (this.selector != null ? !this.selector.equals(that.selector) : that.selector != null) {
            return false;
        }
        if (this.deleteClaim != that.deleteClaim) {
            return false;
        }
        if (this.overrides != null ? !this.overrides.equals(that.overrides) : that.overrides != null) {
            return false;
        }
        return !(this.id != null ? !this.id.equals(that.id) : that.id != null);
    }

    public class OverridesNestedImpl<N>
    extends PersistentClaimStorageOverrideFluentImpl<PersistentClaimStorageFluent.OverridesNested<N>>
    implements PersistentClaimStorageFluent.OverridesNested<N>,
    Nested<N> {
        private final PersistentClaimStorageOverrideBuilder builder;
        private final int index;

        OverridesNestedImpl(int index, PersistentClaimStorageOverride item) {
            this.index = index;
            this.builder = new PersistentClaimStorageOverrideBuilder(this, item);
        }

        OverridesNestedImpl() {
            this.index = -1;
            this.builder = new PersistentClaimStorageOverrideBuilder(this);
        }

        @Override
        public N and() {
            return (N)PersistentClaimStorageFluentImpl.this.setToOverrides(this.index, this.builder.build());
        }

        @Override
        public N endOverride() {
            return this.and();
        }
    }
}

