/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.storage;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.strimzi.api.kafka.model.storage.SingleVolumeStorage;
import io.strimzi.crdgenerator.annotations.Description;
import io.strimzi.crdgenerator.annotations.Minimum;
import io.strimzi.crdgenerator.annotations.Pattern;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class EphemeralStorage
extends SingleVolumeStorage {
    private static final long serialVersionUID = 1L;
    private Integer id;
    private String sizeLimit;

    @Override
    @Description(value="Must be `ephemeral`")
    public String getType() {
        return "ephemeral";
    }

    @Override
    @Description(value="Storage identification number. It is mandatory only for storage volumes defined in a storage of type 'jbod'")
    @Minimum(value=0)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Integer getId() {
        return super.getId();
    }

    @Override
    public void setId(Integer id) {
        super.setId(id);
    }

    @Pattern(value="^([0-9.]+)([eEinumkKMGTP]*[-+]?[0-9]*)$")
    @Description(value="When type=ephemeral, defines the total amount of local storage required for this EmptyDir volume (for example 1Gi).")
    public String getSizeLimit() {
        return this.sizeLimit;
    }

    public void setSizeLimit(String sizeLimit) {
        this.sizeLimit = sizeLimit;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EphemeralStorage)) {
            return false;
        }
        EphemeralStorage other = (EphemeralStorage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$id = this.getId();
        Integer other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$sizeLimit = this.getSizeLimit();
        String other$sizeLimit = other.getSizeLimit();
        return !(this$sizeLimit == null ? other$sizeLimit != null : !this$sizeLimit.equals(other$sizeLimit));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof EphemeralStorage;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $sizeLimit = this.getSizeLimit();
        result = result * 59 + ($sizeLimit == null ? 43 : $sizeLimit.hashCode());
        return result;
    }
}

