/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.listener;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.strimzi.api.kafka.model.listener.KafkaListenerExternalConfiguration;
import io.strimzi.api.kafka.model.listener.NodeAddressType;
import io.strimzi.crdgenerator.annotations.Description;

@JsonPropertyOrder(value={"brokerCertChainAndKey", "preferredAddressType"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class NodePortListenerConfiguration
extends KafkaListenerExternalConfiguration {
    private static final long serialVersionUID = 1L;
    private NodeAddressType preferredAddressType;

    @Description(value="Defines which address type should be used as the node address. Available types are: `ExternalDNS`, `ExternalIP`, `InternalDNS`, `InternalIP` and `Hostname`. By default, the addresses will be used in the following order (the first one found will be used):\n* `ExternalDNS`\n* `ExternalIP`\n* `InternalDNS`\n* `InternalIP`\n* `Hostname`\n\nThis field can be used to select the address type which will be used as the preferred type and checked first. In case no address will be found for this address type, the other types will be used in the default order.")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public NodeAddressType getPreferredAddressType() {
        return this.preferredAddressType;
    }

    public void setPreferredAddressType(NodeAddressType preferredAddressType) {
        this.preferredAddressType = preferredAddressType;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NodePortListenerConfiguration)) {
            return false;
        }
        NodePortListenerConfiguration other = (NodePortListenerConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NodeAddressType this$preferredAddressType = this.getPreferredAddressType();
        NodeAddressType other$preferredAddressType = other.getPreferredAddressType();
        return !(this$preferredAddressType == null ? other$preferredAddressType != null : !((Object)((Object)this$preferredAddressType)).equals((Object)other$preferredAddressType));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof NodePortListenerConfiguration;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        NodeAddressType $preferredAddressType = this.getPreferredAddressType();
        result = result * 59 + ($preferredAddressType == null ? 43 : ((Object)((Object)$preferredAddressType)).hashCode());
        return result;
    }
}

