/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.listener;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.networking.NetworkPolicyPeer;
import io.strimzi.api.kafka.model.listener.KafkaListenerAuthentication;
import io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationOAuth;
import io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationOAuthBuilder;
import io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationOAuthFluentImpl;
import io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationScramSha512;
import io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationScramSha512Builder;
import io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationScramSha512FluentImpl;
import io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationTls;
import io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationTlsBuilder;
import io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationTlsFluentImpl;
import io.strimzi.api.kafka.model.listener.KafkaListenerTls;
import io.strimzi.api.kafka.model.listener.KafkaListenerTlsFluent;
import io.strimzi.api.kafka.model.listener.TlsListenerConfiguration;
import io.strimzi.api.kafka.model.listener.TlsListenerConfigurationBuilder;
import io.strimzi.api.kafka.model.listener.TlsListenerConfigurationFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class KafkaListenerTlsFluentImpl<A extends KafkaListenerTlsFluent<A>>
extends BaseFluent<A>
implements KafkaListenerTlsFluent<A> {
    private VisitableBuilder<? extends KafkaListenerAuthentication, ?> auth;
    private List<NetworkPolicyPeer> networkPolicyPeers;
    private TlsListenerConfigurationBuilder configuration;

    public KafkaListenerTlsFluentImpl() {
    }

    public KafkaListenerTlsFluentImpl(KafkaListenerTls instance) {
        this.withAuth(instance.getAuth());
        this.withNetworkPolicyPeers(instance.getNetworkPolicyPeers());
        this.withConfiguration(instance.getConfiguration());
    }

    @Override
    @Deprecated
    public KafkaListenerAuthentication getAuth() {
        return this.auth != null ? (KafkaListenerAuthentication)this.auth.build() : null;
    }

    @Override
    public KafkaListenerAuthentication buildAuth() {
        return this.auth != null ? (KafkaListenerAuthentication)this.auth.build() : null;
    }

    @Override
    public A withAuth(KafkaListenerAuthentication auth) {
        this._visitables.get((Object)"auth").remove(this.auth);
        if (auth instanceof KafkaListenerAuthenticationOAuth) {
            this.auth = new KafkaListenerAuthenticationOAuthBuilder((KafkaListenerAuthenticationOAuth)auth);
            this._visitables.get((Object)"auth").add(this.auth);
        }
        if (auth instanceof KafkaListenerAuthenticationTls) {
            this.auth = new KafkaListenerAuthenticationTlsBuilder((KafkaListenerAuthenticationTls)auth);
            this._visitables.get((Object)"auth").add(this.auth);
        }
        if (auth instanceof KafkaListenerAuthenticationScramSha512) {
            this.auth = new KafkaListenerAuthenticationScramSha512Builder((KafkaListenerAuthenticationScramSha512)auth);
            this._visitables.get((Object)"auth").add(this.auth);
        }
        return (A)this;
    }

    @Override
    public Boolean hasAuth() {
        return this.auth != null;
    }

    @Override
    public A withKafkaListenerAuthenticationOAuth(KafkaListenerAuthenticationOAuth kafkaListenerAuthenticationOAuth) {
        this._visitables.get((Object)"auth").remove(this.auth);
        if (kafkaListenerAuthenticationOAuth != null) {
            this.auth = new KafkaListenerAuthenticationOAuthBuilder(kafkaListenerAuthenticationOAuth);
            this._visitables.get((Object)"auth").add(this.auth);
        }
        return (A)this;
    }

    @Override
    public KafkaListenerTlsFluent.KafkaListenerAuthenticationOAuthNested<A> withNewKafkaListenerAuthenticationOAuth() {
        return new KafkaListenerAuthenticationOAuthNestedImpl();
    }

    @Override
    public KafkaListenerTlsFluent.KafkaListenerAuthenticationOAuthNested<A> withNewKafkaListenerAuthenticationOAuthLike(KafkaListenerAuthenticationOAuth item) {
        return new KafkaListenerAuthenticationOAuthNestedImpl(item);
    }

    @Override
    public A withKafkaListenerAuthenticationTlsAuth(KafkaListenerAuthenticationTls kafkaListenerAuthenticationTlsAuth) {
        this._visitables.get((Object)"auth").remove(this.auth);
        if (kafkaListenerAuthenticationTlsAuth != null) {
            this.auth = new KafkaListenerAuthenticationTlsBuilder(kafkaListenerAuthenticationTlsAuth);
            this._visitables.get((Object)"auth").add(this.auth);
        }
        return (A)this;
    }

    @Override
    public KafkaListenerTlsFluent.KafkaListenerAuthenticationTlsAuthNested<A> withNewKafkaListenerAuthenticationTlsAuth() {
        return new KafkaListenerAuthenticationTlsAuthNestedImpl();
    }

    @Override
    public KafkaListenerTlsFluent.KafkaListenerAuthenticationTlsAuthNested<A> withNewKafkaListenerAuthenticationTlsAuthLike(KafkaListenerAuthenticationTls item) {
        return new KafkaListenerAuthenticationTlsAuthNestedImpl(item);
    }

    @Override
    public A withKafkaListenerAuthenticationScramSha512Auth(KafkaListenerAuthenticationScramSha512 kafkaListenerAuthenticationScramSha512Auth) {
        this._visitables.get((Object)"auth").remove(this.auth);
        if (kafkaListenerAuthenticationScramSha512Auth != null) {
            this.auth = new KafkaListenerAuthenticationScramSha512Builder(kafkaListenerAuthenticationScramSha512Auth);
            this._visitables.get((Object)"auth").add(this.auth);
        }
        return (A)this;
    }

    @Override
    public KafkaListenerTlsFluent.KafkaListenerAuthenticationScramSha512AuthNested<A> withNewKafkaListenerAuthenticationScramSha512Auth() {
        return new KafkaListenerAuthenticationScramSha512AuthNestedImpl();
    }

    @Override
    public KafkaListenerTlsFluent.KafkaListenerAuthenticationScramSha512AuthNested<A> withNewKafkaListenerAuthenticationScramSha512AuthLike(KafkaListenerAuthenticationScramSha512 item) {
        return new KafkaListenerAuthenticationScramSha512AuthNestedImpl(item);
    }

    @Override
    public A addToNetworkPolicyPeers(int index, NetworkPolicyPeer item) {
        if (this.networkPolicyPeers == null) {
            this.networkPolicyPeers = new ArrayList<NetworkPolicyPeer>();
        }
        this.networkPolicyPeers.add(index, item);
        return (A)this;
    }

    @Override
    public A setToNetworkPolicyPeers(int index, NetworkPolicyPeer item) {
        if (this.networkPolicyPeers == null) {
            this.networkPolicyPeers = new ArrayList<NetworkPolicyPeer>();
        }
        this.networkPolicyPeers.set(index, item);
        return (A)this;
    }

    @Override
    public A addToNetworkPolicyPeers(NetworkPolicyPeer ... items) {
        if (this.networkPolicyPeers == null) {
            this.networkPolicyPeers = new ArrayList<NetworkPolicyPeer>();
        }
        for (NetworkPolicyPeer item : items) {
            this.networkPolicyPeers.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToNetworkPolicyPeers(Collection<NetworkPolicyPeer> items) {
        if (this.networkPolicyPeers == null) {
            this.networkPolicyPeers = new ArrayList<NetworkPolicyPeer>();
        }
        for (NetworkPolicyPeer item : items) {
            this.networkPolicyPeers.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromNetworkPolicyPeers(NetworkPolicyPeer ... items) {
        for (NetworkPolicyPeer item : items) {
            if (this.networkPolicyPeers == null) continue;
            this.networkPolicyPeers.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromNetworkPolicyPeers(Collection<NetworkPolicyPeer> items) {
        for (NetworkPolicyPeer item : items) {
            if (this.networkPolicyPeers == null) continue;
            this.networkPolicyPeers.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<NetworkPolicyPeer> getNetworkPolicyPeers() {
        return this.networkPolicyPeers;
    }

    @Override
    public NetworkPolicyPeer getNetworkPolicyPeer(int index) {
        return this.networkPolicyPeers.get(index);
    }

    @Override
    public NetworkPolicyPeer getFirstNetworkPolicyPeer() {
        return this.networkPolicyPeers.get(0);
    }

    @Override
    public NetworkPolicyPeer getLastNetworkPolicyPeer() {
        return this.networkPolicyPeers.get(this.networkPolicyPeers.size() - 1);
    }

    @Override
    public NetworkPolicyPeer getMatchingNetworkPolicyPeer(Predicate<NetworkPolicyPeer> predicate) {
        for (NetworkPolicyPeer item : this.networkPolicyPeers) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingNetworkPolicyPeer(Predicate<NetworkPolicyPeer> predicate) {
        for (NetworkPolicyPeer item : this.networkPolicyPeers) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withNetworkPolicyPeers(List<NetworkPolicyPeer> networkPolicyPeers) {
        if (this.networkPolicyPeers != null) {
            this._visitables.get((Object)"networkPolicyPeers").removeAll(this.networkPolicyPeers);
        }
        if (networkPolicyPeers != null) {
            this.networkPolicyPeers = new ArrayList<NetworkPolicyPeer>();
            for (NetworkPolicyPeer item : networkPolicyPeers) {
                this.addToNetworkPolicyPeers(item);
            }
        } else {
            this.networkPolicyPeers = null;
        }
        return (A)this;
    }

    @Override
    public A withNetworkPolicyPeers(NetworkPolicyPeer ... networkPolicyPeers) {
        if (this.networkPolicyPeers != null) {
            this.networkPolicyPeers.clear();
        }
        if (networkPolicyPeers != null) {
            for (NetworkPolicyPeer item : networkPolicyPeers) {
                this.addToNetworkPolicyPeers(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasNetworkPolicyPeers() {
        return this.networkPolicyPeers != null && !this.networkPolicyPeers.isEmpty();
    }

    @Override
    @Deprecated
    public TlsListenerConfiguration getConfiguration() {
        return this.configuration != null ? this.configuration.build() : null;
    }

    @Override
    public TlsListenerConfiguration buildConfiguration() {
        return this.configuration != null ? this.configuration.build() : null;
    }

    @Override
    public A withConfiguration(TlsListenerConfiguration configuration) {
        this._visitables.get((Object)"configuration").remove(this.configuration);
        if (configuration != null) {
            this.configuration = new TlsListenerConfigurationBuilder(configuration);
            this._visitables.get((Object)"configuration").add(this.configuration);
        }
        return (A)this;
    }

    @Override
    public Boolean hasConfiguration() {
        return this.configuration != null;
    }

    @Override
    public KafkaListenerTlsFluent.ConfigurationNested<A> withNewConfiguration() {
        return new ConfigurationNestedImpl();
    }

    @Override
    public KafkaListenerTlsFluent.ConfigurationNested<A> withNewConfigurationLike(TlsListenerConfiguration item) {
        return new ConfigurationNestedImpl(item);
    }

    @Override
    public KafkaListenerTlsFluent.ConfigurationNested<A> editConfiguration() {
        return this.withNewConfigurationLike(this.getConfiguration());
    }

    @Override
    public KafkaListenerTlsFluent.ConfigurationNested<A> editOrNewConfiguration() {
        return this.withNewConfigurationLike(this.getConfiguration() != null ? this.getConfiguration() : new TlsListenerConfigurationBuilder().build());
    }

    @Override
    public KafkaListenerTlsFluent.ConfigurationNested<A> editOrNewConfigurationLike(TlsListenerConfiguration item) {
        return this.withNewConfigurationLike(this.getConfiguration() != null ? this.getConfiguration() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KafkaListenerTlsFluentImpl that = (KafkaListenerTlsFluentImpl)o;
        if (this.auth != null ? !this.auth.equals(that.auth) : that.auth != null) {
            return false;
        }
        if (this.networkPolicyPeers != null ? !this.networkPolicyPeers.equals(that.networkPolicyPeers) : that.networkPolicyPeers != null) {
            return false;
        }
        return !(this.configuration != null ? !this.configuration.equals(that.configuration) : that.configuration != null);
    }

    public class ConfigurationNestedImpl<N>
    extends TlsListenerConfigurationFluentImpl<KafkaListenerTlsFluent.ConfigurationNested<N>>
    implements KafkaListenerTlsFluent.ConfigurationNested<N>,
    Nested<N> {
        private final TlsListenerConfigurationBuilder builder;

        ConfigurationNestedImpl(TlsListenerConfiguration item) {
            this.builder = new TlsListenerConfigurationBuilder(this, item);
        }

        ConfigurationNestedImpl() {
            this.builder = new TlsListenerConfigurationBuilder(this);
        }

        @Override
        public N and() {
            return (N)KafkaListenerTlsFluentImpl.this.withConfiguration(this.builder.build());
        }

        @Override
        public N endConfiguration() {
            return this.and();
        }
    }

    public class KafkaListenerAuthenticationScramSha512AuthNestedImpl<N>
    extends KafkaListenerAuthenticationScramSha512FluentImpl<KafkaListenerTlsFluent.KafkaListenerAuthenticationScramSha512AuthNested<N>>
    implements KafkaListenerTlsFluent.KafkaListenerAuthenticationScramSha512AuthNested<N>,
    Nested<N> {
        private final KafkaListenerAuthenticationScramSha512Builder builder;

        KafkaListenerAuthenticationScramSha512AuthNestedImpl(KafkaListenerAuthenticationScramSha512 item) {
            this.builder = new KafkaListenerAuthenticationScramSha512Builder(this, item);
        }

        KafkaListenerAuthenticationScramSha512AuthNestedImpl() {
            this.builder = new KafkaListenerAuthenticationScramSha512Builder(this);
        }

        @Override
        public N and() {
            return (N)KafkaListenerTlsFluentImpl.this.withKafkaListenerAuthenticationScramSha512Auth(this.builder.build());
        }

        @Override
        public N endKafkaListenerAuthenticationScramSha512Auth() {
            return this.and();
        }
    }

    public class KafkaListenerAuthenticationTlsAuthNestedImpl<N>
    extends KafkaListenerAuthenticationTlsFluentImpl<KafkaListenerTlsFluent.KafkaListenerAuthenticationTlsAuthNested<N>>
    implements KafkaListenerTlsFluent.KafkaListenerAuthenticationTlsAuthNested<N>,
    Nested<N> {
        private final KafkaListenerAuthenticationTlsBuilder builder;

        KafkaListenerAuthenticationTlsAuthNestedImpl(KafkaListenerAuthenticationTls item) {
            this.builder = new KafkaListenerAuthenticationTlsBuilder(this, item);
        }

        KafkaListenerAuthenticationTlsAuthNestedImpl() {
            this.builder = new KafkaListenerAuthenticationTlsBuilder(this);
        }

        @Override
        public N and() {
            return (N)KafkaListenerTlsFluentImpl.this.withKafkaListenerAuthenticationTlsAuth(this.builder.build());
        }

        @Override
        public N endKafkaListenerAuthenticationTlsAuth() {
            return this.and();
        }
    }

    public class KafkaListenerAuthenticationOAuthNestedImpl<N>
    extends KafkaListenerAuthenticationOAuthFluentImpl<KafkaListenerTlsFluent.KafkaListenerAuthenticationOAuthNested<N>>
    implements KafkaListenerTlsFluent.KafkaListenerAuthenticationOAuthNested<N>,
    Nested<N> {
        private final KafkaListenerAuthenticationOAuthBuilder builder;

        KafkaListenerAuthenticationOAuthNestedImpl(KafkaListenerAuthenticationOAuth item) {
            this.builder = new KafkaListenerAuthenticationOAuthBuilder(this, item);
        }

        KafkaListenerAuthenticationOAuthNestedImpl() {
            this.builder = new KafkaListenerAuthenticationOAuthBuilder(this);
        }

        @Override
        public N and() {
            return (N)KafkaListenerTlsFluentImpl.this.withKafkaListenerAuthenticationOAuth(this.builder.build());
        }

        @Override
        public N endKafkaListenerAuthenticationOAuth() {
            return this.and();
        }
    }
}

