/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.listener;

import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.strimzi.api.kafka.model.CertSecretSource;
import io.strimzi.api.kafka.model.CertSecretSourceBuilder;
import io.strimzi.api.kafka.model.CertSecretSourceFluentImpl;
import io.strimzi.api.kafka.model.GenericSecretSource;
import io.strimzi.api.kafka.model.GenericSecretSourceBuilder;
import io.strimzi.api.kafka.model.GenericSecretSourceFluentImpl;
import io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationFluentImpl;
import io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationOAuth;
import io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationOAuthFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class KafkaListenerAuthenticationOAuthFluentImpl<A extends KafkaListenerAuthenticationOAuthFluent<A>>
extends KafkaListenerAuthenticationFluentImpl<A>
implements KafkaListenerAuthenticationOAuthFluent<A> {
    private String clientId;
    private GenericSecretSourceBuilder clientSecret;
    private String validIssuerUri;
    private String jwksEndpointUri;
    private int jwksRefreshSeconds;
    private int jwksExpirySeconds;
    private String introspectionEndpointUri;
    private String userNameClaim;
    private boolean checkAccessTokenType;
    private boolean accessTokenIsJwt;
    private List<CertSecretSourceBuilder> tlsTrustedCertificates;
    private boolean disableTlsHostnameVerification;

    public KafkaListenerAuthenticationOAuthFluentImpl() {
    }

    public KafkaListenerAuthenticationOAuthFluentImpl(KafkaListenerAuthenticationOAuth instance) {
        this.withClientId(instance.getClientId());
        this.withClientSecret(instance.getClientSecret());
        this.withValidIssuerUri(instance.getValidIssuerUri());
        this.withJwksEndpointUri(instance.getJwksEndpointUri());
        this.withJwksRefreshSeconds(instance.getJwksRefreshSeconds());
        this.withJwksExpirySeconds(instance.getJwksExpirySeconds());
        this.withIntrospectionEndpointUri(instance.getIntrospectionEndpointUri());
        this.withUserNameClaim(instance.getUserNameClaim());
        this.withCheckAccessTokenType(instance.isCheckAccessTokenType());
        this.withAccessTokenIsJwt(instance.isAccessTokenIsJwt());
        this.withTlsTrustedCertificates(instance.getTlsTrustedCertificates());
        this.withDisableTlsHostnameVerification(instance.isDisableTlsHostnameVerification());
    }

    @Override
    public String getClientId() {
        return this.clientId;
    }

    @Override
    public A withClientId(String clientId) {
        this.clientId = clientId;
        return (A)this;
    }

    @Override
    public Boolean hasClientId() {
        return this.clientId != null;
    }

    @Override
    public A withNewClientId(String arg1) {
        return this.withClientId(new String(arg1));
    }

    @Override
    public A withNewClientId(StringBuilder arg1) {
        return this.withClientId(new String(arg1));
    }

    @Override
    public A withNewClientId(StringBuffer arg1) {
        return this.withClientId(new String(arg1));
    }

    @Override
    @Deprecated
    public GenericSecretSource getClientSecret() {
        return this.clientSecret != null ? this.clientSecret.build() : null;
    }

    @Override
    public GenericSecretSource buildClientSecret() {
        return this.clientSecret != null ? this.clientSecret.build() : null;
    }

    @Override
    public A withClientSecret(GenericSecretSource clientSecret) {
        this._visitables.get((Object)"clientSecret").remove(this.clientSecret);
        if (clientSecret != null) {
            this.clientSecret = new GenericSecretSourceBuilder(clientSecret);
            this._visitables.get((Object)"clientSecret").add(this.clientSecret);
        }
        return (A)this;
    }

    @Override
    public Boolean hasClientSecret() {
        return this.clientSecret != null;
    }

    @Override
    public KafkaListenerAuthenticationOAuthFluent.ClientSecretNested<A> withNewClientSecret() {
        return new ClientSecretNestedImpl();
    }

    @Override
    public KafkaListenerAuthenticationOAuthFluent.ClientSecretNested<A> withNewClientSecretLike(GenericSecretSource item) {
        return new ClientSecretNestedImpl(item);
    }

    @Override
    public KafkaListenerAuthenticationOAuthFluent.ClientSecretNested<A> editClientSecret() {
        return this.withNewClientSecretLike(this.getClientSecret());
    }

    @Override
    public KafkaListenerAuthenticationOAuthFluent.ClientSecretNested<A> editOrNewClientSecret() {
        return this.withNewClientSecretLike(this.getClientSecret() != null ? this.getClientSecret() : new GenericSecretSourceBuilder().build());
    }

    @Override
    public KafkaListenerAuthenticationOAuthFluent.ClientSecretNested<A> editOrNewClientSecretLike(GenericSecretSource item) {
        return this.withNewClientSecretLike(this.getClientSecret() != null ? this.getClientSecret() : item);
    }

    @Override
    public String getValidIssuerUri() {
        return this.validIssuerUri;
    }

    @Override
    public A withValidIssuerUri(String validIssuerUri) {
        this.validIssuerUri = validIssuerUri;
        return (A)this;
    }

    @Override
    public Boolean hasValidIssuerUri() {
        return this.validIssuerUri != null;
    }

    @Override
    public A withNewValidIssuerUri(String arg1) {
        return this.withValidIssuerUri(new String(arg1));
    }

    @Override
    public A withNewValidIssuerUri(StringBuilder arg1) {
        return this.withValidIssuerUri(new String(arg1));
    }

    @Override
    public A withNewValidIssuerUri(StringBuffer arg1) {
        return this.withValidIssuerUri(new String(arg1));
    }

    @Override
    public String getJwksEndpointUri() {
        return this.jwksEndpointUri;
    }

    @Override
    public A withJwksEndpointUri(String jwksEndpointUri) {
        this.jwksEndpointUri = jwksEndpointUri;
        return (A)this;
    }

    @Override
    public Boolean hasJwksEndpointUri() {
        return this.jwksEndpointUri != null;
    }

    @Override
    public A withNewJwksEndpointUri(String arg1) {
        return this.withJwksEndpointUri(new String(arg1));
    }

    @Override
    public A withNewJwksEndpointUri(StringBuilder arg1) {
        return this.withJwksEndpointUri(new String(arg1));
    }

    @Override
    public A withNewJwksEndpointUri(StringBuffer arg1) {
        return this.withJwksEndpointUri(new String(arg1));
    }

    @Override
    public int getJwksRefreshSeconds() {
        return this.jwksRefreshSeconds;
    }

    @Override
    public A withJwksRefreshSeconds(int jwksRefreshSeconds) {
        this.jwksRefreshSeconds = jwksRefreshSeconds;
        return (A)this;
    }

    @Override
    public Boolean hasJwksRefreshSeconds() {
        return true;
    }

    @Override
    public int getJwksExpirySeconds() {
        return this.jwksExpirySeconds;
    }

    @Override
    public A withJwksExpirySeconds(int jwksExpirySeconds) {
        this.jwksExpirySeconds = jwksExpirySeconds;
        return (A)this;
    }

    @Override
    public Boolean hasJwksExpirySeconds() {
        return true;
    }

    @Override
    public String getIntrospectionEndpointUri() {
        return this.introspectionEndpointUri;
    }

    @Override
    public A withIntrospectionEndpointUri(String introspectionEndpointUri) {
        this.introspectionEndpointUri = introspectionEndpointUri;
        return (A)this;
    }

    @Override
    public Boolean hasIntrospectionEndpointUri() {
        return this.introspectionEndpointUri != null;
    }

    @Override
    public A withNewIntrospectionEndpointUri(String arg1) {
        return this.withIntrospectionEndpointUri(new String(arg1));
    }

    @Override
    public A withNewIntrospectionEndpointUri(StringBuilder arg1) {
        return this.withIntrospectionEndpointUri(new String(arg1));
    }

    @Override
    public A withNewIntrospectionEndpointUri(StringBuffer arg1) {
        return this.withIntrospectionEndpointUri(new String(arg1));
    }

    @Override
    public String getUserNameClaim() {
        return this.userNameClaim;
    }

    @Override
    public A withUserNameClaim(String userNameClaim) {
        this.userNameClaim = userNameClaim;
        return (A)this;
    }

    @Override
    public Boolean hasUserNameClaim() {
        return this.userNameClaim != null;
    }

    @Override
    public A withNewUserNameClaim(String arg1) {
        return this.withUserNameClaim(new String(arg1));
    }

    @Override
    public A withNewUserNameClaim(StringBuilder arg1) {
        return this.withUserNameClaim(new String(arg1));
    }

    @Override
    public A withNewUserNameClaim(StringBuffer arg1) {
        return this.withUserNameClaim(new String(arg1));
    }

    @Override
    public boolean isCheckAccessTokenType() {
        return this.checkAccessTokenType;
    }

    @Override
    public A withCheckAccessTokenType(boolean checkAccessTokenType) {
        this.checkAccessTokenType = checkAccessTokenType;
        return (A)this;
    }

    @Override
    public Boolean hasCheckAccessTokenType() {
        return true;
    }

    @Override
    public boolean isAccessTokenIsJwt() {
        return this.accessTokenIsJwt;
    }

    @Override
    public A withAccessTokenIsJwt(boolean accessTokenIsJwt) {
        this.accessTokenIsJwt = accessTokenIsJwt;
        return (A)this;
    }

    @Override
    public Boolean hasAccessTokenIsJwt() {
        return true;
    }

    @Override
    public A addToTlsTrustedCertificates(int index, CertSecretSource item) {
        if (this.tlsTrustedCertificates == null) {
            this.tlsTrustedCertificates = new ArrayList<CertSecretSourceBuilder>();
        }
        CertSecretSourceBuilder builder = new CertSecretSourceBuilder(item);
        this._visitables.get((Object)"tlsTrustedCertificates").add(index >= 0 ? index : this._visitables.get((Object)"tlsTrustedCertificates").size(), builder);
        this.tlsTrustedCertificates.add(index >= 0 ? index : this.tlsTrustedCertificates.size(), builder);
        return (A)this;
    }

    @Override
    public A setToTlsTrustedCertificates(int index, CertSecretSource item) {
        if (this.tlsTrustedCertificates == null) {
            this.tlsTrustedCertificates = new ArrayList<CertSecretSourceBuilder>();
        }
        CertSecretSourceBuilder builder = new CertSecretSourceBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"tlsTrustedCertificates").size()) {
            this._visitables.get((Object)"tlsTrustedCertificates").add(builder);
        } else {
            this._visitables.get((Object)"tlsTrustedCertificates").set(index, builder);
        }
        if (index < 0 || index >= this.tlsTrustedCertificates.size()) {
            this.tlsTrustedCertificates.add(builder);
        } else {
            this.tlsTrustedCertificates.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToTlsTrustedCertificates(CertSecretSource ... items) {
        if (this.tlsTrustedCertificates == null) {
            this.tlsTrustedCertificates = new ArrayList<CertSecretSourceBuilder>();
        }
        for (CertSecretSource item : items) {
            CertSecretSourceBuilder builder = new CertSecretSourceBuilder(item);
            this._visitables.get((Object)"tlsTrustedCertificates").add(builder);
            this.tlsTrustedCertificates.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToTlsTrustedCertificates(Collection<CertSecretSource> items) {
        if (this.tlsTrustedCertificates == null) {
            this.tlsTrustedCertificates = new ArrayList<CertSecretSourceBuilder>();
        }
        for (CertSecretSource item : items) {
            CertSecretSourceBuilder builder = new CertSecretSourceBuilder(item);
            this._visitables.get((Object)"tlsTrustedCertificates").add(builder);
            this.tlsTrustedCertificates.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromTlsTrustedCertificates(CertSecretSource ... items) {
        for (CertSecretSource item : items) {
            CertSecretSourceBuilder builder = new CertSecretSourceBuilder(item);
            this._visitables.get((Object)"tlsTrustedCertificates").remove(builder);
            if (this.tlsTrustedCertificates == null) continue;
            this.tlsTrustedCertificates.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromTlsTrustedCertificates(Collection<CertSecretSource> items) {
        for (CertSecretSource item : items) {
            CertSecretSourceBuilder builder = new CertSecretSourceBuilder(item);
            this._visitables.get((Object)"tlsTrustedCertificates").remove(builder);
            if (this.tlsTrustedCertificates == null) continue;
            this.tlsTrustedCertificates.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromTlsTrustedCertificates(Predicate<CertSecretSourceBuilder> predicate) {
        if (this.tlsTrustedCertificates == null) {
            return (A)this;
        }
        Iterator<CertSecretSourceBuilder> each = this.tlsTrustedCertificates.iterator();
        List visitables = this._visitables.get((Object)"tlsTrustedCertificates");
        while (each.hasNext()) {
            CertSecretSourceBuilder builder = each.next();
            if (!predicate.apply((Object)builder).booleanValue()) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<CertSecretSource> getTlsTrustedCertificates() {
        return KafkaListenerAuthenticationOAuthFluentImpl.build(this.tlsTrustedCertificates);
    }

    @Override
    public List<CertSecretSource> buildTlsTrustedCertificates() {
        return KafkaListenerAuthenticationOAuthFluentImpl.build(this.tlsTrustedCertificates);
    }

    @Override
    public CertSecretSource buildTlsTrustedCertificate(int index) {
        return this.tlsTrustedCertificates.get(index).build();
    }

    @Override
    public CertSecretSource buildFirstTlsTrustedCertificate() {
        return this.tlsTrustedCertificates.get(0).build();
    }

    @Override
    public CertSecretSource buildLastTlsTrustedCertificate() {
        return this.tlsTrustedCertificates.get(this.tlsTrustedCertificates.size() - 1).build();
    }

    @Override
    public CertSecretSource buildMatchingTlsTrustedCertificate(Predicate<CertSecretSourceBuilder> predicate) {
        for (CertSecretSourceBuilder item : this.tlsTrustedCertificates) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingTlsTrustedCertificate(Predicate<CertSecretSourceBuilder> predicate) {
        for (CertSecretSourceBuilder item : this.tlsTrustedCertificates) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withTlsTrustedCertificates(List<CertSecretSource> tlsTrustedCertificates) {
        if (this.tlsTrustedCertificates != null) {
            this._visitables.get((Object)"tlsTrustedCertificates").removeAll(this.tlsTrustedCertificates);
        }
        if (tlsTrustedCertificates != null) {
            this.tlsTrustedCertificates = new ArrayList<CertSecretSourceBuilder>();
            for (CertSecretSource item : tlsTrustedCertificates) {
                this.addToTlsTrustedCertificates(item);
            }
        } else {
            this.tlsTrustedCertificates = null;
        }
        return (A)this;
    }

    @Override
    public A withTlsTrustedCertificates(CertSecretSource ... tlsTrustedCertificates) {
        if (this.tlsTrustedCertificates != null) {
            this.tlsTrustedCertificates.clear();
        }
        if (tlsTrustedCertificates != null) {
            for (CertSecretSource item : tlsTrustedCertificates) {
                this.addToTlsTrustedCertificates(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasTlsTrustedCertificates() {
        return this.tlsTrustedCertificates != null && !this.tlsTrustedCertificates.isEmpty();
    }

    @Override
    public KafkaListenerAuthenticationOAuthFluent.TlsTrustedCertificatesNested<A> addNewTlsTrustedCertificate() {
        return new TlsTrustedCertificatesNestedImpl();
    }

    @Override
    public KafkaListenerAuthenticationOAuthFluent.TlsTrustedCertificatesNested<A> addNewTlsTrustedCertificateLike(CertSecretSource item) {
        return new TlsTrustedCertificatesNestedImpl(-1, item);
    }

    @Override
    public KafkaListenerAuthenticationOAuthFluent.TlsTrustedCertificatesNested<A> setNewTlsTrustedCertificateLike(int index, CertSecretSource item) {
        return new TlsTrustedCertificatesNestedImpl(index, item);
    }

    @Override
    public KafkaListenerAuthenticationOAuthFluent.TlsTrustedCertificatesNested<A> editTlsTrustedCertificate(int index) {
        if (this.tlsTrustedCertificates.size() <= index) {
            throw new RuntimeException("Can't edit tlsTrustedCertificates. Index exceeds size.");
        }
        return this.setNewTlsTrustedCertificateLike(index, this.buildTlsTrustedCertificate(index));
    }

    @Override
    public KafkaListenerAuthenticationOAuthFluent.TlsTrustedCertificatesNested<A> editFirstTlsTrustedCertificate() {
        if (this.tlsTrustedCertificates.size() == 0) {
            throw new RuntimeException("Can't edit first tlsTrustedCertificates. The list is empty.");
        }
        return this.setNewTlsTrustedCertificateLike(0, this.buildTlsTrustedCertificate(0));
    }

    @Override
    public KafkaListenerAuthenticationOAuthFluent.TlsTrustedCertificatesNested<A> editLastTlsTrustedCertificate() {
        int index = this.tlsTrustedCertificates.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last tlsTrustedCertificates. The list is empty.");
        }
        return this.setNewTlsTrustedCertificateLike(index, this.buildTlsTrustedCertificate(index));
    }

    @Override
    public KafkaListenerAuthenticationOAuthFluent.TlsTrustedCertificatesNested<A> editMatchingTlsTrustedCertificate(Predicate<CertSecretSourceBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.tlsTrustedCertificates.size(); ++i) {
            if (!predicate.apply((Object)this.tlsTrustedCertificates.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching tlsTrustedCertificates. No match found.");
        }
        return this.setNewTlsTrustedCertificateLike(index, this.buildTlsTrustedCertificate(index));
    }

    @Override
    public boolean isDisableTlsHostnameVerification() {
        return this.disableTlsHostnameVerification;
    }

    @Override
    public A withDisableTlsHostnameVerification(boolean disableTlsHostnameVerification) {
        this.disableTlsHostnameVerification = disableTlsHostnameVerification;
        return (A)this;
    }

    @Override
    public Boolean hasDisableTlsHostnameVerification() {
        return true;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KafkaListenerAuthenticationOAuthFluentImpl that = (KafkaListenerAuthenticationOAuthFluentImpl)o;
        if (this.clientId != null ? !this.clientId.equals(that.clientId) : that.clientId != null) {
            return false;
        }
        if (this.clientSecret != null ? !this.clientSecret.equals(that.clientSecret) : that.clientSecret != null) {
            return false;
        }
        if (this.validIssuerUri != null ? !this.validIssuerUri.equals(that.validIssuerUri) : that.validIssuerUri != null) {
            return false;
        }
        if (this.jwksEndpointUri != null ? !this.jwksEndpointUri.equals(that.jwksEndpointUri) : that.jwksEndpointUri != null) {
            return false;
        }
        if (this.jwksRefreshSeconds != that.jwksRefreshSeconds) {
            return false;
        }
        if (this.jwksExpirySeconds != that.jwksExpirySeconds) {
            return false;
        }
        if (this.introspectionEndpointUri != null ? !this.introspectionEndpointUri.equals(that.introspectionEndpointUri) : that.introspectionEndpointUri != null) {
            return false;
        }
        if (this.userNameClaim != null ? !this.userNameClaim.equals(that.userNameClaim) : that.userNameClaim != null) {
            return false;
        }
        if (this.checkAccessTokenType != that.checkAccessTokenType) {
            return false;
        }
        if (this.accessTokenIsJwt != that.accessTokenIsJwt) {
            return false;
        }
        if (this.tlsTrustedCertificates != null ? !this.tlsTrustedCertificates.equals(that.tlsTrustedCertificates) : that.tlsTrustedCertificates != null) {
            return false;
        }
        return this.disableTlsHostnameVerification == that.disableTlsHostnameVerification;
    }

    public class TlsTrustedCertificatesNestedImpl<N>
    extends CertSecretSourceFluentImpl<KafkaListenerAuthenticationOAuthFluent.TlsTrustedCertificatesNested<N>>
    implements KafkaListenerAuthenticationOAuthFluent.TlsTrustedCertificatesNested<N>,
    Nested<N> {
        private final CertSecretSourceBuilder builder;
        private final int index;

        TlsTrustedCertificatesNestedImpl(int index, CertSecretSource item) {
            this.index = index;
            this.builder = new CertSecretSourceBuilder(this, item);
        }

        TlsTrustedCertificatesNestedImpl() {
            this.index = -1;
            this.builder = new CertSecretSourceBuilder(this);
        }

        @Override
        public N and() {
            return (N)KafkaListenerAuthenticationOAuthFluentImpl.this.setToTlsTrustedCertificates(this.index, this.builder.build());
        }

        @Override
        public N endTlsTrustedCertificate() {
            return this.and();
        }
    }

    public class ClientSecretNestedImpl<N>
    extends GenericSecretSourceFluentImpl<KafkaListenerAuthenticationOAuthFluent.ClientSecretNested<N>>
    implements KafkaListenerAuthenticationOAuthFluent.ClientSecretNested<N>,
    Nested<N> {
        private final GenericSecretSourceBuilder builder;

        ClientSecretNestedImpl(GenericSecretSource item) {
            this.builder = new GenericSecretSourceBuilder(this, item);
        }

        ClientSecretNestedImpl() {
            this.builder = new GenericSecretSourceBuilder(this);
        }

        @Override
        public N and() {
            return (N)KafkaListenerAuthenticationOAuthFluentImpl.this.withClientSecret(this.builder.build());
        }

        @Override
        public N endClientSecret() {
            return this.and();
        }
    }
}

