/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.listener;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.strimzi.api.kafka.model.CertSecretSource;
import io.strimzi.api.kafka.model.GenericSecretSource;
import io.strimzi.api.kafka.model.listener.KafkaListenerAuthentication;
import io.strimzi.crdgenerator.annotations.Description;
import io.strimzi.crdgenerator.annotations.Minimum;
import io.vertx.core.cli.annotations.DefaultValue;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class KafkaListenerAuthenticationOAuth
extends KafkaListenerAuthentication {
    private static final long serialVersionUID = 1L;
    public static final String TYPE_OAUTH = "oauth";
    public static final int DEFAULT_JWKS_EXPIRY_SECONDS = 360;
    public static final int DEFAULT_JWKS_REFRESH_SECONDS = 300;
    private String clientId;
    private GenericSecretSource clientSecret;
    private String validIssuerUri;
    private String jwksEndpointUri;
    private int jwksRefreshSeconds;
    private int jwksExpirySeconds;
    private String introspectionEndpointUri;
    private String userNameClaim;
    private boolean checkAccessTokenType = true;
    private boolean accessTokenIsJwt = true;
    private List<CertSecretSource> tlsTrustedCertificates;
    private boolean disableTlsHostnameVerification = false;

    @Override
    @Description(value="Must be `oauth`")
    public String getType() {
        return TYPE_OAUTH;
    }

    @Description(value="OAuth Client ID which the Kafka broker can use to authenticate against the authorization server and use the introspect endpoint URI.")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    @Description(value="Link to Kubernetes Secret containing the OAuth client secret which the Kafka broker can use to authenticate against the authorization server and use the introspect endpoint URI.")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public GenericSecretSource getClientSecret() {
        return this.clientSecret;
    }

    public void setClientSecret(GenericSecretSource clientSecret) {
        this.clientSecret = clientSecret;
    }

    @Description(value="URI of the token issuer used for authentication.")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getValidIssuerUri() {
        return this.validIssuerUri;
    }

    public void setValidIssuerUri(String validIssuerUri) {
        this.validIssuerUri = validIssuerUri;
    }

    @Description(value="URI of the JWKS certificate endpoint, which can be used for local JWT validation.")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getJwksEndpointUri() {
        return this.jwksEndpointUri;
    }

    public void setJwksEndpointUri(String jwksEndpointUri) {
        this.jwksEndpointUri = jwksEndpointUri;
    }

    @Description(value="Configures how often are the JWKS certificates refreshed. The refresh interval has to be at least 60 seconds shorter then the expiry interval specified in `jwksExpirySeconds`. Defaults to 300 seconds.")
    @Minimum(value=1)
    @DefaultValue(value="300")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public int getJwksRefreshSeconds() {
        return this.jwksRefreshSeconds;
    }

    public void setJwksRefreshSeconds(int jwksRefreshSeconds) {
        this.jwksRefreshSeconds = jwksRefreshSeconds;
    }

    @Description(value="Configures how often are the JWKS certificates considered valid. The expiry interval has to be at least 60 seconds longer then the refresh interval specified in `jwksRefreshSeconds`. Defaults to 360 seconds.")
    @Minimum(value=1)
    @DefaultValue(value="360")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public int getJwksExpirySeconds() {
        return this.jwksExpirySeconds;
    }

    public void setJwksExpirySeconds(int jwksExpirySeconds) {
        this.jwksExpirySeconds = jwksExpirySeconds;
    }

    @Description(value="URI of the token introspection endpoint which can be used to validate opaque non-JWT tokens.")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getIntrospectionEndpointUri() {
        return this.introspectionEndpointUri;
    }

    public void setIntrospectionEndpointUri(String introspectionEndpointUri) {
        this.introspectionEndpointUri = introspectionEndpointUri;
    }

    @Description(value="Name of the claim from the authentication token which will be used as the user principal. Defaults to `sub`.")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getUserNameClaim() {
        return this.userNameClaim;
    }

    public void setUserNameClaim(String userNameClaim) {
        this.userNameClaim = userNameClaim;
    }

    @Description(value="Configure whether the access token type check should be performed or not. This should be set to `false` if the authorization server does not include 'typ' claim in JWT token. Defaults to `true`.")
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public boolean isCheckAccessTokenType() {
        return this.checkAccessTokenType;
    }

    public void setCheckAccessTokenType(boolean checkAccessTokenType) {
        this.checkAccessTokenType = checkAccessTokenType;
    }

    @Description(value="Configure whether the access token should be treated as JWT. This should be set to `false` if the authorization server returns opaque tokens. Defaults to `true`.")
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public boolean isAccessTokenIsJwt() {
        return this.accessTokenIsJwt;
    }

    public void setAccessTokenIsJwt(boolean accessTokenIsJwt) {
        this.accessTokenIsJwt = accessTokenIsJwt;
    }

    @Description(value="Trusted certificates for TLS connection to the OAuth server.")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<CertSecretSource> getTlsTrustedCertificates() {
        return this.tlsTrustedCertificates;
    }

    public void setTlsTrustedCertificates(List<CertSecretSource> tlsTrustedCertificates) {
        this.tlsTrustedCertificates = tlsTrustedCertificates;
    }

    @Description(value="Enable or disable TLS hostname verification. Default value is `false`.")
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public boolean isDisableTlsHostnameVerification() {
        return this.disableTlsHostnameVerification;
    }

    public void setDisableTlsHostnameVerification(boolean disableTlsHostnameVerification) {
        this.disableTlsHostnameVerification = disableTlsHostnameVerification;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KafkaListenerAuthenticationOAuth)) {
            return false;
        }
        KafkaListenerAuthenticationOAuth other = (KafkaListenerAuthenticationOAuth)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$clientId = this.getClientId();
        String other$clientId = other.getClientId();
        if (this$clientId == null ? other$clientId != null : !this$clientId.equals(other$clientId)) {
            return false;
        }
        GenericSecretSource this$clientSecret = this.getClientSecret();
        GenericSecretSource other$clientSecret = other.getClientSecret();
        if (this$clientSecret == null ? other$clientSecret != null : !((Object)this$clientSecret).equals(other$clientSecret)) {
            return false;
        }
        String this$validIssuerUri = this.getValidIssuerUri();
        String other$validIssuerUri = other.getValidIssuerUri();
        if (this$validIssuerUri == null ? other$validIssuerUri != null : !this$validIssuerUri.equals(other$validIssuerUri)) {
            return false;
        }
        String this$jwksEndpointUri = this.getJwksEndpointUri();
        String other$jwksEndpointUri = other.getJwksEndpointUri();
        if (this$jwksEndpointUri == null ? other$jwksEndpointUri != null : !this$jwksEndpointUri.equals(other$jwksEndpointUri)) {
            return false;
        }
        if (this.getJwksRefreshSeconds() != other.getJwksRefreshSeconds()) {
            return false;
        }
        if (this.getJwksExpirySeconds() != other.getJwksExpirySeconds()) {
            return false;
        }
        String this$introspectionEndpointUri = this.getIntrospectionEndpointUri();
        String other$introspectionEndpointUri = other.getIntrospectionEndpointUri();
        if (this$introspectionEndpointUri == null ? other$introspectionEndpointUri != null : !this$introspectionEndpointUri.equals(other$introspectionEndpointUri)) {
            return false;
        }
        String this$userNameClaim = this.getUserNameClaim();
        String other$userNameClaim = other.getUserNameClaim();
        if (this$userNameClaim == null ? other$userNameClaim != null : !this$userNameClaim.equals(other$userNameClaim)) {
            return false;
        }
        if (this.isCheckAccessTokenType() != other.isCheckAccessTokenType()) {
            return false;
        }
        if (this.isAccessTokenIsJwt() != other.isAccessTokenIsJwt()) {
            return false;
        }
        List<CertSecretSource> this$tlsTrustedCertificates = this.getTlsTrustedCertificates();
        List<CertSecretSource> other$tlsTrustedCertificates = other.getTlsTrustedCertificates();
        if (this$tlsTrustedCertificates == null ? other$tlsTrustedCertificates != null : !((Object)this$tlsTrustedCertificates).equals(other$tlsTrustedCertificates)) {
            return false;
        }
        return this.isDisableTlsHostnameVerification() == other.isDisableTlsHostnameVerification();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof KafkaListenerAuthenticationOAuth;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $clientId = this.getClientId();
        result = result * 59 + ($clientId == null ? 43 : $clientId.hashCode());
        GenericSecretSource $clientSecret = this.getClientSecret();
        result = result * 59 + ($clientSecret == null ? 43 : ((Object)$clientSecret).hashCode());
        String $validIssuerUri = this.getValidIssuerUri();
        result = result * 59 + ($validIssuerUri == null ? 43 : $validIssuerUri.hashCode());
        String $jwksEndpointUri = this.getJwksEndpointUri();
        result = result * 59 + ($jwksEndpointUri == null ? 43 : $jwksEndpointUri.hashCode());
        result = result * 59 + this.getJwksRefreshSeconds();
        result = result * 59 + this.getJwksExpirySeconds();
        String $introspectionEndpointUri = this.getIntrospectionEndpointUri();
        result = result * 59 + ($introspectionEndpointUri == null ? 43 : $introspectionEndpointUri.hashCode());
        String $userNameClaim = this.getUserNameClaim();
        result = result * 59 + ($userNameClaim == null ? 43 : $userNameClaim.hashCode());
        result = result * 59 + (this.isCheckAccessTokenType() ? 79 : 97);
        result = result * 59 + (this.isAccessTokenIsJwt() ? 79 : 97);
        List<CertSecretSource> $tlsTrustedCertificates = this.getTlsTrustedCertificates();
        result = result * 59 + ($tlsTrustedCertificates == null ? 43 : ((Object)$tlsTrustedCertificates).hashCode());
        result = result * 59 + (this.isDisableTlsHostnameVerification() ? 79 : 97);
        return result;
    }
}

