/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.listener;

import io.strimzi.api.kafka.model.listener.ExternalListenerBootstrapOverrideFluentImpl;
import io.strimzi.api.kafka.model.listener.IngressListenerBootstrapConfiguration;
import io.strimzi.api.kafka.model.listener.IngressListenerBootstrapConfigurationFluent;
import java.util.LinkedHashMap;
import java.util.Map;

public class IngressListenerBootstrapConfigurationFluentImpl<A extends IngressListenerBootstrapConfigurationFluent<A>>
extends ExternalListenerBootstrapOverrideFluentImpl<A>
implements IngressListenerBootstrapConfigurationFluent<A> {
    private String host;
    private Map<String, String> dnsAnnotations;

    public IngressListenerBootstrapConfigurationFluentImpl() {
    }

    public IngressListenerBootstrapConfigurationFluentImpl(IngressListenerBootstrapConfiguration instance) {
        this.withHost(instance.getHost());
        this.withDnsAnnotations(instance.getDnsAnnotations());
        this.withAddress(instance.getAddress());
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public A withHost(String host) {
        this.host = host;
        return (A)this;
    }

    @Override
    public Boolean hasHost() {
        return this.host != null;
    }

    @Override
    public A withNewHost(String arg1) {
        return this.withHost(new String(arg1));
    }

    @Override
    public A withNewHost(StringBuilder arg1) {
        return this.withHost(new String(arg1));
    }

    @Override
    public A withNewHost(StringBuffer arg1) {
        return this.withHost(new String(arg1));
    }

    @Override
    public A addToDnsAnnotations(String key, String value) {
        if (this.dnsAnnotations == null && key != null && value != null) {
            this.dnsAnnotations = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.dnsAnnotations.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToDnsAnnotations(Map<String, String> map) {
        if (this.dnsAnnotations == null && map != null) {
            this.dnsAnnotations = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.dnsAnnotations.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromDnsAnnotations(String key) {
        if (this.dnsAnnotations == null) {
            return (A)this;
        }
        if (key != null && this.dnsAnnotations != null) {
            this.dnsAnnotations.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromDnsAnnotations(Map<String, String> map) {
        if (this.dnsAnnotations == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.dnsAnnotations == null) continue;
                this.dnsAnnotations.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, String> getDnsAnnotations() {
        return this.dnsAnnotations;
    }

    @Override
    public A withDnsAnnotations(Map<String, String> dnsAnnotations) {
        this.dnsAnnotations = dnsAnnotations == null ? null : new LinkedHashMap<String, String>(dnsAnnotations);
        return (A)this;
    }

    @Override
    public Boolean hasDnsAnnotations() {
        return this.dnsAnnotations != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IngressListenerBootstrapConfigurationFluentImpl that = (IngressListenerBootstrapConfigurationFluentImpl)o;
        if (this.host != null ? !this.host.equals(that.host) : that.host != null) {
            return false;
        }
        return !(this.dnsAnnotations != null ? !this.dnsAnnotations.equals(that.dnsAnnotations) : that.dnsAnnotations != null);
    }
}

