/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model;

public class KafkaResources {
    private KafkaResources() {
    }

    public static String zookeeperStatefulSetName(String clusterName) {
        return clusterName + "-zookeeper";
    }

    public static String zookeeperPodName(String clusterName, int podNum) {
        return KafkaResources.zookeeperStatefulSetName(clusterName) + "-" + podNum;
    }

    public static String kafkaStatefulSetName(String clusterName) {
        return clusterName + "-kafka";
    }

    public static String kafkaPodName(String clusterName, int podNum) {
        return KafkaResources.kafkaStatefulSetName(clusterName) + "-" + podNum;
    }

    public static String entityOperatorDeploymentName(String clusterName) {
        return clusterName + "-entity-operator";
    }

    public static String entityOperatorSecretName(String clusterName) {
        return KafkaResources.entityOperatorDeploymentName(clusterName) + "-certs";
    }

    public static String clusterCaCertificateSecretName(String clusterName) {
        return clusterName + "-cluster-ca-cert";
    }

    public static String clusterCaKeySecretName(String clusterName) {
        return clusterName + "-cluster-ca";
    }

    public static String clientsCaCertificateSecretName(String clusterName) {
        return clusterName + "-clients-ca-cert";
    }

    public static String clientsCaKeySecretName(String clusterName) {
        return clusterName + "-clients-ca";
    }

    public static String bootstrapServiceName(String clusterName) {
        return clusterName + "-kafka-bootstrap";
    }

    public static String plainBootstrapAddress(String clusterName) {
        return KafkaResources.bootstrapServiceName(clusterName) + ":9092";
    }

    public static String tlsBootstrapAddress(String clusterName) {
        return KafkaResources.bootstrapServiceName(clusterName) + ":9093";
    }

    public static String brokersServiceName(String clusterName) {
        return clusterName + "-kafka-brokers";
    }

    public static String externalBootstrapServiceName(String clusterName) {
        return clusterName + "-kafka-external-bootstrap";
    }

    public static String brokerSpecificService(String clusterName, int podNum) {
        return clusterName + "-kafka-" + podNum;
    }

    public static String kafkaMetricsAndLogConfigMapName(String clusterName) {
        return clusterName + "-kafka-config";
    }

    public static String zookeeperMetricsAndLogConfigMapName(String clusterName) {
        return clusterName + "-zookeeper-config";
    }

    public static String zookeeperServiceName(String clusterName) {
        return clusterName + "-zookeeper-client";
    }

    public static String zookeeperHeadlessServiceName(String clusterName) {
        return clusterName + "-zookeeper-nodes";
    }
}

