/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.strimzi.api.kafka.model.KafkaMirrorMakerClientSpec;
import io.strimzi.crdgenerator.annotations.Description;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"bootstrapServers", "abortOnSendFailure", "logging"})
public class KafkaMirrorMakerProducerSpec
extends KafkaMirrorMakerClientSpec {
    private static final long serialVersionUID = 1L;
    private Boolean abortOnSendFailure;
    public static final String FORBIDDEN_PREFIXES = "ssl., bootstrap.servers, sasl., security., interceptor.classes";
    public static final String FORBIDDEN_PREFIX_EXCEPTIONS = "ssl.endpoint.identification.algorithm";

    @Description(value="Flag to set the Mirror Maker to exit on a failed send. Default value is `true`.")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Boolean getAbortOnSendFailure() {
        return this.abortOnSendFailure;
    }

    public void setAbortOnSendFailure(Boolean abortOnSendFailure) {
        this.abortOnSendFailure = abortOnSendFailure;
    }

    @Override
    @Description(value="The Mirror Maker producer config. Properties with the following prefixes cannot be set: ssl., bootstrap.servers, sasl., security., interceptor.classes")
    public Map<String, Object> getConfig() {
        return this.config;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KafkaMirrorMakerProducerSpec)) {
            return false;
        }
        KafkaMirrorMakerProducerSpec other = (KafkaMirrorMakerProducerSpec)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$abortOnSendFailure = this.getAbortOnSendFailure();
        Boolean other$abortOnSendFailure = other.getAbortOnSendFailure();
        return !(this$abortOnSendFailure == null ? other$abortOnSendFailure != null : !((Object)this$abortOnSendFailure).equals(other$abortOnSendFailure));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof KafkaMirrorMakerProducerSpec;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $abortOnSendFailure = this.getAbortOnSendFailure();
        result = result * 59 + ($abortOnSendFailure == null ? 43 : ((Object)$abortOnSendFailure).hashCode());
        return result;
    }
}

