/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.strimzi.api.kafka.model.KafkaExporterSpec;
import io.strimzi.api.kafka.model.KafkaExporterSpecFluent;
import io.strimzi.api.kafka.model.Probe;
import io.strimzi.api.kafka.model.ProbeBuilder;
import io.strimzi.api.kafka.model.ProbeFluentImpl;
import io.strimzi.api.kafka.model.template.KafkaExporterTemplate;
import io.strimzi.api.kafka.model.template.KafkaExporterTemplateBuilder;
import io.strimzi.api.kafka.model.template.KafkaExporterTemplateFluentImpl;

public class KafkaExporterSpecFluentImpl<A extends KafkaExporterSpecFluent<A>>
extends BaseFluent<A>
implements KafkaExporterSpecFluent<A> {
    private String image;
    private String groupRegex;
    private String topicRegex;
    private ResourceRequirements resources;
    private ProbeBuilder livenessProbe;
    private ProbeBuilder readinessProbe;
    private String logging;
    private boolean enableSaramaLogging;
    private KafkaExporterTemplateBuilder template;

    public KafkaExporterSpecFluentImpl() {
    }

    public KafkaExporterSpecFluentImpl(KafkaExporterSpec instance) {
        this.withImage(instance.getImage());
        this.withGroupRegex(instance.getGroupRegex());
        this.withTopicRegex(instance.getTopicRegex());
        this.withResources(instance.getResources());
        this.withLivenessProbe(instance.getLivenessProbe());
        this.withReadinessProbe(instance.getReadinessProbe());
        this.withLogging(instance.getLogging());
        this.withEnableSaramaLogging(instance.getEnableSaramaLogging());
        this.withTemplate(instance.getTemplate());
    }

    @Override
    public String getImage() {
        return this.image;
    }

    @Override
    public A withImage(String image) {
        this.image = image;
        return (A)this;
    }

    @Override
    public Boolean hasImage() {
        return this.image != null;
    }

    @Override
    public A withNewImage(String arg1) {
        return this.withImage(new String(arg1));
    }

    @Override
    public A withNewImage(StringBuilder arg1) {
        return this.withImage(new String(arg1));
    }

    @Override
    public A withNewImage(StringBuffer arg1) {
        return this.withImage(new String(arg1));
    }

    @Override
    public String getGroupRegex() {
        return this.groupRegex;
    }

    @Override
    public A withGroupRegex(String groupRegex) {
        this.groupRegex = groupRegex;
        return (A)this;
    }

    @Override
    public Boolean hasGroupRegex() {
        return this.groupRegex != null;
    }

    @Override
    public A withNewGroupRegex(String arg1) {
        return this.withGroupRegex(new String(arg1));
    }

    @Override
    public A withNewGroupRegex(StringBuilder arg1) {
        return this.withGroupRegex(new String(arg1));
    }

    @Override
    public A withNewGroupRegex(StringBuffer arg1) {
        return this.withGroupRegex(new String(arg1));
    }

    @Override
    public String getTopicRegex() {
        return this.topicRegex;
    }

    @Override
    public A withTopicRegex(String topicRegex) {
        this.topicRegex = topicRegex;
        return (A)this;
    }

    @Override
    public Boolean hasTopicRegex() {
        return this.topicRegex != null;
    }

    @Override
    public A withNewTopicRegex(String arg1) {
        return this.withTopicRegex(new String(arg1));
    }

    @Override
    public A withNewTopicRegex(StringBuilder arg1) {
        return this.withTopicRegex(new String(arg1));
    }

    @Override
    public A withNewTopicRegex(StringBuffer arg1) {
        return this.withTopicRegex(new String(arg1));
    }

    @Override
    public ResourceRequirements getResources() {
        return this.resources;
    }

    @Override
    public A withResources(ResourceRequirements resources) {
        this.resources = resources;
        return (A)this;
    }

    @Override
    public Boolean hasResources() {
        return this.resources != null;
    }

    @Override
    @Deprecated
    public Probe getLivenessProbe() {
        return this.livenessProbe != null ? this.livenessProbe.build() : null;
    }

    @Override
    public Probe buildLivenessProbe() {
        return this.livenessProbe != null ? this.livenessProbe.build() : null;
    }

    @Override
    public A withLivenessProbe(Probe livenessProbe) {
        this._visitables.get((Object)"livenessProbe").remove(this.livenessProbe);
        if (livenessProbe != null) {
            this.livenessProbe = new ProbeBuilder(livenessProbe);
            this._visitables.get((Object)"livenessProbe").add(this.livenessProbe);
        }
        return (A)this;
    }

    @Override
    public Boolean hasLivenessProbe() {
        return this.livenessProbe != null;
    }

    @Override
    public A withNewLivenessProbe(int initialDelaySeconds, int timeoutSeconds) {
        return this.withLivenessProbe(new Probe(initialDelaySeconds, timeoutSeconds));
    }

    @Override
    public KafkaExporterSpecFluent.LivenessProbeNested<A> withNewLivenessProbe() {
        return new LivenessProbeNestedImpl();
    }

    @Override
    public KafkaExporterSpecFluent.LivenessProbeNested<A> withNewLivenessProbeLike(Probe item) {
        return new LivenessProbeNestedImpl(item);
    }

    @Override
    public KafkaExporterSpecFluent.LivenessProbeNested<A> editLivenessProbe() {
        return this.withNewLivenessProbeLike(this.getLivenessProbe());
    }

    @Override
    public KafkaExporterSpecFluent.LivenessProbeNested<A> editOrNewLivenessProbe() {
        return this.withNewLivenessProbeLike(this.getLivenessProbe() != null ? this.getLivenessProbe() : new ProbeBuilder().build());
    }

    @Override
    public KafkaExporterSpecFluent.LivenessProbeNested<A> editOrNewLivenessProbeLike(Probe item) {
        return this.withNewLivenessProbeLike(this.getLivenessProbe() != null ? this.getLivenessProbe() : item);
    }

    @Override
    @Deprecated
    public Probe getReadinessProbe() {
        return this.readinessProbe != null ? this.readinessProbe.build() : null;
    }

    @Override
    public Probe buildReadinessProbe() {
        return this.readinessProbe != null ? this.readinessProbe.build() : null;
    }

    @Override
    public A withReadinessProbe(Probe readinessProbe) {
        this._visitables.get((Object)"readinessProbe").remove(this.readinessProbe);
        if (readinessProbe != null) {
            this.readinessProbe = new ProbeBuilder(readinessProbe);
            this._visitables.get((Object)"readinessProbe").add(this.readinessProbe);
        }
        return (A)this;
    }

    @Override
    public Boolean hasReadinessProbe() {
        return this.readinessProbe != null;
    }

    @Override
    public A withNewReadinessProbe(int initialDelaySeconds, int timeoutSeconds) {
        return this.withReadinessProbe(new Probe(initialDelaySeconds, timeoutSeconds));
    }

    @Override
    public KafkaExporterSpecFluent.ReadinessProbeNested<A> withNewReadinessProbe() {
        return new ReadinessProbeNestedImpl();
    }

    @Override
    public KafkaExporterSpecFluent.ReadinessProbeNested<A> withNewReadinessProbeLike(Probe item) {
        return new ReadinessProbeNestedImpl(item);
    }

    @Override
    public KafkaExporterSpecFluent.ReadinessProbeNested<A> editReadinessProbe() {
        return this.withNewReadinessProbeLike(this.getReadinessProbe());
    }

    @Override
    public KafkaExporterSpecFluent.ReadinessProbeNested<A> editOrNewReadinessProbe() {
        return this.withNewReadinessProbeLike(this.getReadinessProbe() != null ? this.getReadinessProbe() : new ProbeBuilder().build());
    }

    @Override
    public KafkaExporterSpecFluent.ReadinessProbeNested<A> editOrNewReadinessProbeLike(Probe item) {
        return this.withNewReadinessProbeLike(this.getReadinessProbe() != null ? this.getReadinessProbe() : item);
    }

    @Override
    public String getLogging() {
        return this.logging;
    }

    @Override
    public A withLogging(String logging) {
        this.logging = logging;
        return (A)this;
    }

    @Override
    public Boolean hasLogging() {
        return this.logging != null;
    }

    @Override
    public A withNewLogging(String arg1) {
        return this.withLogging(new String(arg1));
    }

    @Override
    public A withNewLogging(StringBuilder arg1) {
        return this.withLogging(new String(arg1));
    }

    @Override
    public A withNewLogging(StringBuffer arg1) {
        return this.withLogging(new String(arg1));
    }

    @Override
    public boolean isEnableSaramaLogging() {
        return this.enableSaramaLogging;
    }

    @Override
    public A withEnableSaramaLogging(boolean enableSaramaLogging) {
        this.enableSaramaLogging = enableSaramaLogging;
        return (A)this;
    }

    @Override
    public Boolean hasEnableSaramaLogging() {
        return true;
    }

    @Override
    @Deprecated
    public KafkaExporterTemplate getTemplate() {
        return this.template != null ? this.template.build() : null;
    }

    @Override
    public KafkaExporterTemplate buildTemplate() {
        return this.template != null ? this.template.build() : null;
    }

    @Override
    public A withTemplate(KafkaExporterTemplate template) {
        this._visitables.get((Object)"template").remove(this.template);
        if (template != null) {
            this.template = new KafkaExporterTemplateBuilder(template);
            this._visitables.get((Object)"template").add(this.template);
        }
        return (A)this;
    }

    @Override
    public Boolean hasTemplate() {
        return this.template != null;
    }

    @Override
    public KafkaExporterSpecFluent.TemplateNested<A> withNewTemplate() {
        return new TemplateNestedImpl();
    }

    @Override
    public KafkaExporterSpecFluent.TemplateNested<A> withNewTemplateLike(KafkaExporterTemplate item) {
        return new TemplateNestedImpl(item);
    }

    @Override
    public KafkaExporterSpecFluent.TemplateNested<A> editTemplate() {
        return this.withNewTemplateLike(this.getTemplate());
    }

    @Override
    public KafkaExporterSpecFluent.TemplateNested<A> editOrNewTemplate() {
        return this.withNewTemplateLike(this.getTemplate() != null ? this.getTemplate() : new KafkaExporterTemplateBuilder().build());
    }

    @Override
    public KafkaExporterSpecFluent.TemplateNested<A> editOrNewTemplateLike(KafkaExporterTemplate item) {
        return this.withNewTemplateLike(this.getTemplate() != null ? this.getTemplate() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KafkaExporterSpecFluentImpl that = (KafkaExporterSpecFluentImpl)o;
        if (this.image != null ? !this.image.equals(that.image) : that.image != null) {
            return false;
        }
        if (this.groupRegex != null ? !this.groupRegex.equals(that.groupRegex) : that.groupRegex != null) {
            return false;
        }
        if (this.topicRegex != null ? !this.topicRegex.equals(that.topicRegex) : that.topicRegex != null) {
            return false;
        }
        if (this.resources != null ? !this.resources.equals((Object)that.resources) : that.resources != null) {
            return false;
        }
        if (this.livenessProbe != null ? !this.livenessProbe.equals(that.livenessProbe) : that.livenessProbe != null) {
            return false;
        }
        if (this.readinessProbe != null ? !this.readinessProbe.equals(that.readinessProbe) : that.readinessProbe != null) {
            return false;
        }
        if (this.logging != null ? !this.logging.equals(that.logging) : that.logging != null) {
            return false;
        }
        if (this.enableSaramaLogging != that.enableSaramaLogging) {
            return false;
        }
        return !(this.template != null ? !this.template.equals(that.template) : that.template != null);
    }

    public class TemplateNestedImpl<N>
    extends KafkaExporterTemplateFluentImpl<KafkaExporterSpecFluent.TemplateNested<N>>
    implements KafkaExporterSpecFluent.TemplateNested<N>,
    Nested<N> {
        private final KafkaExporterTemplateBuilder builder;

        TemplateNestedImpl(KafkaExporterTemplate item) {
            this.builder = new KafkaExporterTemplateBuilder(this, item);
        }

        TemplateNestedImpl() {
            this.builder = new KafkaExporterTemplateBuilder(this);
        }

        @Override
        public N and() {
            return (N)KafkaExporterSpecFluentImpl.this.withTemplate(this.builder.build());
        }

        @Override
        public N endTemplate() {
            return this.and();
        }
    }

    public class ReadinessProbeNestedImpl<N>
    extends ProbeFluentImpl<KafkaExporterSpecFluent.ReadinessProbeNested<N>>
    implements KafkaExporterSpecFluent.ReadinessProbeNested<N>,
    Nested<N> {
        private final ProbeBuilder builder;

        ReadinessProbeNestedImpl(Probe item) {
            this.builder = new ProbeBuilder(this, item);
        }

        ReadinessProbeNestedImpl() {
            this.builder = new ProbeBuilder(this);
        }

        @Override
        public N and() {
            return (N)KafkaExporterSpecFluentImpl.this.withReadinessProbe(this.builder.build());
        }

        @Override
        public N endReadinessProbe() {
            return this.and();
        }
    }

    public class LivenessProbeNestedImpl<N>
    extends ProbeFluentImpl<KafkaExporterSpecFluent.LivenessProbeNested<N>>
    implements KafkaExporterSpecFluent.LivenessProbeNested<N>,
    Nested<N> {
        private final ProbeBuilder builder;

        LivenessProbeNestedImpl(Probe item) {
            this.builder = new ProbeBuilder(this, item);
        }

        LivenessProbeNestedImpl() {
            this.builder = new ProbeBuilder(this);
        }

        @Override
        public N and() {
            return (N)KafkaExporterSpecFluentImpl.this.withLivenessProbe(this.builder.build());
        }

        @Override
        public N endLivenessProbe() {
            return this.and();
        }
    }
}

