/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.strimzi.api.kafka.model.KafkaExporterSpec;
import io.strimzi.api.kafka.model.KafkaExporterSpecFluent;
import io.strimzi.api.kafka.model.KafkaExporterSpecFluentImpl;

public class KafkaExporterSpecBuilder
extends KafkaExporterSpecFluentImpl<KafkaExporterSpecBuilder>
implements VisitableBuilder<KafkaExporterSpec, KafkaExporterSpecBuilder> {
    KafkaExporterSpecFluent<?> fluent;
    Boolean validationEnabled;

    public KafkaExporterSpecBuilder() {
        this(true);
    }

    public KafkaExporterSpecBuilder(Boolean validationEnabled) {
        this(new KafkaExporterSpec(), validationEnabled);
    }

    public KafkaExporterSpecBuilder(KafkaExporterSpecFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public KafkaExporterSpecBuilder(KafkaExporterSpecFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new KafkaExporterSpec(), validationEnabled);
    }

    public KafkaExporterSpecBuilder(KafkaExporterSpecFluent<?> fluent, KafkaExporterSpec instance) {
        this(fluent, instance, true);
    }

    public KafkaExporterSpecBuilder(KafkaExporterSpecFluent<?> fluent, KafkaExporterSpec instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withImage(instance.getImage());
        fluent.withGroupRegex(instance.getGroupRegex());
        fluent.withTopicRegex(instance.getTopicRegex());
        fluent.withResources(instance.getResources());
        fluent.withLivenessProbe(instance.getLivenessProbe());
        fluent.withReadinessProbe(instance.getReadinessProbe());
        fluent.withLogging(instance.getLogging());
        fluent.withEnableSaramaLogging(instance.getEnableSaramaLogging());
        fluent.withTemplate(instance.getTemplate());
        this.validationEnabled = validationEnabled;
    }

    public KafkaExporterSpecBuilder(KafkaExporterSpec instance) {
        this(instance, (Boolean)true);
    }

    public KafkaExporterSpecBuilder(KafkaExporterSpec instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withImage(instance.getImage());
        this.withGroupRegex(instance.getGroupRegex());
        this.withTopicRegex(instance.getTopicRegex());
        this.withResources(instance.getResources());
        this.withLivenessProbe(instance.getLivenessProbe());
        this.withReadinessProbe(instance.getReadinessProbe());
        this.withLogging(instance.getLogging());
        this.withEnableSaramaLogging(instance.getEnableSaramaLogging());
        this.withTemplate(instance.getTemplate());
        this.validationEnabled = validationEnabled;
    }

    public KafkaExporterSpec build() {
        KafkaExporterSpec buildable = new KafkaExporterSpec();
        buildable.setImage(this.fluent.getImage());
        buildable.setGroupRegex(this.fluent.getGroupRegex());
        buildable.setTopicRegex(this.fluent.getTopicRegex());
        buildable.setResources(this.fluent.getResources());
        buildable.setLivenessProbe(this.fluent.getLivenessProbe());
        buildable.setReadinessProbe(this.fluent.getReadinessProbe());
        buildable.setLogging(this.fluent.getLogging());
        buildable.setEnableSaramaLogging(this.fluent.isEnableSaramaLogging());
        buildable.setTemplate(this.fluent.getTemplate());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KafkaExporterSpecBuilder that = (KafkaExporterSpecBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

