/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.strimzi.api.kafka.model.UnknownPropertyPreserving;
import io.strimzi.crdgenerator.annotations.Description;
import io.strimzi.crdgenerator.annotations.Minimum;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"class", "tasksMax", "config"})
public class KafkaConnectorSpec
implements Serializable,
UnknownPropertyPreserving {
    private static final long serialVersionUID = 1L;
    private static final String FORBIDDEN_PARAMETERS = "connector.class, tasks.max";
    private String className;
    private Integer tasksMax;
    private Boolean pause;
    private Map<String, Object> config = new HashMap<String, Object>(0);
    private Map<String, Object> additionalProperties;

    @Description(value="The Class for the Kafka Connector")
    @JsonProperty(value="class")
    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    @Description(value="The maximum number of tasks for the Kafka Connector")
    @Minimum(value=1)
    public Integer getTasksMax() {
        return this.tasksMax;
    }

    public void setTasksMax(Integer tasksMax) {
        this.tasksMax = tasksMax;
    }

    @Description(value="The Kafka Connector configuration. The following properties cannot be set: connector.class, tasks.max")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public Map<String, Object> getConfig() {
        return this.config;
    }

    public void setConfig(Map<String, Object> config) {
        this.config = config;
    }

    @Description(value="Whether the connector should be paused. Defaults to false.")
    public Boolean getPause() {
        return this.pause;
    }

    public void setPause(Boolean pause) {
        this.pause = pause;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties != null ? this.additionalProperties : Collections.emptyMap();
    }

    @Override
    public void setAdditionalProperty(String name, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(name, value);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KafkaConnectorSpec)) {
            return false;
        }
        KafkaConnectorSpec other = (KafkaConnectorSpec)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$className = this.getClassName();
        String other$className = other.getClassName();
        if (this$className == null ? other$className != null : !this$className.equals(other$className)) {
            return false;
        }
        Integer this$tasksMax = this.getTasksMax();
        Integer other$tasksMax = other.getTasksMax();
        if (this$tasksMax == null ? other$tasksMax != null : !((Object)this$tasksMax).equals(other$tasksMax)) {
            return false;
        }
        Boolean this$pause = this.getPause();
        Boolean other$pause = other.getPause();
        if (this$pause == null ? other$pause != null : !((Object)this$pause).equals(other$pause)) {
            return false;
        }
        Map<String, Object> this$config = this.getConfig();
        Map<String, Object> other$config = other.getConfig();
        if (this$config == null ? other$config != null : !((Object)this$config).equals(other$config)) {
            return false;
        }
        Map<String, Object> this$additionalProperties = this.getAdditionalProperties();
        Map<String, Object> other$additionalProperties = other.getAdditionalProperties();
        return !(this$additionalProperties == null ? other$additionalProperties != null : !((Object)this$additionalProperties).equals(other$additionalProperties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof KafkaConnectorSpec;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $className = this.getClassName();
        result = result * 59 + ($className == null ? 43 : $className.hashCode());
        Integer $tasksMax = this.getTasksMax();
        result = result * 59 + ($tasksMax == null ? 43 : ((Object)$tasksMax).hashCode());
        Boolean $pause = this.getPause();
        result = result * 59 + ($pause == null ? 43 : ((Object)$pause).hashCode());
        Map<String, Object> $config = this.getConfig();
        result = result * 59 + ($config == null ? 43 : ((Object)$config).hashCode());
        Map<String, Object> $additionalProperties = this.getAdditionalProperties();
        result = result * 59 + ($additionalProperties == null ? 43 : ((Object)$additionalProperties).hashCode());
        return result;
    }
}

