/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.Affinity;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.fabric8.kubernetes.api.model.Toleration;
import io.strimzi.api.annotations.DeprecatedProperty;
import io.strimzi.api.kafka.model.InlineLogging;
import io.strimzi.api.kafka.model.JvmOptions;
import io.strimzi.api.kafka.model.KafkaConnectTls;
import io.strimzi.api.kafka.model.Logging;
import io.strimzi.api.kafka.model.Probe;
import io.strimzi.api.kafka.model.UnknownPropertyPreserving;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthentication;
import io.strimzi.api.kafka.model.connect.ExternalConfiguration;
import io.strimzi.api.kafka.model.template.KafkaConnectTemplate;
import io.strimzi.api.kafka.model.tracing.Tracing;
import io.strimzi.crdgenerator.annotations.Description;
import io.strimzi.crdgenerator.annotations.KubeLink;
import io.vertx.core.cli.annotations.DefaultValue;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"replicas", "config", "image", "livenessProbe", "readinessProbe", "jvmOptions", "affinity", "tolerations", "logging", "metrics", "tracing", "template"})
public class KafkaConnectSpec
implements Serializable,
UnknownPropertyPreserving {
    private static final long serialVersionUID = 1L;
    public static final String FORBIDDEN_PREFIXES = "ssl., sasl., security., listeners, plugin.path, rest., bootstrap.servers, consumer.interceptor.classes, producer.interceptor.classes";
    public static final String FORBIDDEN_PREFIX_EXCEPTIONS = "ssl.endpoint.identification.algorithm";
    private Map<String, Object> config = new HashMap<String, Object>(0);
    private Logging logging;
    private Integer replicas;
    private String version;
    private String image;
    private ResourceRequirements resources;
    private Probe livenessProbe;
    private Probe readinessProbe;
    private JvmOptions jvmOptions;
    private Map<String, Object> metrics;
    private Tracing tracing;
    private Affinity affinity;
    private List<Toleration> tolerations;
    private String bootstrapServers;
    private KafkaConnectTls tls;
    private KafkaClientAuthentication authentication;
    private KafkaConnectTemplate template;
    private ExternalConfiguration externalConfiguration;
    private Map<String, Object> additionalProperties = new HashMap<String, Object>(0);

    @Description(value="The number of pods in the Kafka Connect group.")
    @DefaultValue(value="3")
    public Integer getReplicas() {
        return this.replicas;
    }

    @Description(value="The Kafka Connect configuration. Properties with the following prefixes cannot be set: ssl., sasl., security., listeners, plugin.path, rest., bootstrap.servers, consumer.interceptor.classes, producer.interceptor.classes")
    public Map<String, Object> getConfig() {
        return this.config;
    }

    public void setConfig(Map<String, Object> config) {
        this.config = config;
    }

    @Description(value="Logging configuration for Kafka Connect")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Logging getLogging() {
        return this.logging == null ? new InlineLogging() : this.logging;
    }

    public void setLogging(Logging logging) {
        this.logging = logging;
    }

    public void setReplicas(Integer replicas) {
        this.replicas = replicas;
    }

    @Description(value="The Kafka Connect version. Defaults to {DefaultKafkaVersion}. Consult the user documentation to understand the process required to upgrade or downgrade the version.")
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @Description(value="The docker image for the pods.")
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public String getImage() {
        return this.image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Description(value="CPU and memory resources to reserve.")
    public ResourceRequirements getResources() {
        return this.resources;
    }

    public void setResources(ResourceRequirements resources) {
        this.resources = resources;
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @Description(value="Pod liveness checking.")
    public Probe getLivenessProbe() {
        return this.livenessProbe;
    }

    public void setLivenessProbe(Probe livenessProbe) {
        this.livenessProbe = livenessProbe;
    }

    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    @Description(value="Pod readiness checking.")
    public Probe getReadinessProbe() {
        return this.readinessProbe;
    }

    public void setReadinessProbe(Probe readinessProbe) {
        this.readinessProbe = readinessProbe;
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @Description(value="JVM Options for pods")
    public JvmOptions getJvmOptions() {
        return this.jvmOptions;
    }

    public void setJvmOptions(JvmOptions jvmOptions) {
        this.jvmOptions = jvmOptions;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Description(value="The Prometheus JMX Exporter configuration. See https://github.com/prometheus/jmx_exporter for details of the structure of this configuration.")
    public Map<String, Object> getMetrics() {
        return this.metrics;
    }

    public void setMetrics(Map<String, Object> metrics) {
        this.metrics = metrics;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Description(value="The configuration of tracing in Kafka Connect.")
    public Tracing getTracing() {
        return this.tracing;
    }

    public void setTracing(Tracing tracing) {
        this.tracing = tracing;
    }

    @Description(value="The pod's affinity rules.")
    @KubeLink(group="core", version="v1", kind="affinity")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @DeprecatedProperty(movedToPath="spec.template.pod.affinity")
    @Deprecated
    public Affinity getAffinity() {
        return this.affinity;
    }

    @Deprecated
    public void setAffinity(Affinity affinity) {
        this.affinity = affinity;
    }

    @Description(value="The pod's tolerations.")
    @KubeLink(group="core", version="v1", kind="toleration")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @DeprecatedProperty(movedToPath="spec.template.pod.tolerations")
    @Deprecated
    public List<Toleration> getTolerations() {
        return this.tolerations;
    }

    @Deprecated
    public void setTolerations(List<Toleration> tolerations) {
        this.tolerations = tolerations;
    }

    @Description(value="Bootstrap servers to connect to. This should be given as a comma separated list of _<hostname>_:\u200d_<port>_ pairs.")
    @JsonProperty(required=true)
    public String getBootstrapServers() {
        return this.bootstrapServers;
    }

    public void setBootstrapServers(String bootstrapServers) {
        this.bootstrapServers = bootstrapServers;
    }

    @Description(value="TLS configuration")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public KafkaConnectTls getTls() {
        return this.tls;
    }

    public void setTls(KafkaConnectTls tls) {
        this.tls = tls;
    }

    @Description(value="Authentication configuration for Kafka Connect")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public KafkaClientAuthentication getAuthentication() {
        return this.authentication;
    }

    public void setAuthentication(KafkaClientAuthentication authentication) {
        this.authentication = authentication;
    }

    @Description(value="Template for Kafka Connect and Kafka Connect S2I resources. The template allows users to specify how is the `Deployment`, `Pods` and `Service` generated.")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public KafkaConnectTemplate getTemplate() {
        return this.template;
    }

    public void setTemplate(KafkaConnectTemplate template) {
        this.template = template;
    }

    @Description(value="Pass data from Secrets or ConfigMaps to the Kafka Connect pods and use them to configure connectors.")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public ExternalConfiguration getExternalConfiguration() {
        return this.externalConfiguration;
    }

    public void setExternalConfiguration(ExternalConfiguration externalConfiguration) {
        this.externalConfiguration = externalConfiguration;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KafkaConnectSpec)) {
            return false;
        }
        KafkaConnectSpec other = (KafkaConnectSpec)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, Object> this$config = this.config;
        Map<String, Object> other$config = other.config;
        if (this$config == null ? other$config != null : !((Object)this$config).equals(other$config)) {
            return false;
        }
        Logging this$logging = this.logging;
        Logging other$logging = other.logging;
        if (this$logging == null ? other$logging != null : !((Object)this$logging).equals(other$logging)) {
            return false;
        }
        Integer this$replicas = this.replicas;
        Integer other$replicas = other.replicas;
        if (this$replicas == null ? other$replicas != null : !((Object)this$replicas).equals(other$replicas)) {
            return false;
        }
        String this$version = this.version;
        String other$version = other.version;
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$image = this.image;
        String other$image = other.image;
        if (this$image == null ? other$image != null : !this$image.equals(other$image)) {
            return false;
        }
        ResourceRequirements this$resources = this.resources;
        ResourceRequirements other$resources = other.resources;
        if (this$resources == null ? other$resources != null : !this$resources.equals(other$resources)) {
            return false;
        }
        Probe this$livenessProbe = this.livenessProbe;
        Probe other$livenessProbe = other.livenessProbe;
        if (this$livenessProbe == null ? other$livenessProbe != null : !((Object)this$livenessProbe).equals(other$livenessProbe)) {
            return false;
        }
        Probe this$readinessProbe = this.readinessProbe;
        Probe other$readinessProbe = other.readinessProbe;
        if (this$readinessProbe == null ? other$readinessProbe != null : !((Object)this$readinessProbe).equals(other$readinessProbe)) {
            return false;
        }
        JvmOptions this$jvmOptions = this.jvmOptions;
        JvmOptions other$jvmOptions = other.jvmOptions;
        if (this$jvmOptions == null ? other$jvmOptions != null : !((Object)this$jvmOptions).equals(other$jvmOptions)) {
            return false;
        }
        Map<String, Object> this$metrics = this.metrics;
        Map<String, Object> other$metrics = other.metrics;
        if (this$metrics == null ? other$metrics != null : !((Object)this$metrics).equals(other$metrics)) {
            return false;
        }
        Tracing this$tracing = this.tracing;
        Tracing other$tracing = other.tracing;
        if (this$tracing == null ? other$tracing != null : !((Object)this$tracing).equals(other$tracing)) {
            return false;
        }
        Affinity this$affinity = this.affinity;
        Affinity other$affinity = other.affinity;
        if (this$affinity == null ? other$affinity != null : !this$affinity.equals(other$affinity)) {
            return false;
        }
        List<Toleration> this$tolerations = this.tolerations;
        List<Toleration> other$tolerations = other.tolerations;
        if (this$tolerations == null ? other$tolerations != null : !((Object)this$tolerations).equals(other$tolerations)) {
            return false;
        }
        String this$bootstrapServers = this.bootstrapServers;
        String other$bootstrapServers = other.bootstrapServers;
        if (this$bootstrapServers == null ? other$bootstrapServers != null : !this$bootstrapServers.equals(other$bootstrapServers)) {
            return false;
        }
        KafkaConnectTls this$tls = this.tls;
        KafkaConnectTls other$tls = other.tls;
        if (this$tls == null ? other$tls != null : !((Object)this$tls).equals(other$tls)) {
            return false;
        }
        KafkaClientAuthentication this$authentication = this.authentication;
        KafkaClientAuthentication other$authentication = other.authentication;
        if (this$authentication == null ? other$authentication != null : !((Object)this$authentication).equals(other$authentication)) {
            return false;
        }
        KafkaConnectTemplate this$template = this.template;
        KafkaConnectTemplate other$template = other.template;
        if (this$template == null ? other$template != null : !((Object)this$template).equals(other$template)) {
            return false;
        }
        ExternalConfiguration this$externalConfiguration = this.externalConfiguration;
        ExternalConfiguration other$externalConfiguration = other.externalConfiguration;
        if (this$externalConfiguration == null ? other$externalConfiguration != null : !((Object)this$externalConfiguration).equals(other$externalConfiguration)) {
            return false;
        }
        Map<String, Object> this$additionalProperties = this.additionalProperties;
        Map<String, Object> other$additionalProperties = other.additionalProperties;
        return !(this$additionalProperties == null ? other$additionalProperties != null : !((Object)this$additionalProperties).equals(other$additionalProperties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof KafkaConnectSpec;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, Object> $config = this.config;
        result = result * 59 + ($config == null ? 43 : ((Object)$config).hashCode());
        Logging $logging = this.logging;
        result = result * 59 + ($logging == null ? 43 : ((Object)$logging).hashCode());
        Integer $replicas = this.replicas;
        result = result * 59 + ($replicas == null ? 43 : ((Object)$replicas).hashCode());
        String $version = this.version;
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $image = this.image;
        result = result * 59 + ($image == null ? 43 : $image.hashCode());
        ResourceRequirements $resources = this.resources;
        result = result * 59 + ($resources == null ? 43 : $resources.hashCode());
        Probe $livenessProbe = this.livenessProbe;
        result = result * 59 + ($livenessProbe == null ? 43 : ((Object)$livenessProbe).hashCode());
        Probe $readinessProbe = this.readinessProbe;
        result = result * 59 + ($readinessProbe == null ? 43 : ((Object)$readinessProbe).hashCode());
        JvmOptions $jvmOptions = this.jvmOptions;
        result = result * 59 + ($jvmOptions == null ? 43 : ((Object)$jvmOptions).hashCode());
        Map<String, Object> $metrics = this.metrics;
        result = result * 59 + ($metrics == null ? 43 : ((Object)$metrics).hashCode());
        Tracing $tracing = this.tracing;
        result = result * 59 + ($tracing == null ? 43 : ((Object)$tracing).hashCode());
        Affinity $affinity = this.affinity;
        result = result * 59 + ($affinity == null ? 43 : $affinity.hashCode());
        List<Toleration> $tolerations = this.tolerations;
        result = result * 59 + ($tolerations == null ? 43 : ((Object)$tolerations).hashCode());
        String $bootstrapServers = this.bootstrapServers;
        result = result * 59 + ($bootstrapServers == null ? 43 : $bootstrapServers.hashCode());
        KafkaConnectTls $tls = this.tls;
        result = result * 59 + ($tls == null ? 43 : ((Object)$tls).hashCode());
        KafkaClientAuthentication $authentication = this.authentication;
        result = result * 59 + ($authentication == null ? 43 : ((Object)$authentication).hashCode());
        KafkaConnectTemplate $template = this.template;
        result = result * 59 + ($template == null ? 43 : ((Object)$template).hashCode());
        ExternalConfiguration $externalConfiguration = this.externalConfiguration;
        result = result * 59 + ($externalConfiguration == null ? 43 : ((Object)$externalConfiguration).hashCode());
        Map<String, Object> $additionalProperties = this.additionalProperties;
        result = result * 59 + ($additionalProperties == null ? 43 : ((Object)$additionalProperties).hashCode());
        return result;
    }
}

