/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.client.CustomResource;
import io.strimzi.api.kafka.model.KafkaBridgeSpec;
import io.strimzi.api.kafka.model.UnknownPropertyPreserving;
import io.strimzi.api.kafka.model.status.HasStatus;
import io.strimzi.api.kafka.model.status.KafkaBridgeStatus;
import io.strimzi.crdgenerator.annotations.Crd;
import io.strimzi.crdgenerator.annotations.Description;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@JsonDeserialize
@Crd(apiVersion="apiextensions.k8s.io/v1beta1", spec=@Crd.Spec(names=@Crd.Spec.Names(kind="KafkaBridge", plural="kafkabridges", shortNames={"kb"}), group="kafka.strimzi.io", scope="Namespaced", version="v1alpha1", versions={@Crd.Spec.Version(name="v1alpha1", served=true, storage=true)}, subresources=@Crd.Spec.Subresources(status={@Crd.Spec.Subresources.Status}), additionalPrinterColumns={@Crd.Spec.AdditionalPrinterColumn(name="Desired replicas", description="The desired number of Kafka Bridge replicas", jsonPath=".spec.replicas", type="integer"), @Crd.Spec.AdditionalPrinterColumn(name="Bootstrap Servers", description="The boostrap servers", jsonPath=".spec.bootstrapServers", type="string", priority=1)}))
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"apiVersion", "kind", "metadata", "spec", "status"})
public class KafkaBridge
extends CustomResource
implements UnknownPropertyPreserving,
HasStatus<KafkaBridgeStatus> {
    private static final long serialVersionUID = 1L;
    public static final String SCOPE = "Namespaced";
    public static final String V1ALPHA1 = "v1alpha1";
    public static final List<String> VERSIONS = Collections.unmodifiableList(Arrays.asList("v1alpha1"));
    public static final String RESOURCE_KIND = "KafkaBridge";
    public static final String RESOURCE_LIST_KIND = "KafkaBridgeList";
    public static final String RESOURCE_GROUP = "kafka.strimzi.io";
    public static final String RESOURCE_PLURAL = "kafkabridges";
    public static final String RESOURCE_SINGULAR = "kafkabridge";
    public static final String CRD_API_VERSION = "apiextensions.k8s.io/v1beta1";
    public static final String CRD_NAME = "kafkabridges.kafka.strimzi.io";
    public static final String SHORT_NAME = "kb";
    public static final List<String> RESOURCE_SHORTNAMES = Collections.singletonList("kb");
    private String apiVersion;
    private ObjectMeta metadata;
    private KafkaBridgeSpec spec;
    private KafkaBridgeStatus status;
    private Map<String, Object> additionalProperties = new HashMap<String, Object>(0);

    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public ObjectMeta getMetadata() {
        return super.getMetadata();
    }

    public void setMetadata(ObjectMeta metadata) {
        super.setMetadata(metadata);
    }

    @Description(value="The specification of the Kafka Bridge.")
    public KafkaBridgeSpec getSpec() {
        return this.spec;
    }

    public void setSpec(KafkaBridgeSpec spec) {
        this.spec = spec;
    }

    @Override
    @Description(value="The status of the Kafka Bridge.")
    public KafkaBridgeStatus getStatus() {
        return this.status;
    }

    public void setStatus(KafkaBridgeStatus status) {
        this.status = status;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties != null ? this.additionalProperties : Collections.emptyMap();
    }

    @Override
    public void setAdditionalProperty(String name, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(name, value);
    }

    public String toString() {
        YAMLMapper mapper = new YAMLMapper();
        try {
            return mapper.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KafkaBridge)) {
            return false;
        }
        KafkaBridge other = (KafkaBridge)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$apiVersion = this.getApiVersion();
        String other$apiVersion = other.getApiVersion();
        if (this$apiVersion == null ? other$apiVersion != null : !this$apiVersion.equals(other$apiVersion)) {
            return false;
        }
        ObjectMeta this$metadata = this.getMetadata();
        ObjectMeta other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !this$metadata.equals(other$metadata)) {
            return false;
        }
        KafkaBridgeSpec this$spec = this.getSpec();
        KafkaBridgeSpec other$spec = other.getSpec();
        if (this$spec == null ? other$spec != null : !((Object)this$spec).equals(other$spec)) {
            return false;
        }
        KafkaBridgeStatus this$status = this.getStatus();
        KafkaBridgeStatus other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)this$status).equals(other$status)) {
            return false;
        }
        Map<String, Object> this$additionalProperties = this.getAdditionalProperties();
        Map<String, Object> other$additionalProperties = other.getAdditionalProperties();
        return !(this$additionalProperties == null ? other$additionalProperties != null : !((Object)this$additionalProperties).equals(other$additionalProperties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof KafkaBridge;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $apiVersion = this.getApiVersion();
        result = result * 59 + ($apiVersion == null ? 43 : $apiVersion.hashCode());
        ObjectMeta $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : $metadata.hashCode());
        KafkaBridgeSpec $spec = this.getSpec();
        result = result * 59 + ($spec == null ? 43 : ((Object)$spec).hashCode());
        KafkaBridgeStatus $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)$status).hashCode());
        Map<String, Object> $additionalProperties = this.getAdditionalProperties();
        result = result * 59 + ($additionalProperties == null ? 43 : ((Object)$additionalProperties).hashCode());
        return result;
    }
}

