/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.client.CustomResource;
import io.strimzi.api.kafka.model.KafkaSpec;
import io.strimzi.api.kafka.model.UnknownPropertyPreserving;
import io.strimzi.api.kafka.model.status.HasStatus;
import io.strimzi.api.kafka.model.status.KafkaStatus;
import io.strimzi.crdgenerator.annotations.Crd;
import io.strimzi.crdgenerator.annotations.Description;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@JsonDeserialize
@Crd(apiVersion="apiextensions.k8s.io/v1beta1", spec=@Crd.Spec(names=@Crd.Spec.Names(kind="Kafka", plural="kafkas", shortNames={"k"}), group="kafka.strimzi.io", scope="Namespaced", version="v1beta1", versions={@Crd.Spec.Version(name="v1beta1", served=true, storage=true), @Crd.Spec.Version(name="v1alpha1", served=true, storage=false)}, subresources=@Crd.Spec.Subresources(status={@Crd.Spec.Subresources.Status}), additionalPrinterColumns={@Crd.Spec.AdditionalPrinterColumn(name="Desired Kafka replicas", description="The desired number of Kafka replicas in the cluster", jsonPath=".spec.kafka.replicas", type="integer"), @Crd.Spec.AdditionalPrinterColumn(name="Desired ZK replicas", description="The desired number of ZooKeeper replicas in the cluster", jsonPath=".spec.zookeeper.replicas", type="integer")}))
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"apiVersion", "kind", "metadata", "spec", "status"})
public class Kafka
extends CustomResource
implements UnknownPropertyPreserving,
HasStatus<KafkaStatus> {
    public static final String V1BETA1 = "v1beta1";
    public static final String V1ALPHA1 = "v1alpha1";
    public static final List<String> VERSIONS = Collections.unmodifiableList(Arrays.asList("v1beta1", "v1alpha1"));
    private static final long serialVersionUID = 1L;
    public static final String SCOPE = "Namespaced";
    public static final String RESOURCE_KIND = "Kafka";
    public static final String RESOURCE_LIST_KIND = "KafkaList";
    public static final String RESOURCE_GROUP = "kafka.strimzi.io";
    public static final String RESOURCE_PLURAL = "kafkas";
    public static final String RESOURCE_SINGULAR = "kafka";
    public static final String CRD_API_VERSION = "apiextensions.k8s.io/v1beta1";
    public static final String CRD_NAME = "kafkas.kafka.strimzi.io";
    public static final String SHORT_NAME = "k";
    public static final List<String> RESOURCE_SHORTNAMES = Collections.unmodifiableList(Collections.singletonList("k"));
    private String apiVersion;
    private ObjectMeta metadata;
    private KafkaSpec spec;
    private Map<String, Object> additionalProperties = new HashMap<String, Object>(0);
    private KafkaStatus status;

    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    @JsonProperty(value="kind")
    public String getKind() {
        return RESOURCE_KIND;
    }

    public ObjectMeta getMetadata() {
        return super.getMetadata();
    }

    public void setMetadata(ObjectMeta metadata) {
        super.setMetadata(metadata);
    }

    @Description(value="The specification of the Kafka and ZooKeeper clusters, and Topic Operator.")
    public KafkaSpec getSpec() {
        return this.spec;
    }

    public void setSpec(KafkaSpec spec) {
        this.spec = spec;
    }

    @Override
    @Description(value="The status of the Kafka and ZooKeeper clusters, and Topic Operator.")
    public KafkaStatus getStatus() {
        return this.status;
    }

    public void setStatus(KafkaStatus status) {
        this.status = status;
    }

    public String toString() {
        YAMLMapper mapper = new YAMLMapper().disable(YAMLGenerator.Feature.USE_NATIVE_TYPE_ID);
        try {
            return mapper.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Kafka)) {
            return false;
        }
        Kafka other = (Kafka)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$apiVersion = this.getApiVersion();
        String other$apiVersion = other.getApiVersion();
        if (this$apiVersion == null ? other$apiVersion != null : !this$apiVersion.equals(other$apiVersion)) {
            return false;
        }
        ObjectMeta this$metadata = this.getMetadata();
        ObjectMeta other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !this$metadata.equals(other$metadata)) {
            return false;
        }
        KafkaSpec this$spec = this.getSpec();
        KafkaSpec other$spec = other.getSpec();
        if (this$spec == null ? other$spec != null : !((Object)this$spec).equals(other$spec)) {
            return false;
        }
        Map<String, Object> this$additionalProperties = this.getAdditionalProperties();
        Map<String, Object> other$additionalProperties = other.getAdditionalProperties();
        if (this$additionalProperties == null ? other$additionalProperties != null : !((Object)this$additionalProperties).equals(other$additionalProperties)) {
            return false;
        }
        KafkaStatus this$status = this.getStatus();
        KafkaStatus other$status = other.getStatus();
        return !(this$status == null ? other$status != null : !((Object)this$status).equals(other$status));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Kafka;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $apiVersion = this.getApiVersion();
        result = result * 59 + ($apiVersion == null ? 43 : $apiVersion.hashCode());
        ObjectMeta $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : $metadata.hashCode());
        KafkaSpec $spec = this.getSpec();
        result = result * 59 + ($spec == null ? 43 : ((Object)$spec).hashCode());
        Map<String, Object> $additionalProperties = this.getAdditionalProperties();
        result = result * 59 + ($additionalProperties == null ? 43 : ((Object)$additionalProperties).hashCode());
        KafkaStatus $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)$status).hashCode());
        return result;
    }
}

