/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.strimzi.api.kafka.model.EntityOperatorJvmOptions;
import io.strimzi.api.kafka.model.EntityOperatorJvmOptionsBuilder;
import io.strimzi.api.kafka.model.EntityOperatorJvmOptionsFluentImpl;
import io.strimzi.api.kafka.model.EntityTopicOperatorSpec;
import io.strimzi.api.kafka.model.EntityTopicOperatorSpecFluent;
import io.strimzi.api.kafka.model.ExternalLogging;
import io.strimzi.api.kafka.model.ExternalLoggingBuilder;
import io.strimzi.api.kafka.model.ExternalLoggingFluentImpl;
import io.strimzi.api.kafka.model.InlineLogging;
import io.strimzi.api.kafka.model.InlineLoggingBuilder;
import io.strimzi.api.kafka.model.InlineLoggingFluentImpl;
import io.strimzi.api.kafka.model.Logging;
import io.strimzi.api.kafka.model.Probe;
import io.strimzi.api.kafka.model.ProbeBuilder;
import io.strimzi.api.kafka.model.ProbeFluentImpl;

public class EntityTopicOperatorSpecFluentImpl<A extends EntityTopicOperatorSpecFluent<A>>
extends BaseFluent<A>
implements EntityTopicOperatorSpecFluent<A> {
    private String watchedNamespace;
    private String image;
    private int reconciliationIntervalSeconds;
    private int zookeeperSessionTimeoutSeconds;
    private int topicMetadataMaxAttempts;
    private ProbeBuilder livenessProbe;
    private ProbeBuilder readinessProbe;
    private ResourceRequirements resources;
    private VisitableBuilder<? extends Logging, ?> logging;
    private EntityOperatorJvmOptionsBuilder jvmOptions;

    public EntityTopicOperatorSpecFluentImpl() {
    }

    public EntityTopicOperatorSpecFluentImpl(EntityTopicOperatorSpec instance) {
        this.withWatchedNamespace(instance.getWatchedNamespace());
        this.withImage(instance.getImage());
        this.withReconciliationIntervalSeconds(instance.getReconciliationIntervalSeconds());
        this.withZookeeperSessionTimeoutSeconds(instance.getZookeeperSessionTimeoutSeconds());
        this.withTopicMetadataMaxAttempts(instance.getTopicMetadataMaxAttempts());
        this.withLivenessProbe(instance.getLivenessProbe());
        this.withReadinessProbe(instance.getReadinessProbe());
        this.withResources(instance.getResources());
        this.withLogging(instance.getLogging());
        this.withJvmOptions(instance.getJvmOptions());
    }

    @Override
    public String getWatchedNamespace() {
        return this.watchedNamespace;
    }

    @Override
    public A withWatchedNamespace(String watchedNamespace) {
        this.watchedNamespace = watchedNamespace;
        return (A)this;
    }

    @Override
    public Boolean hasWatchedNamespace() {
        return this.watchedNamespace != null;
    }

    @Override
    public A withNewWatchedNamespace(String arg1) {
        return this.withWatchedNamespace(new String(arg1));
    }

    @Override
    public A withNewWatchedNamespace(StringBuilder arg1) {
        return this.withWatchedNamespace(new String(arg1));
    }

    @Override
    public A withNewWatchedNamespace(StringBuffer arg1) {
        return this.withWatchedNamespace(new String(arg1));
    }

    @Override
    public String getImage() {
        return this.image;
    }

    @Override
    public A withImage(String image) {
        this.image = image;
        return (A)this;
    }

    @Override
    public Boolean hasImage() {
        return this.image != null;
    }

    @Override
    public A withNewImage(String arg1) {
        return this.withImage(new String(arg1));
    }

    @Override
    public A withNewImage(StringBuilder arg1) {
        return this.withImage(new String(arg1));
    }

    @Override
    public A withNewImage(StringBuffer arg1) {
        return this.withImage(new String(arg1));
    }

    @Override
    public int getReconciliationIntervalSeconds() {
        return this.reconciliationIntervalSeconds;
    }

    @Override
    public A withReconciliationIntervalSeconds(int reconciliationIntervalSeconds) {
        this.reconciliationIntervalSeconds = reconciliationIntervalSeconds;
        return (A)this;
    }

    @Override
    public Boolean hasReconciliationIntervalSeconds() {
        return true;
    }

    @Override
    public int getZookeeperSessionTimeoutSeconds() {
        return this.zookeeperSessionTimeoutSeconds;
    }

    @Override
    public A withZookeeperSessionTimeoutSeconds(int zookeeperSessionTimeoutSeconds) {
        this.zookeeperSessionTimeoutSeconds = zookeeperSessionTimeoutSeconds;
        return (A)this;
    }

    @Override
    public Boolean hasZookeeperSessionTimeoutSeconds() {
        return true;
    }

    @Override
    public int getTopicMetadataMaxAttempts() {
        return this.topicMetadataMaxAttempts;
    }

    @Override
    public A withTopicMetadataMaxAttempts(int topicMetadataMaxAttempts) {
        this.topicMetadataMaxAttempts = topicMetadataMaxAttempts;
        return (A)this;
    }

    @Override
    public Boolean hasTopicMetadataMaxAttempts() {
        return true;
    }

    @Override
    @Deprecated
    public Probe getLivenessProbe() {
        return this.livenessProbe != null ? this.livenessProbe.build() : null;
    }

    @Override
    public Probe buildLivenessProbe() {
        return this.livenessProbe != null ? this.livenessProbe.build() : null;
    }

    @Override
    public A withLivenessProbe(Probe livenessProbe) {
        this._visitables.get((Object)"livenessProbe").remove(this.livenessProbe);
        if (livenessProbe != null) {
            this.livenessProbe = new ProbeBuilder(livenessProbe);
            this._visitables.get((Object)"livenessProbe").add(this.livenessProbe);
        }
        return (A)this;
    }

    @Override
    public Boolean hasLivenessProbe() {
        return this.livenessProbe != null;
    }

    @Override
    public A withNewLivenessProbe(int initialDelaySeconds, int timeoutSeconds) {
        return this.withLivenessProbe(new Probe(initialDelaySeconds, timeoutSeconds));
    }

    @Override
    public EntityTopicOperatorSpecFluent.LivenessProbeNested<A> withNewLivenessProbe() {
        return new LivenessProbeNestedImpl();
    }

    @Override
    public EntityTopicOperatorSpecFluent.LivenessProbeNested<A> withNewLivenessProbeLike(Probe item) {
        return new LivenessProbeNestedImpl(item);
    }

    @Override
    public EntityTopicOperatorSpecFluent.LivenessProbeNested<A> editLivenessProbe() {
        return this.withNewLivenessProbeLike(this.getLivenessProbe());
    }

    @Override
    public EntityTopicOperatorSpecFluent.LivenessProbeNested<A> editOrNewLivenessProbe() {
        return this.withNewLivenessProbeLike(this.getLivenessProbe() != null ? this.getLivenessProbe() : new ProbeBuilder().build());
    }

    @Override
    public EntityTopicOperatorSpecFluent.LivenessProbeNested<A> editOrNewLivenessProbeLike(Probe item) {
        return this.withNewLivenessProbeLike(this.getLivenessProbe() != null ? this.getLivenessProbe() : item);
    }

    @Override
    @Deprecated
    public Probe getReadinessProbe() {
        return this.readinessProbe != null ? this.readinessProbe.build() : null;
    }

    @Override
    public Probe buildReadinessProbe() {
        return this.readinessProbe != null ? this.readinessProbe.build() : null;
    }

    @Override
    public A withReadinessProbe(Probe readinessProbe) {
        this._visitables.get((Object)"readinessProbe").remove(this.readinessProbe);
        if (readinessProbe != null) {
            this.readinessProbe = new ProbeBuilder(readinessProbe);
            this._visitables.get((Object)"readinessProbe").add(this.readinessProbe);
        }
        return (A)this;
    }

    @Override
    public Boolean hasReadinessProbe() {
        return this.readinessProbe != null;
    }

    @Override
    public A withNewReadinessProbe(int initialDelaySeconds, int timeoutSeconds) {
        return this.withReadinessProbe(new Probe(initialDelaySeconds, timeoutSeconds));
    }

    @Override
    public EntityTopicOperatorSpecFluent.ReadinessProbeNested<A> withNewReadinessProbe() {
        return new ReadinessProbeNestedImpl();
    }

    @Override
    public EntityTopicOperatorSpecFluent.ReadinessProbeNested<A> withNewReadinessProbeLike(Probe item) {
        return new ReadinessProbeNestedImpl(item);
    }

    @Override
    public EntityTopicOperatorSpecFluent.ReadinessProbeNested<A> editReadinessProbe() {
        return this.withNewReadinessProbeLike(this.getReadinessProbe());
    }

    @Override
    public EntityTopicOperatorSpecFluent.ReadinessProbeNested<A> editOrNewReadinessProbe() {
        return this.withNewReadinessProbeLike(this.getReadinessProbe() != null ? this.getReadinessProbe() : new ProbeBuilder().build());
    }

    @Override
    public EntityTopicOperatorSpecFluent.ReadinessProbeNested<A> editOrNewReadinessProbeLike(Probe item) {
        return this.withNewReadinessProbeLike(this.getReadinessProbe() != null ? this.getReadinessProbe() : item);
    }

    @Override
    public ResourceRequirements getResources() {
        return this.resources;
    }

    @Override
    public A withResources(ResourceRequirements resources) {
        this.resources = resources;
        return (A)this;
    }

    @Override
    public Boolean hasResources() {
        return this.resources != null;
    }

    @Override
    @Deprecated
    public Logging getLogging() {
        return this.logging != null ? (Logging)this.logging.build() : null;
    }

    @Override
    public Logging buildLogging() {
        return this.logging != null ? (Logging)this.logging.build() : null;
    }

    @Override
    public A withLogging(Logging logging) {
        if (logging instanceof ExternalLogging) {
            this.logging = new ExternalLoggingBuilder((ExternalLogging)logging);
            this._visitables.get((Object)"logging").add(this.logging);
        }
        if (logging instanceof InlineLogging) {
            this.logging = new InlineLoggingBuilder((InlineLogging)logging);
            this._visitables.get((Object)"logging").add(this.logging);
        }
        return (A)this;
    }

    @Override
    public Boolean hasLogging() {
        return this.logging != null;
    }

    @Override
    public A withExternalLogging(ExternalLogging externalLogging) {
        this._visitables.get((Object)"logging").remove(this.logging);
        if (externalLogging != null) {
            this.logging = new ExternalLoggingBuilder(externalLogging);
            this._visitables.get((Object)"logging").add(this.logging);
        }
        return (A)this;
    }

    @Override
    public EntityTopicOperatorSpecFluent.ExternalLoggingNested<A> withNewExternalLogging() {
        return new ExternalLoggingNestedImpl();
    }

    @Override
    public EntityTopicOperatorSpecFluent.ExternalLoggingNested<A> withNewExternalLoggingLike(ExternalLogging item) {
        return new ExternalLoggingNestedImpl(item);
    }

    @Override
    public A withInlineLogging(InlineLogging inlineLogging) {
        this._visitables.get((Object)"logging").remove(this.logging);
        if (inlineLogging != null) {
            this.logging = new InlineLoggingBuilder(inlineLogging);
            this._visitables.get((Object)"logging").add(this.logging);
        }
        return (A)this;
    }

    @Override
    public EntityTopicOperatorSpecFluent.InlineLoggingNested<A> withNewInlineLogging() {
        return new InlineLoggingNestedImpl();
    }

    @Override
    public EntityTopicOperatorSpecFluent.InlineLoggingNested<A> withNewInlineLoggingLike(InlineLogging item) {
        return new InlineLoggingNestedImpl(item);
    }

    @Override
    @Deprecated
    public EntityOperatorJvmOptions getJvmOptions() {
        return this.jvmOptions != null ? this.jvmOptions.build() : null;
    }

    @Override
    public EntityOperatorJvmOptions buildJvmOptions() {
        return this.jvmOptions != null ? this.jvmOptions.build() : null;
    }

    @Override
    public A withJvmOptions(EntityOperatorJvmOptions jvmOptions) {
        this._visitables.get((Object)"jvmOptions").remove(this.jvmOptions);
        if (jvmOptions != null) {
            this.jvmOptions = new EntityOperatorJvmOptionsBuilder(jvmOptions);
            this._visitables.get((Object)"jvmOptions").add(this.jvmOptions);
        }
        return (A)this;
    }

    @Override
    public Boolean hasJvmOptions() {
        return this.jvmOptions != null;
    }

    @Override
    public EntityTopicOperatorSpecFluent.JvmOptionsNested<A> withNewJvmOptions() {
        return new JvmOptionsNestedImpl();
    }

    @Override
    public EntityTopicOperatorSpecFluent.JvmOptionsNested<A> withNewJvmOptionsLike(EntityOperatorJvmOptions item) {
        return new JvmOptionsNestedImpl(item);
    }

    @Override
    public EntityTopicOperatorSpecFluent.JvmOptionsNested<A> editJvmOptions() {
        return this.withNewJvmOptionsLike(this.getJvmOptions());
    }

    @Override
    public EntityTopicOperatorSpecFluent.JvmOptionsNested<A> editOrNewJvmOptions() {
        return this.withNewJvmOptionsLike(this.getJvmOptions() != null ? this.getJvmOptions() : new EntityOperatorJvmOptionsBuilder().build());
    }

    @Override
    public EntityTopicOperatorSpecFluent.JvmOptionsNested<A> editOrNewJvmOptionsLike(EntityOperatorJvmOptions item) {
        return this.withNewJvmOptionsLike(this.getJvmOptions() != null ? this.getJvmOptions() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EntityTopicOperatorSpecFluentImpl that = (EntityTopicOperatorSpecFluentImpl)o;
        if (this.watchedNamespace != null ? !this.watchedNamespace.equals(that.watchedNamespace) : that.watchedNamespace != null) {
            return false;
        }
        if (this.image != null ? !this.image.equals(that.image) : that.image != null) {
            return false;
        }
        if (this.reconciliationIntervalSeconds != that.reconciliationIntervalSeconds) {
            return false;
        }
        if (this.zookeeperSessionTimeoutSeconds != that.zookeeperSessionTimeoutSeconds) {
            return false;
        }
        if (this.topicMetadataMaxAttempts != that.topicMetadataMaxAttempts) {
            return false;
        }
        if (this.livenessProbe != null ? !this.livenessProbe.equals(that.livenessProbe) : that.livenessProbe != null) {
            return false;
        }
        if (this.readinessProbe != null ? !this.readinessProbe.equals(that.readinessProbe) : that.readinessProbe != null) {
            return false;
        }
        if (this.resources != null ? !this.resources.equals((Object)that.resources) : that.resources != null) {
            return false;
        }
        if (this.logging != null ? !this.logging.equals(that.logging) : that.logging != null) {
            return false;
        }
        return !(this.jvmOptions != null ? !this.jvmOptions.equals(that.jvmOptions) : that.jvmOptions != null);
    }

    public class JvmOptionsNestedImpl<N>
    extends EntityOperatorJvmOptionsFluentImpl<EntityTopicOperatorSpecFluent.JvmOptionsNested<N>>
    implements EntityTopicOperatorSpecFluent.JvmOptionsNested<N>,
    Nested<N> {
        private final EntityOperatorJvmOptionsBuilder builder;

        JvmOptionsNestedImpl(EntityOperatorJvmOptions item) {
            this.builder = new EntityOperatorJvmOptionsBuilder(this, item);
        }

        JvmOptionsNestedImpl() {
            this.builder = new EntityOperatorJvmOptionsBuilder(this);
        }

        @Override
        public N and() {
            return (N)EntityTopicOperatorSpecFluentImpl.this.withJvmOptions(this.builder.build());
        }

        @Override
        public N endJvmOptions() {
            return this.and();
        }
    }

    public class InlineLoggingNestedImpl<N>
    extends InlineLoggingFluentImpl<EntityTopicOperatorSpecFluent.InlineLoggingNested<N>>
    implements EntityTopicOperatorSpecFluent.InlineLoggingNested<N>,
    Nested<N> {
        private final InlineLoggingBuilder builder;

        InlineLoggingNestedImpl(InlineLogging item) {
            this.builder = new InlineLoggingBuilder(this, item);
        }

        InlineLoggingNestedImpl() {
            this.builder = new InlineLoggingBuilder(this);
        }

        @Override
        public N and() {
            return (N)EntityTopicOperatorSpecFluentImpl.this.withInlineLogging(this.builder.build());
        }

        @Override
        public N endInlineLogging() {
            return this.and();
        }
    }

    public class ExternalLoggingNestedImpl<N>
    extends ExternalLoggingFluentImpl<EntityTopicOperatorSpecFluent.ExternalLoggingNested<N>>
    implements EntityTopicOperatorSpecFluent.ExternalLoggingNested<N>,
    Nested<N> {
        private final ExternalLoggingBuilder builder;

        ExternalLoggingNestedImpl(ExternalLogging item) {
            this.builder = new ExternalLoggingBuilder(this, item);
        }

        ExternalLoggingNestedImpl() {
            this.builder = new ExternalLoggingBuilder(this);
        }

        @Override
        public N and() {
            return (N)EntityTopicOperatorSpecFluentImpl.this.withExternalLogging(this.builder.build());
        }

        @Override
        public N endExternalLogging() {
            return this.and();
        }
    }

    public class ReadinessProbeNestedImpl<N>
    extends ProbeFluentImpl<EntityTopicOperatorSpecFluent.ReadinessProbeNested<N>>
    implements EntityTopicOperatorSpecFluent.ReadinessProbeNested<N>,
    Nested<N> {
        private final ProbeBuilder builder;

        ReadinessProbeNestedImpl(Probe item) {
            this.builder = new ProbeBuilder(this, item);
        }

        ReadinessProbeNestedImpl() {
            this.builder = new ProbeBuilder(this);
        }

        @Override
        public N and() {
            return (N)EntityTopicOperatorSpecFluentImpl.this.withReadinessProbe(this.builder.build());
        }

        @Override
        public N endReadinessProbe() {
            return this.and();
        }
    }

    public class LivenessProbeNestedImpl<N>
    extends ProbeFluentImpl<EntityTopicOperatorSpecFluent.LivenessProbeNested<N>>
    implements EntityTopicOperatorSpecFluent.LivenessProbeNested<N>,
    Nested<N> {
        private final ProbeBuilder builder;

        LivenessProbeNestedImpl(Probe item) {
            this.builder = new ProbeBuilder(this, item);
        }

        LivenessProbeNestedImpl() {
            this.builder = new ProbeBuilder(this);
        }

        @Override
        public N and() {
            return (N)EntityTopicOperatorSpecFluentImpl.this.withLivenessProbe(this.builder.build());
        }

        @Override
        public N endLivenessProbe() {
            return this.and();
        }
    }
}

