/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.Affinity;
import io.fabric8.kubernetes.api.model.Toleration;
import io.strimzi.api.annotations.DeprecatedProperty;
import io.strimzi.api.kafka.model.EntityTopicOperatorSpec;
import io.strimzi.api.kafka.model.EntityUserOperatorSpec;
import io.strimzi.api.kafka.model.TlsSidecar;
import io.strimzi.api.kafka.model.UnknownPropertyPreserving;
import io.strimzi.api.kafka.model.template.EntityOperatorTemplate;
import io.strimzi.crdgenerator.annotations.Description;
import io.strimzi.crdgenerator.annotations.KubeLink;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"topicOperator", "userOperator", "affinity", "tolerations", "tlsSidecar"})
public class EntityOperatorSpec
implements UnknownPropertyPreserving,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final int DEFAULT_REPLICAS = 1;
    public static final int DEFAULT_ZOOKEEPER_PORT = 2181;
    private EntityTopicOperatorSpec topicOperator;
    private EntityUserOperatorSpec userOperator;
    private Affinity affinity;
    private List<Toleration> tolerations;
    private TlsSidecar tlsSidecar;
    private EntityOperatorTemplate template;
    private Map<String, Object> additionalProperties = new HashMap<String, Object>(0);

    @Description(value="Configuration of the Topic Operator")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public EntityTopicOperatorSpec getTopicOperator() {
        return this.topicOperator;
    }

    public void setTopicOperator(EntityTopicOperatorSpec topicOperator) {
        this.topicOperator = topicOperator;
    }

    @Description(value="Configuration of the User Operator")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public EntityUserOperatorSpec getUserOperator() {
        return this.userOperator;
    }

    public void setUserOperator(EntityUserOperatorSpec userOperator) {
        this.userOperator = userOperator;
    }

    @Description(value="The pod's affinity rules.")
    @KubeLink(group="core", version="v1", kind="affinity")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @DeprecatedProperty(movedToPath="spec.template.pod.affinity")
    @Deprecated
    public Affinity getAffinity() {
        return this.affinity;
    }

    @Deprecated
    public void setAffinity(Affinity affinity) {
        this.affinity = affinity;
    }

    @Description(value="The pod's tolerations.")
    @KubeLink(group="core", version="v1", kind="toleration")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @DeprecatedProperty(movedToPath="spec.template.pod.tolerations")
    @Deprecated
    public List<Toleration> getTolerations() {
        return this.tolerations;
    }

    @Deprecated
    public void setTolerations(List<Toleration> tolerations) {
        this.tolerations = tolerations;
    }

    @Description(value="TLS sidecar configuration")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public TlsSidecar getTlsSidecar() {
        return this.tlsSidecar;
    }

    public void setTlsSidecar(TlsSidecar tlsSidecar) {
        this.tlsSidecar = tlsSidecar;
    }

    @Description(value="Template for Entity Operator resources. The template allows users to specify how is the `Deployment` and `Pods` generated.")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public EntityOperatorTemplate getTemplate() {
        return this.template;
    }

    public void setTemplate(EntityOperatorTemplate template) {
        this.template = template;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EntityOperatorSpec)) {
            return false;
        }
        EntityOperatorSpec other = (EntityOperatorSpec)o;
        if (!other.canEqual(this)) {
            return false;
        }
        EntityTopicOperatorSpec this$topicOperator = this.getTopicOperator();
        EntityTopicOperatorSpec other$topicOperator = other.getTopicOperator();
        if (this$topicOperator == null ? other$topicOperator != null : !((Object)this$topicOperator).equals(other$topicOperator)) {
            return false;
        }
        EntityUserOperatorSpec this$userOperator = this.getUserOperator();
        EntityUserOperatorSpec other$userOperator = other.getUserOperator();
        if (this$userOperator == null ? other$userOperator != null : !((Object)this$userOperator).equals(other$userOperator)) {
            return false;
        }
        Affinity this$affinity = this.getAffinity();
        Affinity other$affinity = other.getAffinity();
        if (this$affinity == null ? other$affinity != null : !this$affinity.equals(other$affinity)) {
            return false;
        }
        List<Toleration> this$tolerations = this.getTolerations();
        List<Toleration> other$tolerations = other.getTolerations();
        if (this$tolerations == null ? other$tolerations != null : !((Object)this$tolerations).equals(other$tolerations)) {
            return false;
        }
        TlsSidecar this$tlsSidecar = this.getTlsSidecar();
        TlsSidecar other$tlsSidecar = other.getTlsSidecar();
        if (this$tlsSidecar == null ? other$tlsSidecar != null : !((Object)this$tlsSidecar).equals(other$tlsSidecar)) {
            return false;
        }
        EntityOperatorTemplate this$template = this.getTemplate();
        EntityOperatorTemplate other$template = other.getTemplate();
        if (this$template == null ? other$template != null : !((Object)this$template).equals(other$template)) {
            return false;
        }
        Map<String, Object> this$additionalProperties = this.getAdditionalProperties();
        Map<String, Object> other$additionalProperties = other.getAdditionalProperties();
        return !(this$additionalProperties == null ? other$additionalProperties != null : !((Object)this$additionalProperties).equals(other$additionalProperties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EntityOperatorSpec;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        EntityTopicOperatorSpec $topicOperator = this.getTopicOperator();
        result = result * 59 + ($topicOperator == null ? 43 : ((Object)$topicOperator).hashCode());
        EntityUserOperatorSpec $userOperator = this.getUserOperator();
        result = result * 59 + ($userOperator == null ? 43 : ((Object)$userOperator).hashCode());
        Affinity $affinity = this.getAffinity();
        result = result * 59 + ($affinity == null ? 43 : $affinity.hashCode());
        List<Toleration> $tolerations = this.getTolerations();
        result = result * 59 + ($tolerations == null ? 43 : ((Object)$tolerations).hashCode());
        TlsSidecar $tlsSidecar = this.getTlsSidecar();
        result = result * 59 + ($tlsSidecar == null ? 43 : ((Object)$tlsSidecar).hashCode());
        EntityOperatorTemplate $template = this.getTemplate();
        result = result * 59 + ($template == null ? 43 : ((Object)$template).hashCode());
        Map<String, Object> $additionalProperties = this.getAdditionalProperties();
        result = result * 59 + ($additionalProperties == null ? 43 : ((Object)$additionalProperties).hashCode());
        return result;
    }
}

