/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model;

import io.strimzi.api.kafka.model.AbstractCrdIT;
import io.strimzi.api.kafka.model.KafkaUser;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class KafkaUserCrdIT
extends AbstractCrdIT {
    public static final String NAMESPACE = "kafkausercrd-it";

    @Test
    void testKafkaUserV1alpha1() {
        this.assumeKube1_11Plus();
        this.createDelete(KafkaUser.class, "KafkaUserV1alpha1.yaml");
    }

    @Test
    void testKafkaUserV1beta1() {
        this.createDelete(KafkaUser.class, "KafkaUserV1beta1.yaml");
    }

    @Test
    void testKafkaUserMinimal() {
        this.createDelete(KafkaUser.class, "KafkaUser-minimal.yaml");
    }

    @Test
    void testKafkaUserWithExtraProperty() {
        this.createDelete(KafkaUser.class, "KafkaUser-with-extra-property.yaml");
    }

    @BeforeAll
    void setupEnvironment() {
        this.cluster.createNamespace(NAMESPACE);
        this.cluster.createCustomResources(new String[]{"../install/cluster-operator/044-Crd-kafkauser.yaml"});
    }

    @AfterAll
    void teardownEnvironment() {
        this.cluster.deleteCustomResources();
        this.cluster.deleteNamespaces();
    }
}

